#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
NPROC_MAX=${NPROC_MAX-"3"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

L="
line-20-bdry
square-10-bdry
cube-5-bdry
"
EXPECT="
3e-4
1e-3
4e-3
"

for geo in $L; do
  err=`echo $EXPECT | awk '{print $1}'`
  EXPECT=`echo $EXPECT | awk '{for (i=2; i <= NF; i++) print $i}'`
  loop_mpirun "./neumann-laplace $SRCDIR/$geo P1 2>/dev/null | ./neumann-laplace-check $err 2>/dev/null >/dev/null"
  if test $? -ne 0; then status=1; fi
done

exit $status
