#include "rheolef.h"
using namespace rheolef;
using namespace std;

template <class T>
struct rounder_type : std::unary_function<T,T> {
  rounder_type (const T& prec) : _prec(prec) {}
  T operator() (const T& x) const { 
     T value = _prec*round(x/_prec);
     if (1+value == 1) value = 0;
     return value;
  }
  T _prec;
};
template <class T>
rounder_type<T> rounder (const T& prec) { return rounder_type<T>(prec); }

int main(int argc, char**argv) {
  environment distributed(argc, argv);
  Float prec = (argc > 1) ? atof(argv[1]) : 1e-10;
  field uh;
  dcin  >> uh;
  dcout << setprecision(15) << compose (rounder(prec),uh);
}
