///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// the geo_element hierarchy of classes
//
// author: Pierre.Saramito@imag.fr
//
// date: 19 december 2010
//
#include "rheolef/geo_element_v2.h"

namespace rheolef {

char
skip_blancs_and_tabs (std::istream& is)
{
    if (!is.good()) return 0;
    char c = is.peek();
    while (is.good() && (c == ' ' || c == '\t')) {
	is >> c;
    } while (is.good() && (c == ' ' || c == '\t'));
    return c;
}
/// @brief return orientation and shift between *this element and S
/** assume that vertices of *this and S match
 * this routine is used for domain elements identification
 *  shift     : such that vertex (*this)[0] == S[shift] matches
 *  orient=+1 : when (*this)[1] == S[shift+1]
 * return true when all is ok (does not check fully that elements match)
 */
bool
geo_element::get_orientation_and_shift (
    const geo_element& S,
    orientation_type&  orient,
    size_type&         shift) const
{
    orient = 0;
    shift  = std::numeric_limits<size_type>::max();
    if (S.dimension() != dimension() || S.size() != size()) return false;
    size_type n = size();
    for (shift = 0; shift < n; shift++) {
      if (operator[](0) == S[shift]) break;
    }
    if (shift == n) {
      shift = std::numeric_limits<size_type>::max();
      return false;
    }
    if ((*this)[(shift+1)%n] == S[(shift+1)%n]) {
      orient = 1;
    } else {
      orient = -1;
    }
    return true;
}

} // namespace rheolef
