#ifndef _RHEOLEF_INTERPOLATE_H
#define _RHEOLEF_INTERPOLATE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// 
// interpolation with a class-function or a function
//
#include "rheolef/tensor.h"
namespace rheolef { 

template <class T, class M, class Function>
field_basic<T,M> __interpolate_tag (const space_basic<T,M>& V, Function f, const T&)
{
  typedef typename field_basic<T,M>::size_type size_type;

  field_basic<T,M> u (V, std::numeric_limits<T>::max());
  for (size_type idof = 0, ndof = V.size(); idof < ndof; idof++) {
    u.dof (idof) = V.momentum (f, idof);
  }
  return u;
}
template <class T, class Func>
inline
field_basic<T>
interpolate (const space_basic<T>& V, Func f) {
    typedef typename Func::result_type  result_type ;
    return __interpolate_tag (V, f, result_type());
}
// specialization for functions:
template <class T>
inline
field_basic<T>
interpolate (const space_basic<T>& V, T (*f)(const basic_point<T>&)) {
    return __interpolate_tag (V, f, T());
}

}// namespace rheolef
#endif // _RHEOLEF_INTERPOLATE_H
