///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// discontinuous galerkin : rotating hill test
//

#include "rheolef.h"
using namespace rheolef;
using namespace std;
Float nu = 0;
point v (const point & x) { return point(-x[1], x[0]); }
struct phi : unary_function<point,Float> {
  Float operator() (const point& x) {
    point xc (0.25, 0, 0);
    Float sigma = 0.01;
    return sigma/(sigma + 4*nu*t)
        * exp(-(sqr( x[0]*cos(t) + x[1]*sin(t) - xc[0])
              + sqr(-x[0]*sin(t) + x[1]*cos(t) - xc[1]))/(sigma + 4*nu*t));
  }
  phi (Float tau) : t(tau) {}
  protected: Float t;
};
int main (int argc, char **argv) {
#ifdef _RHEOLEF_HAVE_UMFPACK
  geo omega (argv[1]);
  size_t n_max  = (argc > 2) ? atoi(argv[2]) : 24;
  Float Dt = 2*acos(-1.)/n_max;
  space Vh (omega, "P2","vector");
  field vh = interpolate (Vh, v);
  space Xh (omega, "P1d");
  field uh = interpolate(Xh, phi(0));
  form a0 (Xh, Xh, "d_dx0", vh[0]); //a0 = trans(a0);
  form a1 (Xh, Xh, "d_dx1", vh[1]); //a1 = trans(a1);
  form m  (Xh, Xh, "mass");
  form cv (Xh, Xh, "convect", vh);
  form a = a0 + a1 - cv + 1.0/Dt*m;
  cerr << "# # t\terror" << endl;
  branch event ("t","u");
  ssk<Float> a_fact = lu(a.uu);
  cout << event (0, uh);
  Float err_l2_l2 = 0;
  for (size_t n = 1; n <= n_max; n++) {
    Float t = Float(n)*Dt;
    field f = 1.0/Dt*(m*uh);
    uh.u = a_fact.solve(f.u);
    field e = uh - interpolate (Xh, phi(t));
    err_l2_l2 += m(e,e)*Dt;
    cout << event (t, uh);
    cerr << "# " << t << "\t" << sqrt(m(e,e)) << endl;
  }
  err_l2_l2 = sqrt(err_l2_l2);
  cerr << "err_l2_l2 = " << err_l2_l2 << endl;

// for non-regression test:
// on a 10x10 grid, expect a global L2(L2) error <= 0.56
//  ../bin/mkgeo_grid_2d 20 -a -0.5 -b 0.5 -c -0.5 -d 0.5 > square.geo

   return (err_l2_l2 < 0.56) ? 0 : 1;

#endif // _RHEOLEF_HAVE_UMFPACK
}
