#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"../../../rheolef/nfem/tst"}

export RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../basis"}
export RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../basis"}
export RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../form_element"}
# HAVE_LU_SOLVER=${HAVE_LU_SOLVER-"yes"}
if test x"${HAVE_LU_SOLVER}" = x""; then
    echo "        => skipped since UMFPACK is not available: no sparse LU factorization"
    exit 0
fi

status=0

command="../bin/mkgeo_grid_2d 20 -a -0.5 -b 0.5 -c -0.5 -d 0.5 > square.geo"
echo "      $command"
eval $command 2>/dev/null

command="./form_convect_dg2_tst square.geo 24"
echo "      $command"
eval $command >/dev/null 2>/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

/bin/rm -f square.geo
exit ${status}

