///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// Tests de boost::mpl en vue de la classe polymorphic_array
//
//  => templates recursifs
//     macros recursives aussi
//
// Author: Pierre.Saramito@imag.fr
//
// Date: 14 dec 2010
//
#include "rheolef/array.h"
#include "rheolef/pretty_name.h"

#include <typeinfo>
#include <boost/mpl/vector.hpp>
#include <boost/mpl/size.hpp>
#include <boost/mpl/for_each.hpp>
#include <boost/mpl/at.hpp>
#include <boost/mpl/transform.hpp>
#include <boost/mpl/copy.hpp>
using namespace rheolef;
using namespace std;
namespace mpl = boost::mpl;

struct print_name {
    template< typename U > void operator()(U x) {
        cerr << typename_macro(U) << endl;
    }
};
struct pretty_name {
    template< typename U > void operator()(U x) {
        cerr << pretty_typename_macro(U) << endl;
    }
};
// -----------------------------------------------------
// unary metafunction class:
// -----------------------------------------------------
struct container_of {
  template <class T>
  struct apply {
    typedef vector<T> type;
  };
};
// -----------------------------------------------------
// explicit recursion
// -----------------------------------------------------
template <class V, int N>
struct struct_of_aux {
};
template <class V>
struct struct_of_aux<V,0> {
};
template <class V>
struct struct_of_aux<V,1> : struct_of_aux<V,0> {
   typedef typename mpl::at_c<V,0>::type X0;
   typedef typename X0::value_type       T0;
   X0 _x0;
   struct_of_aux<V,1>() : struct_of_aux<V,0>(), _x0() {
	warning_macro ("cstor struct N=1: X0="<< typename_macro(X0));
   }
   void f(T0*) const { warning_macro ("f ("<< pretty_typename_macro(T0) << ")"); }
};
template <class V>
struct struct_of_aux<V,2> : struct_of_aux<V,1> {
   typedef typename mpl::at_c<V,1>::type X1;
   X1 _x1;
   struct_of_aux<V,2>() : struct_of_aux<V,1>(), _x1() {
	warning_macro ("cstor struct N=2: X1="<< typename_macro(X1));
   }
   typedef typename X1::value_type       T1;
   void f(T1*) const { warning_macro ("f ("<< pretty_typename_macro(T1) << ")"); }
   // remonte:
   typedef typename     struct_of_aux<V,1>::T0 T0;
   void f(T0*t) const { struct_of_aux<V,1>::f(t); }
};
template <class V>
struct struct_of_aux<V,3> : struct_of_aux<V,2> {
   typedef typename mpl::at_c<V,2>::type X2;
   X2 _x2;
   struct_of_aux<V,3>() : struct_of_aux<V,2>(), _x2() {
	warning_macro ("cstor struct N=3: X2="<< typename_macro(X2));
   }
   typedef typename X2::value_type       T2;
   void f(T2*) const { warning_macro ("f ("<< pretty_typename_macro(T2) << ")"); }
   // remonte
   typedef typename     struct_of_aux<V,2>::T0 T0;
   typedef typename     struct_of_aux<V,2>::T1 T1;
   void f(T0*t) const { struct_of_aux<V,2>::f(t); }
   void f(T1*t) const { struct_of_aux<V,2>::f(t); }
};
template <class V>
struct struct_of : struct_of_aux<V,mpl::size<V>::value> {
   // remonter les types & fcts membres
};
// -----------------------------------------------------
// double preprocessor recursion
// -----------------------------------------------------
#ifdef TODO
#include <boost/preprocessor/repetition.hpp>
#include <boost/preprocessor/arithmetic/sub.hpp>
#include <boost/preprocessor/punctuation/comma_if.hpp>

template <class V, int N>
struct struct_of_prepro {
};
template <class V>
struct struct_of_prepro<V,0> {
};

#define MY_print(z, n, data) data
#define MY_struct_of_prepro(z, n, unused)			\
template <class V>
struct struct_of_prepro<V,n> {
   typedef typename mpl::at_c<V,0>::type X0;
   typedef typename X0::value_type       T0;
   X0 _x0;
   struct_of_prepro<V,1>() : struct_of_prepro<V,0>(), _x0() {
	warning_macro ("cstor struct N=1: X0="<< typename_macro(X0));
   }
   void f(T0*) const { warning_macro ("f ("<< pretty_typename_macro(T0) << ")"); }
};
#endif // TODO
// -----------------------------------------------------
// application class
// -----------------------------------------------------
#ifdef TODO
template <class T, class V>
class polymorph_array 
 : struct_of< typename mpl::transform<V,container_of>::type > 
{
public:
  polymorph_array () {
        // 1) number of variants:
	int n_type = mpl::size<V>::value;
	cerr << "variants : " << n_type << endl;
        // 2) name of variants:
	mpl::for_each<V>(print_name());
  }
};
#endif // TODO
// ------------------------------------
// application
// ------------------------------------
struct none {};

struct element {};
struct edge : element {};
struct triangle : element {};
struct quadrangle : element {};
struct tetra : element {};
struct penta : element {};
struct hexa : element {};

typedef mpl::vector1<edge>                  v1d;
typedef mpl::vector2<triangle,quadrangle>   v2d;
typedef mpl::vector3<tetra,penta,hexa>      v3d;

int main(int argc, char**argv) {
  environment distributed (argc,argv);

  warning_macro ("1) test mpl::vector...");
  cerr << "size(v3d) = " << mpl::size<v3d>::value << endl;
  cerr << "v3d = " << endl;
  mpl::for_each<v3d>(print_name());

  warning_macro ("2) test transform...");
  typedef mpl::transform<v3d,container_of>::type vec_v3d;
  cerr << "vec_v3d := std::vector_of(v3d) = " << endl;
  mpl::for_each<vec_v3d>(print_name());

  warning_macro ("3) declare..");
  typedef struct_of_aux<vec_v3d,3> struct_v3d;
  struct_v3d data;
  //data.f((tetra*)0);
  data.f((hexa*)0);
  data.f((penta*)0);
  data.f((tetra*)0);
#ifdef TODO
  polymorph_array<element, v3d>  x;
#endif // TODO
};
