///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/rheolef.h"
#include "rheolef/cg.h"
using namespace rheolef;
using namespace std;

void usage()
{
      cerr << "form_diag_gen: usage: form_diag_gen"
	   << " name approx"
	   << " {-Igeodir}*"
	   << " -|mesh[.geo]"
	   << " {domain}+"
	   << endl;
      cerr << "example:\n"
           << " form_diag_gen mass P1 -I../data carre\n";
      exit (1);
}
int main(int argc, char**argv)
{
    if (argc <= 3) usage();
    //
    char* form_name = argv[1];
    char* approx_X  = argv[2];
    //
    // load geometry
    //
    geo g;
    int io = 3; 
    while (argv [io][0] == '-' && argv [io][1] == 'I') {
	append_dir_to_rheo_path (argv[io]+2);
	io++;
    }
    if (strcmp (argv[io], "-") == 0) {
	
	// input geo on standard input
        cerr << "! form_diag_gen: geo on stdin\n";
	cin >> g;
      
    } else {
    
	// input geo on file
  	g = geo(argv[io]);
    }
    //
    // build space & forms
    //
    space X(g, approx_X);
    
    for (int i = io+1; i < argc; i++) {
		      
      // block a domain
      cerr << "! form_diag_gen: block `" << argv[i] << "'\n";
      X.block (argv[i]);
    }
    form_diag a(X,form_name);
    cout << rheo << a;
}
