/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef RIPOFFPLUGIN_H
#define RIPOFFPLUGIN_H
#include "lib/RipOff.h"
#include "lib/RipOffTrack.h"
#include <dlfcn.h>

struct RipOffPluginRaw_
{
	gchar *name;
	gchar *label;
};
typedef struct RipOffPluginRaw_ * RipOffPluginRaw;

struct RipOffPlugin_
{
	RipOffPluginRaw raw;
	gpointer lib_handler;
};
typedef struct RipOffPlugin_ * RipOffPlugin;

/* Creates a new RipOffPlugin using the raw object and lib_path for function calls */
RipOffPlugin ripoff_plugin_new(RipOffPluginRaw raw, gpointer *lib_handler);

const gchar *ripoff_plugin_get_name(RipOffPlugin plugin);

const gchar *ripoff_plugin_get_label(RipOffPlugin plugin);

const gchar *ripoff_plugin_get_extension(RipOffPlugin plugin);

GtkWidget *ripoff_plugin_prefs(RipOffPlugin plugin);

GtkWidget *ripoff_plugin_about(RipOffPlugin plugin);

/* returns whether the plugin has a preferences dialog */
gboolean ripoff_plugin_has_prefs(RipOffPlugin plugin);

/* returns whether the plugin has an about dialog */
gboolean ripoff_plugin_has_about(RipOffPlugin plugin);

gboolean ripoff_plugin_perform_setup(	RipOffPlugin plugin,
					long total_bytes_to_encode,
					FILE *output_descriptor,
					RipOffTrack track);

gboolean ripoff_plugin_encode_buffer(	RipOffPlugin plugin,
					long total_bytes_to_encode,
					int16_t *audio_data,
					FILE *output_descriptor,
					RipOffTrack track);

gboolean ripoff_plugin_perform_cleanup(	RipOffPlugin plugin,
					long total_bytes_to_encode,
					FILE *output_descriptor,
					RipOffTrack track);

/* Informs the plugin that RipOff is shutting down and that it needs to save its settings
   accordingly */
void ripoff_plugin_close(RipOffPlugin plugin);

#endif
