/***************************************************************************
                          twintableundo  -  description
                             -------------------
    begin                : Fri Apr 7 2006
    copyright            : (C) 2006 by Thomas Friedrichsmeier
    email                : tfry@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TWINTABLEUNDO_H
#define TWINTABLEUNDO_H

#include "kcommand.h"

class TwinTableMember;

class TwinTableCommand : public KCommand {
public:
	TwinTableCommand (TwinTableMember *table, int row, int col, const QString &new_text);
	~TwinTableCommand ();
/** reimplemented from KCommand to return "Edit Cell" */
	QString name () const;
/** reimplemented from KCommand to redo editing the cell */
	void execute ();
/** reimplemented from KCommand to revert the cell */
	void unexecute ();
private:
	int row;
	int col;
	TwinTableMember *table;
	QString old_text;
	QString new_text;
};

class TwinTablePasteCommand : public KCommand {
public:
	TwinTableCommand (TwinTableMember *table, int top_row, int left_col, int bottom_row, int right_col, const QCString &old_content, const QCString &pasted);
	~TwinTableCommand ();
/** reimplemented from KCommand to return "Edit Cell" */
	QString name () const;
/** reimplemented from KCommand to redo pasting */
	void execute ();
/** reimplemented from KCommand to undo pasting */
	void unexecute ();
private:
	int top_row;
	int left_col;
	int bottom_row;
	int right_col;
	TwinTableMember *table;
	QCString before;
	QCString after;
};

class TwinTableUndo : public KCommandHistory {
public:
	TwinTableUndo (KActionCollection *actionCollection);
	~TwinTableUndo ();

/** basically a wrapper around KCommandHistory::addCommand () */
	void makeChange (TwinTableMember *table, int row, int col, const QString &new_text);
	void startBlock (const QString &name);
	void endBlock ();
private:
	TwinTableCommandSequence *current_block;
};

#endif
