// globals

function preprocess () {
  

echo ('  require(ltm)\n');
}

function calculate () {
  
  constraint   = getValue("constraint");
  startval     = getValue("startval");
  startval_mtx = getValue("startval_mtx");
  naaction     = getValue("naaction");
  irtparam     = getValue("irtparam");
  optimeth     = getValue("optimeth");
  verbose      = getValue("verbose");
  
  ghk_2pl      = getValue("ghk_2pl");
  iterem       = getValue("iterem");
  iterqn_2pl   = getValue("iterqn_2pl");
  interact     = getValue("interact");

  
  
  control = array() ;
  if(iterem != "40")
    control[] = "iter.em="+iterem ;
  if(iterqn_2pl != "150")
    control[] = "iter.qN="+iterqn_2pl ;
  if(ghk_2pl != "15")
    control[] = "GHk="+ghk_2pl ;
  if(optimeth != "BFGS")
    control[] = "method=\""+optimeth+"\"" ;
  if(verbose == "TRUE")
    control[] ="verbose=TRUE" ;

echo ('estimates.2pl <<- ltm(' + getValue("x") + ' ~ z1');
                  
                  if(interact == "TRUE") echo (" * z2");
                  if(constraint) echo (", constraint="+constraint);
                  if(irtparam != "TRUE") echo (", IRT.param=FALSE");
                  if(startval == "random") echo (", start.val=\"random\"");
                  if(startval == "matrix") echo (", start.val="+startval_mtx);
                  if(naaction) echo (", na.action="+naaction);
                  
                  if(control) echo (", control=list("+join(", ", control)+")");
 echo (')\n');
}

function printout () {
echo ('rk.header ("2PL parameter estimation")\n');
echo ('rk.print (estimates.2pl)\n');
}
