//simple.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2013
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#include "libroar.h"

static int roar_simple_stream_obj  (struct roar_stream * s, uint32_t rate, uint32_t channels, uint32_t bits, uint32_t codec, const char * server, int dir, const char * name, int mixer);

int roar_simple_connect (struct roar_connection * con, const char * server, const char * name) {
 return roar_simple_connect2(con, server, name, 0, 0);
}

int roar_simple_connect2(struct roar_connection * con, const char * server, const char * name, int flags, uint_least32_t timeout) {

 ROAR_DBG("roar_simple_connect(*): trying to connect...");

 if ( roar_connect(con, server, flags, timeout) == -1 ) {
  ROAR_DBG("roar_simple_connect(*): roar_connect() faild: %s", roar_errorstring);
  return -1;
 }

 if ( roar_identify(con, name) == -1 ) {
  ROAR_DBG("roar_simple_connect(*): roar_identify() faild: %s", roar_errorstring);
  return -1;
 }

 if ( roar_auth(con) == -1 ) {
  ROAR_DBG("roar_simple_connect(*): roar_auth() faild: %s", roar_errorstring);
  return -1;
 }

 return 0;
}

static int roar_simple_stream_obj  (struct roar_stream * s, uint32_t rate, uint32_t channels, uint32_t bits, uint32_t codec, const char * server, int dir, const char * name, int mixer) {
 struct roar_connection con;
 int ret;
 int safe_error;

 roar_debug_warn_sysio("roar_simple_stream_obj", NULL, NULL);

 if ( roar_simple_connect(&con, server, name) == -1 ) {
  ROAR_DBG("roar_simple_stream_obj(*): roar_simple_connect() faild!");
  ROAR_ERR("roar_simple_stream_obj(*): Can not connect to server");
  return -1;
 }

 if ( roar_stream_new(s, rate, channels, bits, codec) == -1 ) {
  safe_error = roar_error;
  roar_disconnect(&con);
  roar_err_set(safe_error);
  return -1;
 }

 if ( roar_stream_connect(&con, s, dir, mixer) == -1 ) {
  safe_error = roar_error;
  roar_disconnect(&con);
  roar_err_set(safe_error);
  return -1;
 }

 if ( roar_stream_exec(&con, s) == -1 ) {
  safe_error = roar_error;
  roar_disconnect(&con);
  roar_err_set(safe_error);
  return -1;
 }

 roar_libroar_nowarn();
 if ( (ret = roar_get_connection_fh(&con)) == -1 ) {
  safe_error = roar_error;
  roar_libroar_warn();
  roar_disconnect(&con);
  roar_err_set(safe_error);
  return -1;
 }
 roar_libroar_warn();

 if ( dir == ROAR_DIR_PLAY ) {
  (void)ROAR_SHUTDOWN(ret, SHUT_RD);
 } else if ( dir == ROAR_DIR_MONITOR || dir == ROAR_DIR_RECORD ) {
  (void)ROAR_SHUTDOWN(ret, SHUT_WR);
 }

 return ret;
}

int roar_simple_new_stream_attachexeced_obj (struct roar_connection * con, struct roar_stream * s, uint32_t rate, uint32_t channels, uint32_t bits, uint32_t codec, int dir, int mixer) {
 int fh;

 if ( (fh = roar_simple_stream_obj(s, rate, channels, bits, codec, roar_get_connection_server(con),
                                   dir, "libroar temp stream", mixer)) == -1 )
  return -1;

 if ( roar_stream_attach_simple(con, s, roar_get_clientid(con)) == -1 ) {
#ifdef ROAR_HAVE_IO_POSIX
  close(fh);
#endif /* no else as we return -1 anyway */
  return -1;
 }

 s->fh = fh;

 return fh;
}

int roar_simple_play_file(const char * file, const char * server, const char * name) {
 roar_vs_t * vss;
 int err;

 vss = roar_vs_new_from_file(server, name, file, &err);

 if ( vss == NULL ) {
  roar_err_set(err);
  return -1;
 }

 if ( roar_vs_run(vss, &err) == -1 ) {
  roar_vs_close(vss, ROAR_VS_TRUE, NULL);
  roar_err_set(err);
  return -1;
 }

 roar_vs_sync(vss, ROAR_VS_WAIT, NULL);
 roar_vs_close(vss, ROAR_VS_FALSE, NULL);

 return 0;
}

int roar_simple_connect_virtual(struct roar_connection * con, struct roar_stream * s, int parent, int dir) {
 struct roar_stream parent_stream;

 if ( con == NULL || s == NULL || parent < 0 )
  return -1;

 if ( dir == -1 ) {
  if ( roar_get_stream(con, &parent_stream, parent) == -1 )
   return -1;

  if ( (dir = roar_stream_get_dir(&parent_stream)) == -1 )
   return -1;
 }

 if ( roar_stream_set_rel_id(s, parent) == -1 )
  return -1;

 if ( roar_stream_connect(con, s, dir, -1) == -1 )
  return -1;

 if ( roar_stream_set_flags(con, s, ROAR_FLAG_VIRTUAL, ROAR_SET_FLAG) == -1 ) {
  roar_kick(con, ROAR_OT_STREAM, roar_stream_get_id(s));
  return -1;
 }

 return 0;
}

//ll
