//*.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2013
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#include "libroar.h"

static struct _group {
 unsigned int id;
 const char * name;
} _libroar_trap_groups[] = {
 {ROAR_TRAP_GROUP_LIBROAR, "libroar"},
 {ROAR_TRAP_GROUP_ROARD,   "roard"},
 {ROAR_TRAP_GROUP_APP,     "app"},
 {ROAR_TRAP_GROUP_LIB,     "lib"},
 {ROAR_TRAP_GROUP_NETWORK, "network"},
 {ROAR_TRAP_GROUP_PROTO,   "proto"},
 {-1, NULL}
};

unsigned int roar_trap_register_group(const char * name) {
 static unsigned int state = ROAR_TRAP_GROUP_USER_MIN;
 unsigned int ret;
 size_t i;

 for (i = 0;
      i < (sizeof(_libroar_trap_groups)/sizeof(*_libroar_trap_groups)) && _libroar_trap_groups[i].id != (unsigned int)-1;
      i++);
 if ( i == (sizeof(_libroar_trap_groups)/sizeof(*_libroar_trap_groups)) )
  return -1;

 ret = state++;
 _libroar_trap_groups[i].id   = ret;
 _libroar_trap_groups[i].name = name;

 return ret;
}

const char * roar_trap_get_groupname(const unsigned int group) {
 size_t i;

 for (i = 0;
      i < (sizeof(_libroar_trap_groups)/sizeof(*_libroar_trap_groups)) && _libroar_trap_groups[i].id != (unsigned int)-1;
      i++) {
  if ( _libroar_trap_groups[i].id == group )
   return _libroar_trap_groups[i].name;
 }

 return NULL;
}

unsigned int roar_trap_get_groupid(const char * name) {
 size_t i;

 for (i = 0;
      i < (sizeof(_libroar_trap_groups)/sizeof(*_libroar_trap_groups)) && _libroar_trap_groups[i].id != (unsigned int)-1;
      i++) {
  if ( !strcasecmp(_libroar_trap_groups[i].name, name) )
   return _libroar_trap_groups[i].id;
 }

 return -1;
}

void roar_strap_impl(const unsigned int group, const char * name, unsigned int line, const char * file, const char * prefix) {
#ifdef ROAR_SUPPORT_TRAP
 struct roar_libroar_config * config = roar_libroar_get_config();
 enum roar_trap_policy policy = config->trap_policy;

 // need to search for the correct policy for this specific trap.

 switch (policy) {
  case ROAR_TRAP_IGNORE:
    return;
   break;
  case ROAR_TRAP_WARN:
    ROAR_DBG("roar_strap_impl(group=%u(\"%s\"), name='%s', line=%u, file='%s') = (void)",
               group, roar_trap_get_groupname(group), name, line, file);
    roar_debug_msg(ROAR_DEBUG_TYPE_WARNING, line, file, prefix, "Trap %s of group %s.",
                   name, roar_trap_get_groupname(group));
   break;
  case ROAR_TRAP_ABORT:
    abort();
   break;
#ifdef SIGKILL
  case ROAR_TRAP_KILL:
    raise(SIGKILL);
   break;
#endif
#ifdef SIGSTOP
  case ROAR_TRAP_STOP:
    raise(SIGSTOP);
   break;
#endif
  case ROAR_TRAP_DIE:
    roar_debug_msg(ROAR_DEBUG_TYPE_WARNING, line, file, prefix, "Trap %s of group %s, terminating program.",
                   name, roar_trap_get_groupname(group));
#ifdef SIGKILL
    raise(SIGKILL);
#else
    abort();
#endif
   break;
 }
#else
 (void)group, (void)name, (void)line, (void)file, (void)prefix;
 return;
#endif
}

//ll
