//roarcatplay.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2013
 *
 *  This file is part of roarclients a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roaraudio.h>

#define BUFSIZE 1024

void usage (void) {
 printf("roarcatplay [OPTIONS]... [FILE]\n");

 printf("\nOptions:\n\n");

 printf("  --server SERVER    - Set server hostname\n"
        "  --simple           - Use the simple interface (default)\n"
        "  --verbose          - Use verbose output\n"
        "  --help             - Show this help\n"
       );

}

int main (int argc, char * argv[]) {
 const char * server   = NULL;
 const char * k;
 int    i;
 const char * file    = NULL;
 int    verbose = 0;
 roar_vs_t * vss;
 int err;

 for (i = 1; i < argc; i++) {
  k = argv[i];

  if ( strcmp(k, "--server") == 0 || strcmp(k, "-s") == 0 ) {
   server = argv[++i];
  } else if ( strcmp(k, "--simple") == 0 ) {
   /* no op */
  } else if ( strcmp(k, "--verbose") == 0 || strcmp(k, "-v") == 0 ) {
   verbose++;
  } else if ( strcmp(k, "--help") == 0 || strcmp(k, "-h") == 0 ) {
   usage();
   return 0;
  } else if ( file == NULL ) {
   file = argv[i];
  } else {
   fprintf(stderr, "Error: unknown argument: %s\n", k);
   usage();
   return 1;
  }
 }

 if ( file == NULL )
  file = "fh:stdin";

 if ( (vss = roar_vs_new_from_file(server, "roarcatplay", file, &err)) == NULL ) {
  ROAR_ERR("Can not start playback: %s", roar_error2str(err));
  return 1;
 }
 roar_vs_run(vss, NULL);
 roar_vs_sync(vss, ROAR_VS_WAIT, NULL);
 roar_vs_close(vss, ROAR_VS_FALSE, NULL);

 return 0;
}

//ll
