//fformat.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2012
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_FFORMAT_H_
#define _RPLD_FFORMAT_H_

#define RPLD_FF_PLF_NONE       0
#define RPLD_FF_PLF_RPLD       1
#define RPLD_FF_PLF_VCLT       2
#define RPLD_FF_PLF_PLS        3
#define RPLD_FF_PLF_M3U        4
#define RPLD_FF_PLF_XSPF       5
#define RPLD_FF_PLF_PLAIN      6
#define RPLD_FF_PLF_URAS       7

#define RPLD_FF_PLF_DEFAULT    RPLD_FF_PLF_VCLT

struct fformat_handle {
 int format;
 int table_id;
};

int          fformat_str2plf(const char * str);
const char * fformat_plf2str(int plf);

struct fformat_handle * fformat_handle_new(int format);
void                    fformat_handle_close(struct fformat_handle * handle);

int                     fformat_playlist_export(struct fformat_handle * handle,
                                                struct roar_vio_calls * vio,
                                                struct rpld_playlist  * pl);

int                     fformat_playlist_import(struct fformat_handle * handle,
                                                struct roar_vio_calls * vio,
                                                struct rpld_playlist  * pl);
int                     fformat_playlist_update(struct fformat_handle * handle,
                                                struct roar_vio_calls * vio,
                                                struct rpld_playlist  * pl);

// prototypes for ff_*.c:
int ff_vclt_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_vclt_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_plain_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_plain_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_m3u_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_m3u_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_rpld_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_rpld_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_pls_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_pls_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_xspf_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_xspf_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_uras_pl_export(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);
int ff_uras_pl_import(struct fformat_handle * handle, struct roar_vio_calls * vio, struct rpld_playlist  * pl);

#endif

//ll
