//yield.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2012
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_YIELD_H_
#define _RPLD_YIELD_H_

#define RPLD_YIELD_TASK_NONE          0x0000
#define RPLD_YIELD_TASK_ALL           0xFFFF
#define RPLD_YIELD_TASK_NETWORK       0x0001
#define RPLD_YIELD_TASK_PLAYBACK      0x0002
#define RPLD_YIELD_TASK_PLUGIN_UPDATE 0x0004
#define RPLD_YIELD_TASK_PLUGIN_TICK   0x0008
#define RPLD_YIELD_TASK_WATCHDOG      0x0010

#define RPLD_YIELD_NONBLOCK          0
#define RPLD_YIELD_BLOCK             1
#define RPLD_YIELD_LONGBLOCK         2

enum yield_auto {
 RPLD_YIELD_UNPAUSE = +64,
#define RPLD_YIELD_UNPAUSE          RPLD_YIELD_UNPAUSE
 RPLD_YIELD_START   = +1,
#define RPLD_YIELD_START            RPLD_YIELD_START
 RPLD_YIELD_TRIGGER =  0,
#define RPLD_YIELD_TRIGGER          RPLD_YIELD_TRIGGER
 RPLD_YIELD_STOP    = -1,
#define RPLD_YIELD_STOP             RPLD_YIELD_STOP
 RPLD_YIELD_PAUSE   = -64
#define RPLD_YIELD_PAUSE            RPLD_YIELD_PAUSE
};

void yield(int ptasks, int ntasks, int block);

void yield_auto(enum yield_auto cmd, int ptasks, int ntasks, int block);

void yield_watchdog_active(int active);
void yield_watchdog_start(void);
void yield_watchdog_stop(void);
void yield_watchdog_trigger(void);

#endif

//ll
