//playback.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2010
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _RPLD_PLAYBACK_H_
#define _RPLD_PLAYBACK_H_

#define PLAYBACK_MAX_CODECBL    16

#define PLAYBACK_PAUSE_TRUE      1
#define PLAYBACK_PAUSE_FALSE     0
#define PLAYBACK_PAUSE_TOGGLE    2

struct rpld_playback {
 int playing;
 struct {
  struct {
   struct roar_connection     con;
   struct roar_stream         stream;
   struct roar_mixer_settings mixer;
   int                        codecbl[PLAYBACK_MAX_CODECBL];
  } roaraudio;
 } backend;
 struct {
  struct roar_vio_calls   file;
  struct roar_vio_calls   stream;
  struct roar_vio_calls   filter;
  struct roar_vio_calls * fp;
 } io;
 struct {
  uint16_t mono; // scale is 2^16-1
 } volume;
 struct rpld_playlist_entry ple;
 size_t                     ple_mduc;
} g_playback;

int  playback_preinit(void);
int  playback_init(char * server);
void playback_uninit(void);

int  playback_blacklist_codec(int codec);

void playback_check(int block);

int  playback_play(void);
int  playback_next(void);
int  playback_prev(void);
int  playback_stop(int offset, int kick);
int  playback_pause(int how);

int  playback_is_playing(void);
char * playback_stream_identifier(void);

int  playback_is_pause(void);

int  playback_set_volume(void);

int  playback_set_volume_mu16(uint16_t mono); /* relative to 2^16-1 */
int  playback_set_volume_mpc(int pc);         /* in % */

uint16_t playback_get_volume_mu16(void);
int      playback_get_volume_mpc(void);

struct roar_stream * playback_get_stream (void);
struct rpld_playlist_entry * playback_get_ple (void);
size_t playback_get_mduc(void);

#endif

//ll
