//autoqueue.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2010
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "rpld.h"

int autoqueue(void) {
 struct rpld_playlist_entry * plent;
 struct rpld_playlist_entry * copy;
 struct rpld_playlist_search     pls;

 ROAR_DBG("autoqueue(void) = ?");

 if ( g_pointer[POINTER_CURRENT].pointer == NULL ) {
  ROAR_DBG("autoqueue(void): no current pointer");

  if ( g_pointer[POINTER_DEFAULT].pointer == NULL ) {
   ROAR_DBG("autoqueue(void): no default pointer");
   return -1;
  }

  ROAR_DBG("autoqueue(void): we have a default pointer at %p", g_pointer[POINTER_DEFAULT].pointer);

  if ( rpld_plp_copy(&(g_pointer[POINTER_CURRENT].pointer), g_pointer[POINTER_DEFAULT].pointer) == -1 ) {
   ROAR_DBG("autoqueue(void): copy of default pointer to current pointer failed");
   return -1;
  }

  if ( g_pointer[POINTER_DEFAULT].pointer == NULL ) {
   ROAR_DBG("autoqueue(void): still no current pointer");
   return -1;
  }
 }

 ROAR_DBG("autoqueue(void): we have a current pointer at %p", g_pointer[POINTER_CURRENT].pointer);

 if ( (plent = rpld_plp_search(g_pointer[POINTER_CURRENT].pointer)) == NULL )
  return -1;

 if ( (copy = rpld_ple_copy(plent)) == NULL )
  return -1;

 rpld_pl_push(g_queue, copy);

 if ( !( g_pointer[POINTER_CURRENT].pointer->pls.type == RPLD_PL_ST_RANDOM          ||
         g_pointer[POINTER_CURRENT].pointer->pls.type == RPLD_PL_ST_RANDOM_LIKENESS ) ) {
         
  if ( rpld_plp_uninit(g_pointer[POINTER_CURRENT].pointer) == 0 ) {
   g_pointer[POINTER_CURRENT].pointer = NULL;

   if ( plent->list.next != NULL ) {
    plent = plent->list.next;

    memset(&pls, 0, sizeof(pls));

#ifdef HAVE_LIB_UUID
    pls.type = RPLD_PL_ST_UUID;

    uuid_copy(pls.subject.uuid, plent->uuid);
#else
    pls.type = RPLD_PL_ST_TRACKNUM_LONG;

    pls.subject.long_tracknum = plent->global_tracknum;
#endif

    g_pointer[POINTER_CURRENT].pointer = rpld_plp_init(NULL, &pls);
   }
  }
 }

 return 0;
}

//ll
