/***************************************************************************
 *            strobelight.c
 *
 *  Sun Dec 26 17:06:45 2004
 *  Copyright  2004  Benedikt 'Hunz' Heinz
 *  rocklight@hunz.org
 *  $Id: strobelight.c,v 1.2 2005/03/26 21:29:17 hunz Exp $
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include "thinklight.h"

int run=1;

void handler(int num) {
	printf("quit\n");
	run=0;
}

int main(int argc, char **argv) {
	int fd, ret=0, saved, on=30000, off=30000;
	
	if(argc>2) {
		on=strtoul(argv[1],NULL,0)*1000;
		off=strtoul(argv[2],NULL,0)*1000;
	}
	else if(argc>1)
		on=off=strtoul(argv[1],NULL,0)*1000;
	
	if(!on) {
		printf("usage: %s (<on time> (<off time>))\n",argv[0]);
		return 0;
	}
	
	if((fd=thinklight_open())<0) {
		fprintf(stderr,"can't open thinklight: %d\n",fd);
		return 23;
	}
	
	if((saved=thinklight_get(fd))<0) {
		fprintf(stderr,"can't read thinklight status: %d\n",saved);
		thinklight_close(fd);
		return 23;
	}
	else
		printf("saving thinklight status: %s\n",saved?"on":"off");
	
	printf("on time: %dmsec, off time: %dmsec\n",on/1000,off/1000);
	
	signal(SIGINT, handler);
	
	do {
		
		if((ret=thinklight_set(fd,0))<=0)
			break;
		usleep(off);
		
		if((ret=thinklight_set(fd,1))<=0)
			break;
		usleep(on);
		
	} while(run);
	
	if(ret<0)
		fprintf(stderr,"error %d writing thinklight status!\n",ret);
	
	printf("restoring thinklight status: %s\n",saved?"on":"off");
	if((ret=thinklight_set(fd,saved))<=0)
		fprintf(stderr,"error %d writing thinklight status!\n",ret);
	
	thinklight_close(fd);
	
	return 0;
}
