#ifndef OVERRIDEMENU_H
#define OVERRIDEMENU_H

#include <gtk/gtk.h>
#include "../dataset.h"
#include "../path.h"

class ModuleModifier;
class Module;

class OverrideMenu
{
public:
        OverrideMenu(const Path& mod_,
                     ModuleModifier& parent_,
                     const Path& targetModule_);
        GtkWidget* getWidget() {return hbox;}
        bool widgetValid() {return hbox != 0;}
                        
        void overrideClicked();
        void loadOverrides();
        void removeSticky(const string& name);
        
        const DataSet& getSticky() const {
                return sticky;
        }               
                
private:
        Path mod, targetModule;
        
        ModuleModifier& parent;
        GtkWidget* hbox;
        GtkWidget* menu;
        
        DataSet sticky;
};

#endif
