#ifndef MODULEINFO_H
#define MODULEINFO_H

#include "datasetmap.h"
#include "module.h"
#include <string>
using namespace std;

class ModuleInfo
{
public:
        typedef Module* ModuleConstructor();
        ModuleInfo() {
        }
        ModuleInfo(ModuleConstructor* c, const DataSetMap& modInf_)
                : modInf(modInf_), constructor_(c) {
        }
        void set(ModuleConstructor* c, const DataSetMap& modInf_);
        void checkModuleInfo() const;

        const DataSetMap& module_info() const {
                return modInf;
        }
        ModuleConstructor *constructor() const {
                return constructor_;
        }
                        
private:
        DataSetMap modInf;
        ModuleConstructor* constructor_;
};
        

#endif
