#include "process.h"
#include "../../module_registry.h"

DataSetMap *Procload::moduleInfo = 0;
DataSetMap *Procclose::moduleInfo = 0;
static ProcessMonitor processmonitor;

Module* procclose_constructor()
{
        return new Procclose();
}

Module* procload_constructor()
{
        return new Procload();
}

const DataSetMap& Procload::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Monitor creation of processes"));
                moduleInfo->set("supported_vars", DataSet("format"));
                moduleInfo->set("supported_var_types", DataSet("string"));
                moduleInfo->set("supported_var_defaults", DataSet("$(timestamp) >>> $(process_name)[$(pid)]"));
                moduleInfo->set("overridable", DataSet("false"));
                moduleInfo->set("output_variables", DataSet("timestamp,pid,process_name,textline"));
        }
        return *moduleInfo;
}

const DataSetMap& Procclose::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Monitor destruction of processes"));
                moduleInfo->set("supported_vars", DataSet("format"));
                moduleInfo->set("supported_var_types", DataSet("string"));
                moduleInfo->set("supported_var_defaults", DataSet("$(timestamp) <<< $(process_name)[$(pid)]"));
                moduleInfo->set("overridable", DataSet("false"));
                moduleInfo->set("output_variables", DataSet("timestamp,pid,process_name,textline"));
        }
        return *moduleInfo;
}

extern "C" int process_plugin_startup()
{
        ModuleRegistry::instance()->add_module("ProcessLoad", &procload_constructor, Procload::get_module_info_instance());
        ModuleRegistry::instance()->add_module("ProcessClose", &procclose_constructor, Procclose::get_module_info_instance());
        return 0;
}

extern "C" void process_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("ProcessLoad");
        ModuleRegistry::instance()->remove_module("ProcessClose");
        Procload::destroy_module_info();
        Procclose::destroy_module_info();
}

ProcessMonitor::ProcessMonitor()
{
        // shame we have to use malloc instead of new, but we want to be able to
        // do a realloc
        pids_size = 200;
        pids = reinterpret_cast<int *> (malloc(pids_size * sizeof(int)));
        ppids = reinterpret_cast<int *> (malloc(pids_size * sizeof(int)));
        names = reinterpret_cast<char **> (malloc(pids_size * sizeof(char *)));
        pnames = reinterpret_cast<char **> (malloc(pids_size * sizeof(char *)));
        pstats = reinterpret_cast<int *> (malloc(pids_size * sizeof(int)));
        pids[0] = 0;
        
        if ((procDirHandle = opendir("/proc")) == NULL)
                cerr << "Error opening /proc filesystem." << endl;

        read_processes(false);
}

ProcessMonitor::~ProcessMonitor()
{
        int i;
        
	closedir(procDirHandle);
        free(pids);
        free(ppids);
        free(pstats);
        
        for (i = 0; pids[i]; i++) {
                if (names[i])
                        delete [] names[i];
        }
        free(names);
        
        for (i = 0; pids[i]; i++) {
                if (pnames[i])
                        delete [] pnames[i];
        }
        free(pnames);
}

void ProcessMonitor::read_process_info(int index)
{
	FILE* redir;
        char statfile[30];
        sprintf(statfile, "/proc/%d/stat", pids[index]);
        if ((redir = fopen(statfile, "r")) != NULL) {
                char *line = new char[2048];
                if (fgets(line, 2048, redir) != NULL) {
                        line[2047] = 0;
                        char *progname = new char[2048];
                        int ppid;
                        sscanf(line, "%*d (%s %*c %d", progname, &ppid);
                        // strip the ')'
                        progname[strlen(progname) - 1] = 0;

                        ppids[index] = ppid;
                        if (names[index])
                                delete[] names[index];
                        names[index] = new char[strlen(progname) + 1];
                        strcpy(names[index], progname);
                        
                        delete[] progname;
                }
                fclose(redir);
                delete[] line;
        }
}

void ProcessMonitor::process_start(int index)
{
        for (vector<Procchange*>::iterator i = clients.begin(); i != clients.end(); ++i)
                (*i)->load(timestamp, pids[index], names[index]);
}
        
void ProcessMonitor::process_end(int index)
{ 
        for (vector<Procchange*>::iterator i = clients.begin(); i != clients.end(); ++i)
                (*i)->close(timestamp, pids[index], names[index]);
}

void ProcessMonitor::read_processes(bool notify_new)
{
        int pid;
        int write_index = 0;
        int read_index = 0;
        
        while (true)
	{
		thedir = readdir(procDirHandle);
		if (thedir == NULL)
			break;
		pid = strtol(thedir->d_name, 0, 0);
                if (pid) {
                        if (write_index + 1 >= pids_size) {
                                // reallocation required - double it
                                pids_size *= 2;
                                pids = reinterpret_cast<int *> (realloc(pids, pids_size * sizeof(int)));
                                ppids = reinterpret_cast<int *> (realloc(ppids, pids_size * sizeof(int)));
                                names = reinterpret_cast<char **> (realloc(names, pids_size * sizeof(char *)));
                                pnames = reinterpret_cast<char **> (realloc(pnames, pids_size * sizeof(char *)));
                                pstats = reinterpret_cast<int *> (realloc(pstats, pids_size * sizeof(int)));
                        }
                        bool process_is_new = false;
                        while (pids[read_index] != pid) {
                                if (pids[read_index]) {
                                        if (pstats[read_index] < 0)
                                                process_end(read_index);
                                        if (names[read_index])
                                            delete [] names[read_index];
                                        names[read_index] = 0;
                                        if (pnames[read_index])
                                            delete [] pnames[read_index];
                                        pnames[read_index] = 0;
                                        read_index++;
                                } else {
                                        pids[write_index] = pid;
                                        pids[write_index + 1] = 0;
                                        names[write_index] = 0;
                                        pnames[write_index] = 0;
                                        ppids[write_index] = 0;
                                        pstats[write_index] = 10;
                                        process_is_new = true;
                                        break;
                                }
                        }
                        if (read_index != write_index && !process_is_new) {
                                pids[write_index] = pid;
                                ppids[write_index] = ppids[read_index];
                                names[write_index] = names[read_index];
                                pnames[write_index] = pnames[read_index];
                        }
                        
                        write_index++;
                        if (pids[read_index])
                                read_index++;
                }
	}
        while (pids[read_index]) {
                if (pstats[read_index] < 0)
                        process_end(read_index);
                if (names[read_index])
                        delete [] names[read_index];
                names[read_index] = 0;
                if (pnames[read_index])
                        delete [] pnames[read_index];
                pnames[read_index] = 0;
                pids[read_index] = 0;
                read_index++;
        }

        // should be enough space, 'cause we allowed for +1 before
        pids[write_index] = 0;

        for (int i = 0; pids[i]; i++) {
                if (pstats[i] > 0) {
                        read_process_info(i);
                        if (ppids[i]) {
                                int j;
                                for (j = 0; pids[j] != ppids[i] && pids[j]; j++);
                                if (pids[j]) {
                                        read_process_info(j);
                                        if (names[i] && names[j]) {
                                                if (strcmp(names[i], names[j])) {
                                                        pnames[i] = new char[strlen(names[j]) + 1];
                                                        strcpy(pnames[i], names[j]);
                                                        if (notify_new)
                                                                process_start(i);
                                                        pstats[i] = -1;
                                                }
                                        }
                                        pstats[i]--;
                                }
                        }
                }
        }
        
	rewinddir(procDirHandle);
}

void ProcessMonitor::service()
{ 
       	/* Build Timestamp */
	time_t t = time(0);
	struct tm *tblock = localtime(&t);
	t = mktime(tblock);
	string text = ctime(&t);
	timestamp = ctime(&t);
        timestamp = string(timestamp, 0, timestamp.length() - 1);
        
        read_processes(true);
}

void ProcessMonitor::addClient(Procchange* c)
{
        clients.push_back(c);
}

void ProcessMonitor::removeClient(Procchange* c)
{
        for (vector<Procchange*>::iterator i = clients.begin(); i < clients.end(); ++i)
                if (*i == c)
                        clients.erase(i);
}

Procchange::Procchange()
{
        processmonitor.addClient(this);
}

Procchange::~Procchange()
{
        processmonitor.removeClient(this);
}

void Procchange::service()
{
        Module::service();
        processmonitor.service();
}

void Procchange::updated(const string& keyName, const DataSet& data)
{
        if (keyName == "format")
                format = data;
}

void Procload::load(const string& timestamp, int pid, const string& processName)
{
        addToOutput("timestamp", DataSet(timestamp));
        addToOutput("pid", DataSet(pid));
        addToOutput("process_name", DataSet(processName));
        addToOutput("textline", format);
        sendOutput();
}

void Procclose::close(const string& timestamp, int pid, const string& processName)
{
        addToOutput("timestamp", DataSet(timestamp));
        addToOutput("pid", DataSet(pid));
        addToOutput("process_name", DataSet(processName));
        addToOutput("textline", format);
        sendOutput();
}


