#ifndef PROCESSMONITOR_H
#define PROCESSMONITOR_H

#include <dirent.h>
#include <sys/time.h>
#include <cstdlib>
#include <cstdio>
#include <vector>
using namespace std;

#include "../../module.h"

class Procchange;

class ProcessMonitor
{
public:
        ProcessMonitor();
        ~ProcessMonitor();
        void addClient(Procchange* c);
        void removeClient(Procchange* c);
	void service();
        
private:
        void read_processes(bool notify_new);
        void read_process_info(int index);
        
        void process_start(int index);
        void process_end(int index);
        
private:
        struct dirent *thedir;
        DIR *procDirHandle;
        
        int pids_size; // size of each of the following allocations
        int *pids;
        int *ppids; // pid of parent process
        char **names;
        char **pnames; // name of parent process
        int *pstats; // positive - waiting for exec
        // zero - gave up waiting
        // negative - got a name change (presumably an exec)

        string timestamp;
        
        vector<Procchange *> clients;
};

class Procchange : public Module
{
public:
        Procchange();
        ~Procchange();
	void service();
        virtual void load(const string& timestamp, int pid, const string& processName) {};
        virtual void close(const string& timestamp, int pid, const string& processName) {};

protected:
        void Procchange::updated(const string& keyName, const DataSet& data);
        DataSet format;
};

class Procload : public Procchange
{
public:
        void load(const string& timestamp, int pid, const string& processName);

        ~Procload() {
                rpdbgmsg(getName() << " module destroyed");
        }
        
        virtual string getName() {
                return "ProcessLoad";
        }

        virtual const DataSetMap& get_module_info() {
                return get_module_info_instance();
        }
        static const DataSetMap &get_module_info_instance();

        static void destroy_module_info() {
                if (moduleInfo)
                        delete moduleInfo;
                moduleInfo = 0;
        }                
private:
        static DataSetMap* moduleInfo;
};

class Procclose : public Procchange
{
public:
        void close(const string& timestamp, int pid, const string& processName);

        ~Procclose() {
                rpdbgmsg(getName() << " module destroyed");
        }
        
        virtual string getName() {
                return "ProcessClose";
        }
        virtual const DataSetMap& get_module_info() {
                return get_module_info_instance();
        }
        static const DataSetMap &get_module_info_instance();

        static void destroy_module_info() {
                if (moduleInfo)
                        delete moduleInfo;
                moduleInfo = 0;
        }                
private:
        static DataSetMap* moduleInfo;
};

#endif
