#include "roottext.h"
#include "../../module_registry.h"

extern "C" {
#include "../../toon.h"
}

DataSetMap *Roottext::moduleInfo = 0;

Module* roottext_constructor()
{
        return new Roottext();
}

const DataSetMap& Roottext::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Display text on the root window"));
                moduleInfo->set("supported_vars", DataSet("xpos,ypos,width,height,colour,font,draw_background,background_colour,timed_redraw,timed_redraw_skip"));
                moduleInfo->set("supported_var_types", DataSet("int,int,int,int,colour,font,bool,colour,bool,int"));
                moduleInfo->set("supported_var_defaults", DataSet("0,0,600,100,#FFFFFF,-*-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*,false,#000000,false,10"));
                moduleInfo->set("overridable", DataSet("false,false,false,false,true,true,false,true,false,false"));
        }
        return *moduleInfo;
}

extern "C" int roottext_plugin_startup()
{
        ModuleRegistry::instance()->add_module("Roottext", &roottext_constructor, Roottext::get_module_info_instance());
        return 0;
}

extern "C" void roottext_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("Roottext");
        Roottext::destroy_module_info();
}

Roottext::Roottext()
        : cycle(0)
{
        openDisplay();
        disp = getDisplay();
        if (disp) {
                /* Create Window */
                XGCValues gcv;
                gcv.graphics_exposures = True;
//                  root = XCreateSimpleWindow(disp, RootWindow(disp,DefaultScreen(disp)), 0, 0, 1400, 1000, 0, 0, 0);
                //root = XCreateWindow (disp,DefaultRootWindow(disp),0,0,1400,1000,0,Copy-FromParent,InputOutput,Copy-FromParent,
//                  root = XRootWindow(disp,DefaultScreen(disp));
                //XSetStandardProperties(disp,root,"My Window","HI!",None,NULL,0,NULL);
//                  WinGC = XCreateGC(disp,win,GCBackground,&gcv);
//                  XMapWindow(disp,root);

                // setup defaults
                font = XLoadFont(disp, "-*-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*");
                fontinfo = XQueryFont(disp, font);
                
                spacing = fontinfo->max_bounds.ascent;
                
                set_width(100);
                set_height(600);
                set_x(0);
                set_y(0);
        }
}

Roottext::~Roottext()
{
        erase();
//  	XSync(disp, true);
//  	XSync(disp, false);

        // this seems to crash
	// XFreeFontInfo(0, fontinfo, 1);
	XUnloadFont(disp, font);

        closeDisplay();
        rpdbgmsg(getName() << " module destroyed");
}

//  void Roottext::clear()
//  {
//   	XClearArea(disp, root, x, y, w, h, true);

	// Experimental Code
	/*
	XImage *theimage = XGetImage(disp,root,x,y,w,h,65535,ZPixmap);
       	for (int a=0; a<w; a+=3)
	  for (int b=0; b<h; b+=2) {
	    Pixel tmp = XGetPixel (theimage,a,b);
	    tmp--;
	    XPutPixel (theimage,a,b,0);
	    XPutPixel (theimage,a+1,b,0);
	    }
	XAddPixel (theimage,0x000100);
	XPutImage (disp,root,WinGC,theimage,0,0,x,y,w,h);
	XDestroyImage (theimage); */
//  }

void Roottext::redraw(XExposeEvent *ev)
{
        XSetFont(disp, gc, font);
        int top_exposed = get_y();
        int bottom_exposed = get_y() + get_height();

        if (ev != NULL) {
                top_exposed = ev->y;
                bottom_exposed = ev->y + ev->height;
        }
        
        //XDrawRectangle(disp, root, gc, get_x(), get_y(), get_width(), get_height());
        
        int offset = 0;
        if (lineColours.size() > 0) {
                // figure out how many lines we can fit
                int i = lines.size() - 1;
                int yp = get_height();
                while (i > 0) {
                        yp -= (fontinfo->max_bounds.ascent + fontinfo->max_bounds.descent);
                        if (yp < 0)
                                break;
                        i--;
                }
                i++;

                Pixel p = lineColours[i];
                XSetForeground(disp, gc, p);
                Pixel bg = bgColours[i];
                XSetBackground(disp, gc, bg);
                yp = get_y();
                for (; i < lines.size(); i++) {
                        if (p != lineColours[i]) {
                                p = lineColours[i];
                                XSetForeground(disp, gc, p);
                        }
                        if (bg != bgColours[i]) {
                                bg = bgColours[i];
                                XSetBackground(disp, gc, bg);
                        }
                        int yp_inc = (fontinfo->max_bounds.ascent + fontinfo->max_bounds.descent);
                        if (yp + yp_inc >= top_exposed && yp <= bottom_exposed) {
                                if (draw_background)
                                        XDrawImageString(disp, root, gc, get_x() + 1, yp + fontinfo->max_bounds.ascent,
                                                         lines[i].c_str(), lines[i].length());
                                else
                                        XDrawString(disp, root, gc, get_x() + 1, yp + fontinfo->max_bounds.ascent,
                                                    lines[i].c_str(), lines[i].length());
                        }
                        yp += yp_inc;
                }
        }

        ///////////////
        // test stuff beneath this line

//          XImage *im = XGetImage(disp, root, 0, 0, 200, 200, 1, XYPixmap);
//          cout << (void *) im << endl;
//          XPutImage(disp, root, gc, im, 0, 0, 300, 300, 200, 200);
//          cout << "////////\n";
//          XCopyArea(disp, root, root, gc, 0, 0, 200, 200, 300, 300);
        // test stuff above this line
        /////////////
        
//          XSync(disp, true);
//          XSync(disp, false);
}

void Roottext::updated(const string& keyName, const DataSet& data)
{
        if (keyName == "textline") {
                display();
        } else if (keyName == "xpos") {
                set_x(data.getInt());
        } else if (keyName == "ypos") {
                set_y(data.getInt());
        } else if (keyName == "width") {
                set_width(data.getInt());
        } else if (keyName == "height") {
                set_height(data.getInt());
        } else if (keyName == "length") { // backward compatability
                set("height", DataSet(data.getInt() * fontinfo->max_bounds.ascent
                                      + fontinfo->max_bounds.descent));
        } else if (keyName == "colour") {
                colour = getColour(data.getString());
        } else if (keyName == "font") {
                font = XLoadFont(disp, data.getString().c_str());
                fontinfo = XQueryFont(disp, font);
                erase();
                redraw(NULL);
        } else if (keyName == "background_colour") {
                bgcolour = getColour(data.getString());
        } else if (keyName == "draw_background") {
                draw_background = data.getBool();
        } else if (keyName == "timed_redraw") {
                timed_redraw = data.getBool();
        } else if (keyName == "timed_redraw_skip") {
                timed_redraw_skip = data.getInt();
        }
}

/* writes 'textline' to the display */
void Roottext::display()
{
        string textline;
        env.getExpanded(textline, "textline");

        unsigned int count = 0, tmp;
        for (tmp = 1; tmp <= textline.length(); tmp++) {
                if (XTextWidth(fontinfo, &textline.c_str()[count], tmp - count) > get_width()) {
                        insert(textline, count, tmp - count - 1);
                        count = tmp - 1;
                }
        }
        insert(textline, count, tmp - count);
        redraw(NULL);
}

void Roottext::service()
{
        Module::service();
        DrawingArea::service();

        if (timed_redraw) {
                if (--cycle <= 0) {
                        redraw(NULL);
                        cycle = timed_redraw_skip;
                }
        }
}

void Roottext::insert(const string& textline, int start, int size)
{
        erase();
        // we store twice as many lines as we potentially have room for,
        // in case we have mixed fonts and can fit more
        if (lines.size() > 2 * get_height() / (fontinfo->ascent + fontinfo->descent)) {
                lines.erase(lines.begin());
                lineColours.erase(lineColours.begin());
                bgColours.erase(bgColours.begin());
        }
        lines.push_back(string(textline, start, size));
        lineColours.push_back(colour);
        bgColours.push_back(bgcolour);
        redraw(NULL);
}

Pixel Roottext::getColour(const string& colourName)
{
	XColor colour;
	XWindowAttributes attributes;

	XGetWindowAttributes(disp, root, &attributes);

	colour.pixel = 0;

	if (!XParseColor(disp, attributes.colormap, colourName.c_str(), &colour))
		cerr << "can't parse " << colourName << endl;
	else if(!XAllocColor(disp, attributes.colormap, &colour))
		cerr << "can't allocate " << colourName << endl;
	return colour.pixel;
}

