#include "systemload.h"
#include "../../module_registry.h"

DataSetMap *SystemLoad::moduleInfo = 0;

#define FILENAME "/proc/stat"

Module* systemload_constructor()
{
        return new SystemLoad();
}

const DataSetMap& SystemLoad::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Monitors system CPU usage"));
                moduleInfo->set("supported_vars", DataSet());
                moduleInfo->set("supported_var_types", DataSet());
                moduleInfo->set("supported_var_defaults", DataSet());
                moduleInfo->set("overridable", DataSet());
                moduleInfo->set("output_variables", DataSet("cpu_user,cpu_nice,cpu_system,cpu_total"));
        }
        return *moduleInfo;
}

extern "C" int systemload_plugin_startup()
{
        ModuleRegistry::instance()->add_module("SystemLoad", &systemload_constructor, SystemLoad::get_module_info_instance());
        return 0;
}

extern "C" void systemload_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("SystemLoad");
        SystemLoad::destroy_module_info();
}

SystemLoad::SystemLoad()
        : loopCount(0),
          first(true)
{
        file = fopen(FILENAME, "rb");
}

SystemLoad::~SystemLoad()
{
        if (file != NULL) {
                if (verbose)
                        cout << "closing: \"" << FILENAME << "\"" << endl;
                fclose(file);
        }
        rpdbgmsg(getName() << " module destroyed");
}

void SystemLoad::updated(const string& keyName, const DataSet& data)
{
}

void SystemLoad::service()
{
        Module::service();

        loopCount++;
        if (loopCount > 30) {
                file = freopen(FILENAME, "rb", file);
                fseek(file, 0, SEEK_SET);

                int user, nice, system, idle, ticks, total;
                fscanf(file, " cpu %d %d %d %d", &user, &nice, &system, &idle);
                total = user + nice + system;
                ticks = total + idle;
                
                int d_user = user - last_user;
                int d_nice = nice - last_nice;
                int d_system = system - last_system;
                int d_ticks = ticks - last_ticks;
                int d_total = total - last_total;

                last_user = user;
                last_nice = nice;
                last_system = system;
                last_ticks = ticks;
                last_total = total;

                if (!first) {
                        addToOutput("cpu_user", DataSet((d_user * 100) / d_ticks));
                        addToOutput("cpu_nice", DataSet((d_nice * 100) / d_ticks));
                        addToOutput("cpu_system", DataSet((d_system * 100) / d_ticks));
                        addToOutput("cpu_total", DataSet((d_total * 100) / d_ticks));
                        sendOutput();
                }

                first = false;
                loopCount = 0;
        }
}
