#include "common.h"

#include <string>
#include <fstream>
#include <sys/types.h>
#include <signal.h>
using namespace std;

#include "utils.h"

#include <panel-applet.h>
#include <gtk/gtk.h>

#include "root-portal.xpm"

static int get_rp_pid()
{
        // assumes that the environment variable, DISPLAY is set
        // correctly (ie it wasn't explicitly set with -d etc)
        string lockfilename = string(getenv("HOME"))
            + "/" CONFIG_DIR "/lock." + string(getenv("DISPLAY"));
        ifstream lockfile;
        lockfile.open(lockfilename.c_str(), ios::in);
        if (lockfile.is_open()) {
                int pid;
                lockfile >> pid;
                lockfile.close();
                string check_for = "root-portal";
                string other_exe = get_exe(pid);
                if (other_exe.length() >= check_for.length()) {
                        string prog(other_exe, other_exe.length() - check_for.length(),
                                    check_for.length());
                        if (prog != check_for)
                                return 0;
                } else {
                        return 0;
                }
                return pid;
        }
        return 0;
}

static void startup_cb(BonoboUIComponent *uic,
                       gpointer data,
                       const gchar *verbname)
{
        if (!get_rp_pid()) {
                system("root-portal -n &");
        }
}

static void shutdown_cb(BonoboUIComponent *uic,
                        gpointer data,
                        const gchar *verbname)
{
        int rppid = get_rp_pid();
        if (rppid) {
                kill(rppid, SIGTERM);
        }
}

static void configure_cb(BonoboUIComponent *uic,
                         gpointer data,
                         const gchar *verbname)
{
        int rppid = get_rp_pid();
        if (rppid) {
                kill(rppid, SIGUSR2);
        } else {
                system("root-portal -c &");
        }
}

static const BonoboUIVerb rp_menu_verbs [] = {
        BONOBO_UI_UNSAFE_VERB("RPStartup", startup_cb),
        BONOBO_UI_UNSAFE_VERB("RPShutdown", shutdown_cb),
        BONOBO_UI_UNSAFE_VERB("RPConfigure", configure_cb),

        BONOBO_UI_VERB_END
};

static const char rp_menu_xml [] =
        "<popup name=\"button3\">\n"
        "   <menuitem name=\"Startup Item\" verb=\"RPStartup\" _label=\"Startup ...\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-properties\"/>\n"
        "   <menuitem name=\"Shutdown Item\" verb=\"RPShutdown\" _label=\"Shutdown\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-help\"/>\n"
        "   <menuitem name=\"Configure Item\" verb=\"RPConfigure\" _label=\"Configure ...\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-properties\"/>\n"
        "</popup>\n";

GtkWidget *load_pixmap(GtkWidget *container, const char **pixmap_data, int width, int height)
{
    GdkPixbuf *pixbuf, *scale_pixbuf;

    pixbuf = gdk_pixbuf_new_from_xpm_data(pixmap_data);
    scale_pixbuf = gdk_pixbuf_scale_simple(pixbuf, width, height, GDK_INTERP_BILINEAR);

    GdkPixmap *gdkpixmap;
    GdkBitmap *mask;
    GtkWidget *pixmap;

    gdk_pixbuf_render_pixmap_and_mask(scale_pixbuf, &gdkpixmap, &mask, 127);
    pixmap = gtk_pixmap_new(gdkpixmap, mask);

    gdk_bitmap_unref(mask);
    gdk_pixmap_unref(gdkpixmap);
    gdk_pixbuf_unref(pixbuf);
    gdk_pixbuf_unref(scale_pixbuf);

    return pixmap;
}

#include <fstream>
using namespace std;

static gboolean root_portal_applet_fill(PanelApplet *applet,
                                        const gchar *iid,
                                        gpointer data)
{
    if (strcmp(iid, "OAFIID:RootPortalApplet") != 0)
        return FALSE;

    GtkWidget *widget = GTK_WIDGET(applet);

    int sz = panel_applet_get_size(applet);
    GtkWidget *pixmap = load_pixmap(widget, (const char **) root_portal_xpm, sz, sz);

    gtk_container_add(GTK_CONTAINER(applet), pixmap);
    gtk_widget_show_all(GTK_WIDGET(applet));

    panel_applet_setup_menu(applet,
                            rp_menu_xml,
                            rp_menu_verbs,
                            NULL);
    
    return TRUE;
}

PANEL_APPLET_BONOBO_FACTORY("OAFIID:RootPortalApplet_Factory",
                            PANEL_TYPE_APPLET,
                            "Applet to control Root-Portal",
                            "0",
                            root_portal_applet_fill,
                            NULL);

