#ifndef ROOTPORTAL_H
#define ROOTPORTAL_H

#include "common.h"
#include "config/configuration.h"
#include "datasetmap.h"
#include "moduleinfo.h"
#include "module_tree.h"
#include "base_node.h"

#include <fstream>

using namespace std;

class StartupCancelled
{
public:
        StartupCancelled(int value) : returnCode(value) {};
        int returnCode;
};

class RootPortal
{
public:
        RootPortal(int argc, char* argv[]) throw (StartupCancelled);
        ~RootPortal();
        void service();
        void preShutdown();
        void saveConfig();
        void load_settings();
        void save_settings();
        void configure() {
                remote_configure_request = true;
        }

        void set_load_configurator_default(bool def) {
                load_configurator_default = def;
        }
                        
        bool get_load_configurator_default() {
                return load_configurator_default;
        }               

private:
        bool load_configurator_default;
        string getPluginDir();
        bool fileExists(const string& name);
        void displayWelcomeMessage();
        Configuration* configurator;

        int getLock(const string& displayName);
        void releaseLock();

        string writeConfig; // where to write back the configuration

        bool remote_configure_request;
};

extern RootPortal* rootPortal;
extern ofstream output_command_file;
extern bool slave_mode;

#endif
