// @(#)root/net:$Id: TGridJob.cxx 20882 2007-11-19 11:31:26Z rdm $
// Author: Jan Fiete Grosse-Oetringhaus   06/10/2004

/*************************************************************************
 * Copyright (C) 1995-2004, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// TGridJob                                                             //
//                                                                      //
// Abstract base class defining interface to a GRID job.                //
//                                                                      //
// Related classes are TGridJobStatus.                                  //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include "TGridJob.h"

ClassImp(TGridJob)


//______________________________________________________________________________
Int_t TGridJob::GetOutputSandbox(const char *, Option_t *)
{
   // Must be implemented by actual GRID job implementation. Returns -1 in
   // case of error, 0 otherwise.

   MayNotUse("GetOutputSandbox");
   return -1;
}
