#import <cstdlib>

#import "DetailViewController.h"
#import "RootViewController.h"

#import "DemoHelper.h"
#import "DemoBase.h"

const NSInteger nROOTDemos = 6;

@implementation RootViewController {
   NSMutableArray *tutorialNames;
   NSMutableArray *tutorialIcons;
   
   NSString * cellReuseIdentifier;
   
   ROOT::iOS::Demos::DemoBase *demos[nROOTDemos];
}

@synthesize detailViewController;

//_________________________________________________________________
- (void) dealloc
{
   for (unsigned i = 0; i < nROOTDemos; ++i)
      delete demos[i];
}

#pragma mark - view lifecycle.

//_________________________________________________________________
- (void) viewDidLoad
{
   NSString * const filePath = [[NSBundle mainBundle] pathForResource : @"h2poly" ofType : @"root"];
   if (!ROOT::iOS::Demos::CreateTutorials(demos, [filePath cStringUsingEncoding : [NSString defaultCStringEncoding]])) {
      NSLog(@"Failed to create demos");
      std::exit(1);//WOW???
   }

   tutorialNames = [[NSMutableArray alloc] init];
   [tutorialNames addObject : @"Hsimple"];
   [tutorialNames addObject : @"Surface"];
   [tutorialNames addObject : @"Polar graph"];
   [tutorialNames addObject : @"Lego"];
   [tutorialNames addObject : @"Exclusion graph"];
   [tutorialNames addObject : @"TH2Poly from file"];
   
   tutorialIcons = [[NSMutableArray alloc] init];
   [tutorialIcons addObject : @"hsimple_icon_n.png"];
   [tutorialIcons addObject : @"surface_icon_n.png"];
   [tutorialIcons addObject : @"polar_icon_n.png"];
   [tutorialIcons addObject : @"lego_icon_n.png"];
   [tutorialIcons addObject : @"exclusion_icon_n.png"];
   [tutorialIcons addObject : @"h2poly_icon.png"];
   
   cellReuseIdentifier = @"Cell";

   //Set table view's color, row height, separator's color
   //(I want separator to be invisible).
   self.tableView.rowHeight = 72.f;
   self.tableView.backgroundColor = [UIColor lightGrayColor];
   self.tableView.separatorColor = [UIColor clearColor];

   //This code was generated by ide.
   [super viewDidLoad];

   self.clearsSelectionOnViewWillAppear = NO;
   self.preferredContentSize = CGSizeMake(320.0, 500.0);
}

#pragma mark - Table view delegate and data source.

//_________________________________________________________________
- (NSInteger) numberOfSectionsInTableView : (UITableView *) tableView
{
#pragma unused(tableView)

   return 1;
}

//_________________________________________________________________
- (NSInteger) tableView : (UITableView *) tableView numberOfRowsInSection : (NSInteger) section
{
#pragma unused(tableView, section)

   return nROOTDemos;
}

//_________________________________________________________________
- (UITableViewCell *) tableView : (UITableView *)tableView cellForRowAtIndexPath : (NSIndexPath *) indexPath
{
   assert(tableView != nil && "tableView:cellForRowAtIndexPath:, parameter 'tableView' is nil");
   assert(indexPath != nil && "tableView:cellForRowAtIndexPath:, parameter 'indexPath' is nil");
   assert(indexPath.row >= 0 && indexPath.row < nROOTDemos &&
          "tableView:cellForRowAtIndexPath:, row is out of bounds");

   UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier : cellReuseIdentifier];
   if (!cell)
      cell = [[UITableViewCell alloc] initWithStyle : UITableViewCellStyleDefault reuseIdentifier : cellReuseIdentifier];

   // Configure the cell.
   const bool useDarkBackground = indexPath.row % 2;
   NSString * const backgroundImagePath = [[NSBundle mainBundle] pathForResource : useDarkBackground ? @"DarkBackground" : @"LightBackground" ofType : @"png"];

   UIImage * const backgroundImage = [[UIImage imageWithContentsOfFile : backgroundImagePath] stretchableImageWithLeftCapWidth : 0.f topCapHeight : 1.f];
   cell.backgroundView = [[UIImageView alloc] initWithImage : backgroundImage];
   cell.backgroundView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
   cell.backgroundView.frame = cell.bounds;

   cell.textLabel.text = [tutorialNames objectAtIndex : indexPath.row];
   cell.textLabel.backgroundColor = [UIColor clearColor];
   cell.imageView.image = [UIImage imageNamed : [tutorialIcons objectAtIndex : indexPath.row]];
   cell.imageView.clipsToBounds = YES;
   
   cell.imageView.layer.borderColor = [UIColor blackColor].CGColor;
   cell.imageView.layer.borderWidth = 1.;

   return cell;
}

//_________________________________________________________________
- (void) tableView : (UITableView *) tableView didSelectRowAtIndexPath : (NSIndexPath *) indexPath
{
#pragma unused(tableView)

   assert(indexPath != nil && "tableView:didSelectRowAtIndexPath:, parameter 'indexPath' is nil");
   assert(indexPath.row >= 0 && indexPath.row < nROOTDemos &&
          "tableView:didSelectRowAtIndexPath:, row is out of bounds");
   [self.detailViewController dismissPopover];
   [self.detailViewController setActiveDemo : demos[indexPath.row]];

//
   [self.tableView deselectRowAtIndexPath:indexPath animated : NO];
}

#pragma mark - Interface rotation.

//_________________________________________________________________
- (BOOL) shouldAutorotateToInterfaceOrientation : (UIInterfaceOrientation) interfaceOrientation
{
#pragma unused(interfaceOrientation)

   return YES;
}


@end
