/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2007
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_MIDICONFIGURATIONPAGE_H_
#define _RG_MIDICONFIGURATIONPAGE_H_

#include "TabbedConfigurationPage.h"
#include <qstring.h>
#include <klocale.h>
#include <qlineedit.h>
#include <qcheckbox.h>


class QWidget;
class QSpinBox;
class QSlider;
class QPushButton;
class QLabel;
class QComboBox;
class KConfig;
class KComboBox;


namespace Rosegarden
{

class RosegardenGUIDoc;


class MIDIConfigurationPage : public TabbedConfigurationPage
{
    Q_OBJECT
public:
    MIDIConfigurationPage(RosegardenGUIDoc *doc,
                               KConfig *cfg,
                               QWidget *parent=0,
                               const char *name=0);

    virtual void apply();

    static QString iconLabel() { return i18n("MIDI"); }
    static QString title()     { return i18n("MIDI Settings"); }
    static QString iconName()  { return "configure-midi"; }

protected slots:
    void slotSoundFontToggled(bool);
    void slotSfxLoadPathChoose();
    void slotSoundFontChoose();

protected:
    bool getUseDefaultStudio()      { return m_studio->isChecked(); }

    //--------------- Data members ---------------------------------

    // General
    QCheckBox *m_sendControllersAtPlay;

    QCheckBox   *m_sfxLoadEnabled;
    QLineEdit   *m_sfxLoadPath;
    QPushButton *m_sfxLoadChoose;
    QLineEdit   *m_soundFontPath;
    QPushButton *m_soundFontChoose;

    // Sync and timing
    //
    //QCheckBox *m_midiClockEnabled;
    QComboBox *m_midiSync;
    QString    m_origTimer;
    QComboBox *m_timer;
    QComboBox *m_mmcTransport;
    QComboBox *m_mtcTransport;
    QCheckBox *m_midiSyncAuto;

    QCheckBox* m_studio;
    QSpinBox*  m_midiPitchOctave;

};
 


}

#endif
