
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __ROY_H__
#define __ROY_H__

#include <stdio.h>
#include <string.h>

#include <roy/roy-config.h>


/* ANSI includes */
#include <stdlib.h>
#include <ctype.h>
#include <limits.h>

#ifdef RTHREAD_USING_PTHREADS
#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */
#endif /* RTHREAD_USING_PTHREADS */

#ifdef RTHREAD_USING_PTH
#include <pth.h>
#endif /* RTHREAD_USING_PTH */

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/*
 * RCHUNK_ENABLED enables recylcing of memory chunks for speed.
 * However, it's good to leave disabled if you wish to use gdb
 * etc to look for memory related problems.
 */

#define RCHUNK_ENABLED 1

#if (SIZEOF_CHAR == 1)
    typedef char rint8;
    typedef unsigned char ruint8;
#elif (SIZEOF_SHORT_INT == 1)
    typedef short int rint8;
    typedef unsigned short int ruint8;
#endif

#if (SIZEOF_CHAR == 2)
    typedef char rint16;
    typedef unsigned char ruint16;
#elif (SIZEOF_SHORT_INT == 2)
    typedef short int rint16;
    typedef unsigned short int ruint16;
#elif (SIZEOF_INT == 2)
    typedef int rint16;
    typedef unsigned int ruint16;
#endif

#if (SIZEOF_INT == 4)
    typedef int rint32;
    typedef unsigned int ruint32;
#elif (SIZEOF_SHORT_INT == 4)
    typedef short int rint32;
    typedef unsigned short int ruint32;
#else
    typedef long rint32;
    typedef unsigned long ruint32;
#endif


#define RFOREACH_CLOSE } while (0)


#ifndef RMIN
#define RMIN(a,b) ((a)<(b)?(a):(b)) 
#endif

#ifndef RMAX
#define RMAX(a,b) ((a)<(b)?(b):(a))
#endif

#include <roy/rmem.h>
#include <roy/rthread.h>
#include <roy/rflag.h>
#include <roy/rlist.h>
#include <roy/rbucket.h>
#include <roy/rbuf.h>
#include <roy/rbuf_gzip.h>
#include <roy/rlist_of.h>
#include <roy/rchunk.h>
#include <roy/rhash.h>
#include <roy/rbhash.h>
#include <roy/rdebug.h>
#include <roy/rarray.h>
#include <roy/rstr.h>
#include <roy/rxp.h>
#include <roy/rargv.h>
#include <roy/rinit.h>
#include <roy/rcleanup.h>

#include <roy/rmisc.h>
#include <roy/rmain.h>

#include <roy/rtherml.h>

#include <roy/rmdbg.h>
#include <roy/rmdbg_interfaces.h>

#endif /* __ROY_H__ */

