
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#ifndef __RMEM_H__
#define __RMEM_H__

/* Documentation!
 *
 * Why use these macros which are blatantly just wrapping malloc ?
 * Well, I haven't gotten to it yet, but soon there will be a very
 * advanced memory profiling/debugging system in place which, when
 * enabled, will track all allocations/frees, including those done
 * by these functions.
 *
 */

#define rmem_alloc(size) malloc (size)
#define rmem_alloc0(size) calloc (1, size)
#define rmem_free(ptr) free (ptr)


#define rmem_new(type,num) (type *) rmem_alloc(sizeof(type) * num)
#define rmem_new0(type,num) (type *) rmem_alloc0(sizeof(type) * num)

#define rmem_realloc(ptr, size) realloc(ptr, size)

#endif /* __RMEM_H__ */


