//! Tests auto-converted from "sass-spec/spec/libsass/bourbon.hrx"

#[allow(unused)]
fn runner() -> crate::TestRunner {
    super::runner()
        .with_cwd("bourbon")
        .mock_file("lib/_bourbon-deprecated-upcoming.scss", "//************************************************************************//\n// These mixins/functions are deprecated\n// They will be removed in the next MAJOR version release\n//************************************************************************//\n@mixin box-shadow ($shadows...) {\n  @include prefixer(box-shadow, $shadows, spec);\n  @warn \"box-shadow is deprecated and will be removed in the next major version release\";\n}\n\n@mixin background-size ($lengths...) {\n  @include prefixer(background-size, $lengths, spec);\n  @warn \"background-size is deprecated and will be removed in the next major version release\";\n}\n")
        .mock_file("lib/_bourbon.scss", "// Custom Helpers\n@import \"helpers/deprecated-webkit-gradient\";\n@import \"helpers/gradient-positions-parser\";\n@import \"helpers/linear-positions-parser\";\n@import \"helpers/radial-arg-parser\";\n@import \"helpers/radial-positions-parser\";\n@import \"helpers/render-gradients\";\n@import \"helpers/shape-size-stripper\";\n\n// Custom Functions\n@import \"functions/compact\";\n@import \"functions/flex-grid\";\n@import \"functions/grid-width\";\n@import \"functions/linear-gradient\";\n@import \"functions/modular-scale\";\n@import \"functions/px-to-em\";\n@import \"functions/radial-gradient\";\n@import \"functions/tint-shade\";\n@import \"functions/transition-property-name\";\n\n// CSS3 Mixins\n@import \"css3/animation\";\n@import \"css3/appearance\";\n@import \"css3/backface-visibility\";\n@import \"css3/background\";\n@import \"css3/background-image\";\n@import \"css3/border-image\";\n@import \"css3/border-radius\";\n@import \"css3/box-sizing\";\n@import \"css3/columns\";\n@import \"css3/flex-box\";\n@import \"css3/font-face\";\n@import \"css3/hidpi-media-query\";\n@import \"css3/image-rendering\";\n@import \"css3/inline-block\";\n@import \"css3/keyframes\";\n@import \"css3/linear-gradient\";\n@import \"css3/perspective\";\n@import \"css3/radial-gradient\";\n@import \"css3/transform\";\n@import \"css3/transition\";\n@import \"css3/user-select\";\n@import \"css3/placeholder\";\n\n// Addons & other mixins\n@import \"addons/button\";\n@import \"addons/clearfix\";\n@import \"addons/font-family\";\n@import \"addons/hide-text\";\n@import \"addons/html5-input-types\";\n@import \"addons/position\";\n@import \"addons/prefixer\";\n@import \"addons/retina-image\";\n@import \"addons/size\";\n@import \"addons/timing-functions\";\n@import \"addons/triangle\";\n\n// Soon to be deprecated Mixins\n@import \"bourbon-deprecated-upcoming\";\n")
        .mock_file("lib/addons/_button.scss", "@mixin button ($style: simple, $base-color: #4294f0) {\n\n  @if type-of($style) == color {\n    $base-color: $style;\n    $style: simple;\n  }\n\n  // Grayscale button\n  @if $base-color == grayscale($base-color) {\n    @if $style == simple {\n      @include simple($base-color, $grayscale: true);\n    }\n\n    @else if $style == shiny {\n      @include shiny($base-color, $grayscale: true);\n    }\n\n    @else if $style == pill {\n      @include pill($base-color, $grayscale: true);\n    }\n  }\n\n  // Colored button\n  @else {\n    @if $style == simple {\n      @include simple($base-color);\n    }\n\n    @else if $style == shiny {\n      @include shiny($base-color);\n    }\n\n    @else if $style == pill {\n      @include pill($base-color);\n    }\n  }\n\n  &:disabled {\n    opacity: 0.5;\n    cursor: not-allowed;\n  }\n}\n\n\n// Simple Button\n//************************************************************************//\n@mixin simple($base-color, $grayscale: false) {\n  $color:         hsl(0, 0, 100%);\n  $border:        adjust-color($base-color, $saturation:  9%,  $lightness: -14%);\n  $inset-shadow:  adjust-color($base-color, $saturation: -8%,  $lightness:  15%);\n  $stop-gradient: adjust-color($base-color, $saturation:  9%,  $lightness: -11%);\n  $text-shadow:   adjust-color($base-color, $saturation:  15%, $lightness: -18%);\n\n  @if lightness($base-color) > 70% {\n    $color:       hsl(0, 0, 20%);\n    $text-shadow: adjust-color($base-color, $saturation: 10%, $lightness: 4%);\n  }\n\n  @if $grayscale == true {\n    $border:        grayscale($border);\n    $inset-shadow:  grayscale($inset-shadow);\n    $stop-gradient: grayscale($stop-gradient);\n    $text-shadow:   grayscale($text-shadow);\n  }\n\n  border: 1px solid $border;\n  border-radius: 3px;\n  box-shadow: inset 0 1px 0 0 $inset-shadow;\n  color: $color;\n  display: inline-block;\n  font-size: 11px;\n  font-weight: bold;\n  @include linear-gradient ($base-color, $stop-gradient);\n  padding: 7px 18px;\n  text-decoration: none;\n  text-shadow: 0 1px 0 $text-shadow;\n  background-clip: padding-box;\n\n  &:hover:not(:disabled) {\n    $base-color-hover:    adjust-color($base-color, $saturation: -4%, $lightness: -5%);\n    $inset-shadow-hover:  adjust-color($base-color, $saturation: -7%, $lightness:  5%);\n    $stop-gradient-hover: adjust-color($base-color, $saturation:  8%, $lightness: -14%);\n\n    @if $grayscale == true {\n      $base-color-hover:    grayscale($base-color-hover);\n      $inset-shadow-hover:  grayscale($inset-shadow-hover);\n      $stop-gradient-hover: grayscale($stop-gradient-hover);\n    }\n\n    box-shadow: inset 0 1px 0 0 $inset-shadow-hover;\n    cursor: pointer;\n    @include linear-gradient ($base-color-hover, $stop-gradient-hover);\n  }\n\n  &:active:not(:disabled) {\n    $border-active:       adjust-color($base-color, $saturation: 9%, $lightness: -14%);\n    $inset-shadow-active: adjust-color($base-color, $saturation: 7%, $lightness: -17%);\n\n    @if $grayscale == true {\n      $border-active:       grayscale($border-active);\n      $inset-shadow-active: grayscale($inset-shadow-active);\n    }\n\n    border: 1px solid $border-active;\n    box-shadow: inset 0 0 8px 4px $inset-shadow-active, inset 0 0 8px 4px $inset-shadow-active, 0 1px 1px 0 #eee;\n  }\n}\n\n\n// Shiny Button\n//************************************************************************//\n@mixin shiny($base-color, $grayscale: false) {\n  $color:         hsl(0, 0, 100%);\n  $border:        adjust-color($base-color, $red: -117, $green: -111, $blue: -81);\n  $border-bottom: adjust-color($base-color, $red: -126, $green: -127, $blue: -122);\n  $fourth-stop:   adjust-color($base-color, $red: -79,  $green: -70,  $blue: -46);\n  $inset-shadow:  adjust-color($base-color, $red:  37,  $green:  29,  $blue:  12);\n  $second-stop:   adjust-color($base-color, $red: -56,  $green: -50,  $blue: -33);\n  $text-shadow:   adjust-color($base-color, $red: -140, $green: -141, $blue: -114);\n  $third-stop:    adjust-color($base-color, $red: -86,  $green: -75,  $blue: -48);\n\n  @if lightness($base-color) > 70% {\n    $color:       hsl(0, 0, 20%);\n    $text-shadow: adjust-color($base-color, $saturation: 10%, $lightness: 4%);\n  }\n\n  @if $grayscale == true {\n    $border:        grayscale($border);\n    $border-bottom: grayscale($border-bottom);\n    $fourth-stop:   grayscale($fourth-stop);\n    $inset-shadow:  grayscale($inset-shadow);\n    $second-stop:   grayscale($second-stop);\n    $text-shadow:   grayscale($text-shadow);\n    $third-stop:    grayscale($third-stop);\n  }\n\n  border: 1px solid $border;\n  border-bottom: 1px solid $border-bottom;\n  border-radius: 5px;\n  box-shadow: inset 0 1px 0 0 $inset-shadow;\n  color: $color;\n  display: inline-block;\n  font-size: 14px;\n  font-weight: bold;\n  @include linear-gradient(top, $base-color 0%, $second-stop 50%, $third-stop 50%, $fourth-stop 100%);\n  padding: 8px 20px;\n  text-align: center;\n  text-decoration: none;\n  text-shadow: 0 -1px 1px $text-shadow;\n\n  &:hover:not(:disabled) {\n    $first-stop-hover:  adjust-color($base-color, $red: -13, $green: -15, $blue: -18);\n    $second-stop-hover: adjust-color($base-color, $red: -66, $green: -62, $blue: -51);\n    $third-stop-hover:  adjust-color($base-color, $red: -93, $green: -85, $blue: -66);\n    $fourth-stop-hover: adjust-color($base-color, $red: -86, $green: -80, $blue: -63);\n\n    @if $grayscale == true {\n      $first-stop-hover:  grayscale($first-stop-hover);\n      $second-stop-hover: grayscale($second-stop-hover);\n      $third-stop-hover:  grayscale($third-stop-hover);\n      $fourth-stop-hover: grayscale($fourth-stop-hover);\n    }\n\n    cursor: pointer;\n    @include linear-gradient(top, $first-stop-hover  0%,\n                                  $second-stop-hover 50%,\n                                  $third-stop-hover  50%,\n                                  $fourth-stop-hover 100%);\n  }\n\n  &:active:not(:disabled) {\n    $inset-shadow-active: adjust-color($base-color, $red: -111, $green: -116, $blue: -122);\n\n    @if $grayscale == true {\n      $inset-shadow-active: grayscale($inset-shadow-active);\n    }\n\n    box-shadow: inset 0 0 20px 0 $inset-shadow-active, 0 1px 0 #fff;\n  }\n}\n\n\n// Pill Button\n//************************************************************************//\n@mixin pill($base-color, $grayscale: false) {\n  $color:         hsl(0, 0, 100%);\n  $border-bottom: adjust-color($base-color, $hue:  8, $saturation: -11%, $lightness: -26%);\n  $border-sides:  adjust-color($base-color, $hue:  4, $saturation: -21%, $lightness: -21%);\n  $border-top:    adjust-color($base-color, $hue: -1, $saturation: -30%, $lightness: -15%);\n  $inset-shadow:  adjust-color($base-color, $hue: -1, $saturation: -1%,  $lightness:  7%);\n  $stop-gradient: adjust-color($base-color, $hue:  8, $saturation:  14%, $lightness: -10%);\n  $text-shadow:   adjust-color($base-color, $hue:  5, $saturation: -19%, $lightness: -15%);\n\n  @if lightness($base-color) > 70% {\n    $color:       hsl(0, 0, 20%);\n    $text-shadow: adjust-color($base-color, $saturation: 10%, $lightness: 4%);\n  }\n\n  @if $grayscale == true {\n    $border-bottom: grayscale($border-bottom);\n    $border-sides:  grayscale($border-sides);\n    $border-top:    grayscale($border-top);\n    $inset-shadow:  grayscale($inset-shadow);\n    $stop-gradient: grayscale($stop-gradient);\n    $text-shadow:   grayscale($text-shadow);\n  }\n\n  border: 1px solid $border-top;\n  border-color: $border-top $border-sides $border-bottom;\n  border-radius: 16px;\n  box-shadow: inset 0 1px 0 0 $inset-shadow, 0 1px 2px 0 #b3b3b3;\n  color: $color;\n  display: inline-block;\n  font-size: 11px;\n  font-weight: normal;\n  line-height: 1;\n  @include linear-gradient ($base-color, $stop-gradient);\n  padding: 5px 16px;\n  text-align: center;\n  text-decoration: none;\n  text-shadow: 0 -1px 1px $text-shadow;\n  background-clip: padding-box;\n\n  &:hover:not(:disabled) {\n    $base-color-hover:    adjust-color($base-color,                                $lightness: -4.5%);\n    $border-bottom:       adjust-color($base-color, $hue:  8, $saturation:  13.5%, $lightness: -32%);\n    $border-sides:        adjust-color($base-color, $hue:  4, $saturation: -2%,    $lightness: -27%);\n    $border-top:          adjust-color($base-color, $hue: -1, $saturation: -17%,   $lightness: -21%);\n    $inset-shadow-hover:  adjust-color($base-color,           $saturation: -1%,    $lightness:  3%);\n    $stop-gradient-hover: adjust-color($base-color, $hue:  8, $saturation: -4%,    $lightness: -15.5%);\n    $text-shadow-hover:   adjust-color($base-color, $hue:  5, $saturation: -5%,    $lightness: -22%);\n\n    @if $grayscale == true {\n      $base-color-hover:    grayscale($base-color-hover);\n      $border-bottom:       grayscale($border-bottom);\n      $border-sides:        grayscale($border-sides);\n      $border-top:          grayscale($border-top);\n      $inset-shadow-hover:  grayscale($inset-shadow-hover);\n      $stop-gradient-hover: grayscale($stop-gradient-hover);\n      $text-shadow-hover:   grayscale($text-shadow-hover);\n    }\n\n    border: 1px solid $border-top;\n    border-color: $border-top $border-sides $border-bottom;\n    box-shadow: inset 0 1px 0 0 $inset-shadow-hover;\n    cursor: pointer;\n    @include linear-gradient ($base-color-hover, $stop-gradient-hover);\n    text-shadow: 0 -1px 1px $text-shadow-hover;\n    background-clip: padding-box;\n  }\n\n  &:active:not(:disabled) {\n    $active-color:         adjust-color($base-color, $hue: 4,  $saturation: -12%,  $lightness: -10%);\n    $border-active:        adjust-color($base-color, $hue: 6,  $saturation: -2.5%, $lightness: -30%);\n    $border-bottom-active: adjust-color($base-color, $hue: 11, $saturation:  6%,   $lightness: -31%);\n    $inset-shadow-active:  adjust-color($base-color, $hue: 9,  $saturation:  2%,   $lightness: -21.5%);\n    $text-shadow-active:   adjust-color($base-color, $hue: 5,  $saturation: -12%,  $lightness: -21.5%);\n\n    @if $grayscale == true {\n      $active-color:         grayscale($active-color);\n      $border-active:        grayscale($border-active);\n      $border-bottom-active: grayscale($border-bottom-active);\n      $inset-shadow-active:  grayscale($inset-shadow-active);\n      $text-shadow-active:   grayscale($text-shadow-active);\n    }\n\n    background: $active-color;\n    border: 1px solid $border-active;\n    border-bottom: 1px solid $border-bottom-active;\n    box-shadow: inset 0 0 6px 3px $inset-shadow-active, 0 1px 0 0 #fff;\n    text-shadow: 0 -1px 1px $text-shadow-active;\n  }\n}\n")
        .mock_file("lib/addons/_clearfix.scss", "// Micro clearfix provides an easy way to contain floats without adding additional markup\n//\n// Example usage:\n//\n//    // Contain all floats within .wrapper\n//    .wrapper {\n//      @include clearfix;\n//      .content,\n//      .sidebar {\n//        float : left;\n//      }\n//    }\n\n@mixin clearfix {\n  *zoom: 1;\n\n  &:before,\n  &:after {\n    content: \" \";\n    display: table;\n  }\n\n  &:after {\n    clear: both;\n  }\n}\n\n// Acknowledgements\n// Micro clearfix: [Nicolas Gallagher](http://nicolasgallagher.com/micro-clearfix-hack/)\n")
        .mock_file("lib/addons/_font-family.scss", "$georgia: Georgia, Cambria, \"Times New Roman\", Times, serif;\n$helvetica: \"Helvetica Neue\", Helvetica, Arial, sans-serif;\n$lucida-grande: \"Lucida Grande\", Tahoma, Verdana, Arial, sans-serif;\n$monospace: \"Bitstream Vera Sans Mono\", Consolas, Courier, monospace;\n$verdana: Verdana, Geneva, sans-serif;\n")
        .mock_file("lib/addons/_hide-text.scss", "@mixin hide-text {\n  color:            transparent;\n  font:             0/0 a;\n  text-shadow:      none;\n}\n")
        .mock_file("lib/addons/_html5-input-types.scss", "//************************************************************************//\n// Generate a variable ($all-text-inputs) with a list of all html5\n// input types that have a text-based input, excluding textarea.\n// http://diveintohtml5.org/forms.html\n//************************************************************************//\n$inputs-list: 'input[type=\"email\"]',\n              'input[type=\"number\"]',\n              'input[type=\"password\"]',\n              'input[type=\"search\"]',\n              'input[type=\"tel\"]',\n              'input[type=\"text\"]',\n              'input[type=\"url\"]',\n\n              // Webkit & Gecko may change the display of these in the future\n              'input[type=\"color\"]',\n              'input[type=\"date\"]',\n              'input[type=\"datetime\"]',\n              'input[type=\"datetime-local\"]',\n              'input[type=\"month\"]',\n              'input[type=\"time\"]',\n              'input[type=\"week\"]';\n\n$unquoted-inputs-list: ();\n@each $input-type in $inputs-list {\n  $unquoted-inputs-list: append($unquoted-inputs-list, unquote($input-type), comma);\n}\n\n$all-text-inputs: $unquoted-inputs-list;\n\n\n// Hover Pseudo-class\n//************************************************************************//\n$all-text-inputs-hover: ();\n@each $input-type in $unquoted-inputs-list {\n      $input-type-hover: $input-type + \":hover\";\n      $all-text-inputs-hover: append($all-text-inputs-hover, $input-type-hover, comma);\n}\n\n// Focus Pseudo-class\n//************************************************************************//\n$all-text-inputs-focus: ();\n@each $input-type in $unquoted-inputs-list {\n      $input-type-focus: $input-type + \":focus\";\n      $all-text-inputs-focus: append($all-text-inputs-focus, $input-type-focus, comma);\n}\n\n// You must use interpolation on the variable:\n// #{$all-text-inputs}\n// #{$all-text-inputs-hover}\n// #{$all-text-inputs-focus}\n\n// Example\n//************************************************************************//\n//   #{$all-text-inputs}, textarea {\n//     border: 1px solid red;\n//   }\n")
        .mock_file("lib/addons/_position.scss", "@mixin position ($position: relative, $coordinates: 0 0 0 0) {\n\n  @if type-of($position) == list {\n    $coordinates: $position;\n    $position: relative;\n  }\n\n  $top: nth($coordinates, 1);\n  $right: nth($coordinates, 2);\n  $bottom: nth($coordinates, 3);\n  $left: nth($coordinates, 4);\n\n  position: $position;\n\n  @if $top == auto {\n    top: $top;\n  }\n  @else if not(unitless($top)) {\n    top: $top;\n  }\n\n  @if $right == auto {\n    right: $right;\n  }\n  @else if not(unitless($right)) {\n    right: $right;\n  }\n\n  @if $bottom == auto {\n    bottom: $bottom;\n  }\n  @else if not(unitless($bottom)) {\n    bottom: $bottom;\n  }\n\n  @if $left == auto {\n    left: $left;\n  }\n  @else if not(unitless($left)) {\n    left: $left;\n  }\n}\n")
        .mock_file("lib/addons/_prefixer.scss", "//************************************************************************//\n// Example: @include prefixer(border-radius, $radii, webkit ms spec);\n//************************************************************************//\n$prefix-for-webkit:    true !default;\n$prefix-for-mozilla:   true !default;\n$prefix-for-microsoft: true !default;\n$prefix-for-opera:     true !default;\n$prefix-for-spec:      true !default; // required for keyframe mixin\n\n@mixin prefixer ($property, $value, $prefixes) {\n  @each $prefix in $prefixes {\n    @if $prefix == webkit {\n      @if $prefix-for-webkit {\n        -webkit-#{$property}: $value;\n      }\n    }\n    @else if $prefix == moz {\n      @if $prefix-for-mozilla {\n        -moz-#{$property}: $value;\n      }\n    }\n    @else if $prefix == ms {\n      @if $prefix-for-microsoft {\n        -ms-#{$property}: $value;\n      }\n    }\n    @else if $prefix == o {\n      @if $prefix-for-opera {\n        -o-#{$property}: $value;\n      }\n    }\n    @else if $prefix == spec {\n      @if $prefix-for-spec {\n        #{$property}: $value;\n      }\n    }\n    @else  {\n      @warn \"Unrecognized prefix: #{$prefix}\";\n    }\n  }\n}\n\n@mixin disable-prefix-for-all() {\n  $prefix-for-webkit:    false;\n  $prefix-for-mozilla:   false;\n  $prefix-for-microsoft: false;\n  $prefix-for-opera:     false;\n  $prefix-for-spec:      false;\n}\n")
        .mock_file("lib/addons/_retina-image.scss", "@mixin retina-image($filename, $background-size, $extension: png, $retina-filename: null, $asset-pipeline: false) {\n  @if $asset-pipeline {\n    background-image: image_url(\"#{$filename}.#{$extension}\");\n  }\n  @else {\n    background-image: url(\"#{$filename}.#{$extension}\");\n  }\n\n  @include hidpi {\n\n    @if $asset-pipeline {\n      @if $retina-filename {\n        background-image: image_url(\"#{$retina-filename}.#{$extension}\");\n      }\n      @else {\n        background-image: image_url(\"#{$filename}@2x.#{$extension}\");\n      }\n    }\n\n    @else {\n      @if $retina-filename {\n        background-image: url(\"#{$retina-filename}.#{$extension}\");\n      }\n      @else {\n        background-image: url(\"#{$filename}@2x.#{$extension}\");\n      }\n    }\n\n    background-size: $background-size;\n\n  }\n}\n")
        .mock_file("lib/addons/_size.scss", "@mixin size($size) {\n  @if length($size) == 1 {\n    @if $size == auto {\n      width:  $size;\n      height: $size;\n    }\n\n    @else if unitless($size) {\n      width:  $size + px;\n      height: $size + px;\n    }\n\n    @else if not(unitless($size)) {\n      width:  $size;\n      height: $size;\n    }\n  }\n\n  // Width x Height\n  @if length($size) == 2 {\n    $width:  nth($size, 1);\n    $height: nth($size, 2);\n\n    @if $width == auto {\n      width: $width;\n    }\n    @else if not(unitless($width)) {\n      width: $width;\n    }\n    @else if unitless($width) {\n      width: $width + px;\n    }\n\n    @if $height == auto {\n      height: $height;\n    }\n    @else if not(unitless($height)) {\n      height: $height;\n    }\n    @else if unitless($height) {\n      height: $height + px;\n    }\n  }\n}\n")
        .mock_file("lib/addons/_timing-functions.scss", "// CSS cubic-bezier timing functions. Timing functions courtesy of jquery.easie (github.com/jaukia/easie)\n// Timing functions are the same as demo'ed here: http://jqueryui.com/demos/effect/easing.html\n\n// EASE IN\n$ease-in-quad:      cubic-bezier(0.550,  0.085, 0.680, 0.530);\n$ease-in-cubic:     cubic-bezier(0.550,  0.055, 0.675, 0.190);\n$ease-in-quart:     cubic-bezier(0.895,  0.030, 0.685, 0.220);\n$ease-in-quint:     cubic-bezier(0.755,  0.050, 0.855, 0.060);\n$ease-in-sine:      cubic-bezier(0.470,  0.000, 0.745, 0.715);\n$ease-in-expo:      cubic-bezier(0.950,  0.050, 0.795, 0.035);\n$ease-in-circ:      cubic-bezier(0.600,  0.040, 0.980, 0.335);\n$ease-in-back:      cubic-bezier(0.600, -0.280, 0.735, 0.045);\n\n// EASE OUT\n$ease-out-quad:     cubic-bezier(0.250,  0.460, 0.450, 0.940);\n$ease-out-cubic:    cubic-bezier(0.215,  0.610, 0.355, 1.000);\n$ease-out-quart:    cubic-bezier(0.165,  0.840, 0.440, 1.000);\n$ease-out-quint:    cubic-bezier(0.230,  1.000, 0.320, 1.000);\n$ease-out-sine:     cubic-bezier(0.390,  0.575, 0.565, 1.000);\n$ease-out-expo:     cubic-bezier(0.190,  1.000, 0.220, 1.000);\n$ease-out-circ:     cubic-bezier(0.075,  0.820, 0.165, 1.000);\n$ease-out-back:     cubic-bezier(0.175,  0.885, 0.320, 1.275);\n\n// EASE IN OUT\n$ease-in-out-quad:  cubic-bezier(0.455,  0.030, 0.515, 0.955);\n$ease-in-out-cubic: cubic-bezier(0.645,  0.045, 0.355, 1.000);\n$ease-in-out-quart: cubic-bezier(0.770,  0.000, 0.175, 1.000);\n$ease-in-out-quint: cubic-bezier(0.860,  0.000, 0.070, 1.000);\n$ease-in-out-sine:  cubic-bezier(0.445,  0.050, 0.550, 0.950);\n$ease-in-out-expo:  cubic-bezier(1.000,  0.000, 0.000, 1.000);\n$ease-in-out-circ:  cubic-bezier(0.785,  0.135, 0.150, 0.860);\n$ease-in-out-back:  cubic-bezier(0.680, -0.550, 0.265, 1.550);\n")
        .mock_file("lib/addons/_triangle.scss", "@mixin triangle ($size, $color, $direction) {\n  height: 0;\n  width: 0;\n\n  @if ($direction == up) or ($direction == down) or ($direction == right) or ($direction == left) {\n    border-color: transparent;\n    border-style: solid;\n    border-width: $size / 2;\n\n    @if $direction == up {\n      border-bottom-color: $color;\n\n    } @else if $direction == right {\n      border-left-color:   $color;\n\n    } @else if $direction == down {\n      border-top-color:    $color;\n\n    } @else if $direction == left {\n      border-right-color:  $color;\n    }\n  }\n\n  @else if ($direction == up-right) or ($direction == up-left) {\n    border-top: $size solid $color;\n\n    @if $direction == up-right {\n      border-left:  $size solid transparent;\n\n    } @else if $direction == up-left {\n      border-right: $size solid transparent;\n    }\n  }\n\n  @else if ($direction == down-right) or ($direction == down-left) {\n    border-bottom: $size solid $color;\n\n    @if $direction == down-right {\n      border-left:  $size solid transparent;\n\n    } @else if $direction == down-left {\n      border-right: $size solid transparent;\n    }\n  }\n}\n")
        .mock_file("lib/css3/_animation.scss", "// http://www.w3.org/TR/css3-animations/#the-animation-name-property-\n// Each of these mixins support comma separated lists of values, which allows different transitions for individual properties to be described in a single style rule. Each value in the list corresponds to the value at that same position in the other properties.\n\n// Official animation shorthand property.\n@mixin animation ($animations...) {\n  @include prefixer(animation, $animations, webkit moz spec);\n}\n\n// Individual Animation Properties\n@mixin animation-name ($names...) {\n  @include prefixer(animation-name, $names, webkit moz spec);\n}\n\n\n@mixin animation-duration ($times...) {\n  @include prefixer(animation-duration, $times, webkit moz spec);\n}\n\n\n@mixin animation-timing-function ($motions...) {\n// ease | linear | ease-in | ease-out | ease-in-out\n  @include prefixer(animation-timing-function, $motions, webkit moz spec);\n}\n\n\n@mixin animation-iteration-count ($values...) {\n// infinite | <number>\n  @include prefixer(animation-iteration-count, $values, webkit moz spec);\n}\n\n\n@mixin animation-direction ($directions...) {\n// normal | alternate\n  @include prefixer(animation-direction, $directions, webkit moz spec);\n}\n\n\n@mixin animation-play-state ($states...) {\n// running | paused\n  @include prefixer(animation-play-state, $states, webkit moz spec);\n}\n\n\n@mixin animation-delay ($times...) {\n  @include prefixer(animation-delay, $times, webkit moz spec);\n}\n\n\n@mixin animation-fill-mode ($modes...) {\n// none | forwards | backwards | both\n  @include prefixer(animation-fill-mode, $modes, webkit moz spec);\n}\n")
        .mock_file("lib/css3/_appearance.scss", "@mixin appearance ($value) {\n  @include prefixer(appearance, $value, webkit moz ms o spec);\n}\n")
        .mock_file("lib/css3/_backface-visibility.scss", "//************************************************************************//\n// Backface-visibility mixin\n//************************************************************************//\n@mixin backface-visibility($visibility) {\n  @include prefixer(backface-visibility, $visibility, webkit spec);\n}\n")
        .mock_file("lib/css3/_background-image.scss", "//************************************************************************//\n// Background-image property for adding multiple background images with\n// gradients, or for stringing multiple gradients together.\n//************************************************************************//\n\n@mixin background-image($images...) {\n  background-image: _add-prefix($images, webkit);\n  background-image: _add-prefix($images);\n}\n\n@function _add-prefix($images, $vendor: false) {\n  $images-prefixed: ();\n  $gradient-positions: false;\n  @for $i from 1 through length($images) {\n    $type: type-of(nth($images, $i)); // Get type of variable - List or String\n\n    // If variable is a list - Gradient\n    @if $type == list {\n      $gradient-type: nth(nth($images, $i), 1); // linear or radial\n      $gradient-pos: null;\n      $gradient-args: null;\n\n      @if ($gradient-type == linear) or ($gradient-type == radial) {\n        $gradient-pos:  nth(nth($images, $i), 2); // Get gradient position\n        $gradient-args: nth(nth($images, $i), 3); // Get actual gradient (red, blue)\n      }\n      @else {\n        $gradient-args: nth(nth($images, $i), 2); // Get actual gradient (red, blue)\n      }\n\n      $gradient-positions: _gradient-positions-parser($gradient-type, $gradient-pos);\n      $gradient: _render-gradients($gradient-positions, $gradient-args, $gradient-type, $vendor);\n      $images-prefixed: append($images-prefixed, $gradient, comma);\n    }\n    // If variable is a string - Image\n    @else if $type == string {\n      $images-prefixed: join($images-prefixed, nth($images, $i), comma);\n    }\n  }\n  @return $images-prefixed;\n}\n\n//Examples:\n  //@include background-image(linear-gradient(top, orange, red));\n  //@include background-image(radial-gradient(50% 50%, cover circle, orange, red));\n  //@include background-image(url(\"/images/a.png\"), linear-gradient(orange, red));\n  //@include background-image(url(\"image.png\"), linear-gradient(orange, red), url(\"image.png\"));\n  //@include background-image(linear-gradient(hsla(0, 100%, 100%, 0.25) 0%, hsla(0, 100%, 100%, 0.08) 50%, transparent 50%), linear-gradient(orange, red));\n")
        .mock_file("lib/css3/_background.scss", "//************************************************************************//\n// Background property for adding multiple backgrounds using shorthand\n// notation.\n//************************************************************************//\n\n@mixin background(\n  $background-1       , $background-2: false,\n  $background-3: false, $background-4: false,\n  $background-5: false, $background-6: false,\n  $background-7: false, $background-8: false,\n  $background-9: false, $background-10: false,\n  $fallback: false\n) {\n  $backgrounds: compact($background-1, $background-2,\n                $background-3, $background-4,\n                $background-5, $background-6,\n                $background-7, $background-8,\n                $background-9, $background-10);\n\n  $fallback-color: false;\n  @if (type-of($fallback) == color) or ($fallback == \"transparent\") {\n    $fallback-color: $fallback;\n  }\n  @else {\n    $fallback-color: _extract-background-color($backgrounds);\n  }\n\n  @if $fallback-color {\n    background-color: $fallback-color;\n  }\n  background: _background-add-prefix($backgrounds, webkit);\n  background: _background-add-prefix($backgrounds);\n}\n\n@function _extract-background-color($backgrounds) {\n  $final-bg-layer: nth($backgrounds, length($backgrounds));\n  @if type-of($final-bg-layer) == list {\n    @for $i from 1 through length($final-bg-layer) {\n      $value: nth($final-bg-layer, $i);\n      @if type-of($value) == color {\n        @return $value;\n      }\n    }\n  }\n  @return false;\n}\n\n@function _background-add-prefix($backgrounds, $vendor: false) {\n  $backgrounds-prefixed: ();\n\n  @for $i from 1 through length($backgrounds) {\n    $shorthand: nth($backgrounds, $i); // Get member for current index\n    $type: type-of($shorthand); // Get type of variable - List (gradient) or String (image)\n\n    // If shorthand is a list (gradient)\n    @if $type == list {\n      $first-member: nth($shorthand, 1); // Get first member of shorthand\n\n      // Linear Gradient\n      @if index(linear radial, nth($first-member, 1)) {\n        $gradient-type: nth($first-member, 1); // linear || radial\n        $gradient-args:      false;\n        $gradient-positions: false;\n        $shorthand-start:    false;\n        @if type-of($first-member) == list { // Linear gradient plus additional shorthand values - lg(red,orange)repeat,...\n          $gradient-positions: nth($first-member, 2);\n          $gradient-args:      nth($first-member, 3);\n          $shorthand-start: 2;\n        }\n        @else { // Linear gradient only - lg(red,orange),...\n          $gradient-positions: nth($shorthand, 2);\n          $gradient-args:      nth($shorthand, 3); // Get gradient (red, blue)\n        }\n\n        $gradient-positions: _gradient-positions-parser($gradient-type, $gradient-positions);\n        $gradient: _render-gradients($gradient-positions, $gradient-args, $gradient-type, $vendor);\n\n        // Append any additional shorthand args to gradient\n        @if $shorthand-start {\n          @for $j from $shorthand-start through length($shorthand) {\n            $gradient: join($gradient, nth($shorthand, $j), space);\n          }\n        }\n        $backgrounds-prefixed: append($backgrounds-prefixed, $gradient, comma);\n      }\n      // Image with additional properties\n      @else {\n        $backgrounds-prefixed: append($backgrounds-prefixed, $shorthand, comma);\n      }\n    }\n    // If shorthand is a simple string (color or image)\n    @else if $type == string {\n      $backgrounds-prefixed: join($backgrounds-prefixed, $shorthand, comma);\n    }\n  }\n  @return $backgrounds-prefixed;\n}\n\n//Examples:\n  //@include background(linear-gradient(top, orange, red));\n  //@include background(radial-gradient(circle at 40% 40%, orange, red));\n  //@include background(url(\"/images/a.png\") no-repeat, linear-gradient(orange, red));\n  //@include background(url(\"image.png\") center center, linear-gradient(orange, red), url(\"image.png\"));\n")
        .mock_file("lib/css3/_border-image.scss", "@mixin border-image($images) {\n  -webkit-border-image: _border-add-prefix($images, webkit);\n     -moz-border-image: _border-add-prefix($images, moz);\n       -o-border-image: _border-add-prefix($images, o);\n          border-image: _border-add-prefix($images);\n}\n\n@function _border-add-prefix($images, $vendor: false) {\n  $border-image: null;\n  $images-type:  type-of(nth($images, 1));\n  $first-var:    nth(nth($images, 1), 1);          // Get type of Gradient (Linear || radial)\n\n  // If input is a gradient\n  @if $images-type == string {\n    @if ($first-var == \"linear\") or ($first-var == \"radial\") {\n      $gradient-type: nth($images, 1);           // Get type of gradient (linear || radial)\n      $gradient-pos:  nth($images, 2);           // Get gradient position\n      $gradient-args: nth($images, 3);           // Get actual gradient (red, blue)\n      $gradient-positions: _gradient-positions-parser($gradient-type, $gradient-pos);\n      $border-image:  _render-gradients($gradient-positions, $gradient-args, $gradient-type, $vendor);\n    }\n    // If input is a URL\n    @else {\n      $border-image: $images;\n    }\n  }\n  // If input is gradient or url + additional args\n  @else if $images-type == list {\n    $type: type-of(nth($images, 1));           // Get type of variable - List or String\n\n    // If variable is a list - Gradient\n    @if $type == list {\n      $gradient: nth($images, 1);\n      $gradient-type: nth($gradient, 1);           // Get type of gradient (linear || radial)\n      $gradient-pos:  nth($gradient, 2);           // Get gradient position\n      $gradient-args: nth($gradient, 3);           // Get actual gradient (red, blue)\n      $gradient-positions: _gradient-positions-parser($gradient-type, $gradient-pos);\n      $border-image:  _render-gradients($gradient-positions, $gradient-args, $gradient-type, $vendor);\n\n      @for $i from 2 through length($images) {\n        $border-image: append($border-image, nth($images, $i));\n      }\n    }\n  }\n  @return $border-image;\n}\n\n//Examples:\n// @include border-image(url(\"image.png\"));\n// @include border-image(url(\"image.png\") 20 stretch);\n// @include border-image(linear-gradient(45deg, orange, yellow));\n// @include border-image(linear-gradient(45deg, orange, yellow) stretch);\n// @include border-image(linear-gradient(45deg, orange, yellow) 20 30 40 50 stretch round);\n// @include border-image(radial-gradient(top, cover, orange, yellow, orange));\n\n")
        .mock_file("lib/css3/_border-radius.scss", "//************************************************************************//\n// Shorthand Border-radius mixins\n//************************************************************************//\n@mixin border-top-radius($radii) {\n  @include prefixer(border-top-left-radius, $radii, spec);\n  @include prefixer(border-top-right-radius, $radii, spec);\n}\n\n@mixin border-bottom-radius($radii) {\n  @include prefixer(border-bottom-left-radius, $radii, spec);\n  @include prefixer(border-bottom-right-radius, $radii, spec);\n}\n\n@mixin border-left-radius($radii) {\n  @include prefixer(border-top-left-radius, $radii, spec);\n  @include prefixer(border-bottom-left-radius, $radii, spec);\n}\n\n@mixin border-right-radius($radii) {\n  @include prefixer(border-top-right-radius, $radii, spec);\n  @include prefixer(border-bottom-right-radius, $radii, spec);\n}\n")
        .mock_file("lib/css3/_box-sizing.scss", "@mixin box-sizing ($box) {\n//  content-box | border-box | inherit\n  @include prefixer(box-sizing, $box, webkit moz spec);\n}\n")
        .mock_file("lib/css3/_columns.scss", "@mixin columns($arg: auto) {\n// <column-count> || <column-width>\n  @include prefixer(columns, $arg, webkit moz spec);\n}\n\n@mixin column-count($int: auto) {\n// auto || integer\n  @include prefixer(column-count, $int, webkit moz spec);\n}\n\n@mixin column-gap($length: normal) {\n// normal || length\n  @include prefixer(column-gap, $length, webkit moz spec);\n}\n\n@mixin column-fill($arg: auto) {\n// auto || length\n  @include prefixer(columns-fill, $arg, webkit moz spec);\n}\n\n@mixin column-rule($arg) {\n// <border-width> || <border-style> || <color>\n  @include prefixer(column-rule, $arg, webkit moz spec);\n}\n\n@mixin column-rule-color($color) {\n  @include prefixer(column-rule-color, $color, webkit moz spec);\n}\n\n@mixin column-rule-style($style: none) {\n// none | hidden | dashed | dotted | double | groove | inset | inset | outset | ridge | solid\n  @include prefixer(column-rule-style, $style, webkit moz spec);\n}\n\n@mixin column-rule-width ($width: none) {\n  @include prefixer(column-rule-width, $width, webkit moz spec);\n}\n\n@mixin column-span($arg: none) {\n// none || all\n  @include prefixer(column-span, $arg, webkit moz spec);\n}\n\n@mixin column-width($length: auto) {\n// auto || length\n  @include prefixer(column-width, $length, webkit moz spec);\n}\n")
        .mock_file("lib/css3/_flex-box.scss", "// CSS3 Flexible Box Model and property defaults\n\n// Custom shorthand notation for flexbox\n@mixin box($orient: inline-axis, $pack: start, $align: stretch) {\n  @include display-box;\n  @include box-orient($orient);\n  @include box-pack($pack);\n  @include box-align($align);\n}\n\n@mixin display-box {\n  display: -webkit-box;\n  display: -moz-box;\n  display: box;\n}\n\n@mixin box-orient($orient: inline-axis) {\n// horizontal|vertical|inline-axis|block-axis|inherit\n  @include prefixer(box-orient, $orient, webkit moz spec);\n}\n\n@mixin box-pack($pack: start) {\n// start|end|center|justify\n  @include prefixer(box-pack, $pack, webkit moz spec);\n}\n\n@mixin box-align($align: stretch) {\n// start|end|center|baseline|stretch\n  @include prefixer(box-align, $align, webkit moz spec);\n}\n\n@mixin box-direction($direction: normal) {\n// normal|reverse|inherit\n  @include prefixer(box-direction, $direction, webkit moz spec);\n}\n\n@mixin box-lines($lines: single) {\n// single|multiple\n  @include prefixer(box-lines, $lines, webkit moz spec);\n}\n\n@mixin box-ordinal-group($int: 1) {\n  @include prefixer(box-ordinal-group, $int, webkit moz spec);\n}\n\n@mixin box-flex($value: 0.0) {\n  @include prefixer(box-flex, $value, webkit moz spec);\n}\n\n@mixin box-flex-group($int: 1) {\n  @include prefixer(box-flex-group, $int, webkit moz spec);\n}\n")
        .mock_file("lib/css3/_font-face.scss", "// Order of the includes matters, and it is: normal, bold, italic, bold+italic.\n\n@mixin font-face($font-family, $file-path, $weight: normal, $style: normal, $asset-pipeline: false ) {\n  @font-face {\n    font-family: $font-family;\n    font-weight: $weight;\n    font-style: $style;\n\n    @if $asset-pipeline == true {\n      src: font-url('#{$file-path}.eot');\n      src: font-url('#{$file-path}.eot?#iefix')          format('embedded-opentype'),\n           font-url('#{$file-path}.woff')                format('woff'),\n           font-url('#{$file-path}.ttf')                 format('truetype'),\n           font-url('#{$file-path}.svg##{$font-family}') format('svg');\n    } @else {\n      src: url('#{$file-path}.eot');\n      src: url('#{$file-path}.eot?#iefix')               format('embedded-opentype'),\n           url('#{$file-path}.woff')                     format('woff'),\n           url('#{$file-path}.ttf')                      format('truetype'),\n           url('#{$file-path}.svg##{$font-family}')      format('svg');\n    }\n  }\n}\n")
        .mock_file("lib/css3/_hidpi-media-query.scss", "// HiDPI mixin. Default value set to 1.3 to target Google Nexus 7 (http://bjango.com/articles/min-device-pixel-ratio/)\n@mixin hidpi($ratio: 1.3) {\n  @media only screen and (-webkit-min-device-pixel-ratio: $ratio),\n  only screen and (min--moz-device-pixel-ratio: $ratio),\n  only screen and (-o-min-device-pixel-ratio: #{$ratio}/1),\n  only screen and (min-resolution: #{round($ratio*96)}dpi),\n  only screen and (min-resolution: #{$ratio}dppx) {\n    @content;\n  }\n}\n")
        .mock_file("lib/css3/_image-rendering.scss", "@mixin image-rendering ($mode:optimizeQuality) {\n\n  @if ($mode == optimize-contrast) {\n      image-rendering: -moz-crisp-edges;\n      image-rendering: -o-crisp-edges;\n      image-rendering: -webkit-optimize-contrast;\n      image-rendering: optimize-contrast;\n  }\n\n  @else {\n      image-rendering: $mode;\n  }\n}\n")
        .mock_file("lib/css3/_inline-block.scss", "// Legacy support for inline-block in IE7 (maybe IE6)\n@mixin inline-block {\n  display: inline-block;\n  vertical-align: baseline;\n  zoom: 1;\n  *display: inline;\n  *vertical-align: auto;\n}\n")
        .mock_file("lib/css3/_keyframes.scss", "// Adds keyframes blocks for supported prefixes, removing redundant prefixes in the block's content\n@mixin keyframes($name) {\n  $original-prefix-for-webkit:    $prefix-for-webkit;\n  $original-prefix-for-mozilla:   $prefix-for-mozilla;\n  $original-prefix-for-microsoft: $prefix-for-microsoft;\n  $original-prefix-for-opera:     $prefix-for-opera;\n  $original-prefix-for-spec:      $prefix-for-spec;\n\n  @if $original-prefix-for-webkit {\n    @include disable-prefix-for-all();\n    $prefix-for-webkit: true;\n    #{\"@-webkit-keyframes\"} #{$name} {\n      @content;\n    }\n  }\n  @if $original-prefix-for-mozilla {\n    @include disable-prefix-for-all();\n    $prefix-for-mozilla: true;\n    #{\"@-moz-keyframes\"} #{$name} {\n      @content;\n    }\n  }\n  @if $original-prefix-for-opera {\n    @include disable-prefix-for-all();\n    $prefix-for-opera: true;\n    #{\"@-o-keyframes\"} #{$name} {\n      @content;\n    }\n  }\n  @if $original-prefix-for-spec {\n    @include disable-prefix-for-all();\n    $prefix-for-spec: true;\n    #{\"@keyframes\"} #{$name} {\n      @content;\n    }\n  }\n\n  $prefix-for-webkit:    $original-prefix-for-webkit;\n  $prefix-for-mozilla:   $original-prefix-for-mozilla;\n  $prefix-for-microsoft: $original-prefix-for-microsoft;\n  $prefix-for-opera:     $original-prefix-for-opera;\n  $prefix-for-spec:      $original-prefix-for-spec;\n}\n")
        .mock_file("lib/css3/_linear-gradient.scss", "@mixin linear-gradient($pos, $G1, $G2: false,\n                       $G3: false, $G4: false,\n                       $G5: false, $G6: false,\n                       $G7: false, $G8: false,\n                       $G9: false, $G10: false,\n                       $deprecated-pos1: left top,\n                       $deprecated-pos2: left bottom,\n                       $fallback: false) {\n  // Detect what type of value exists in $pos\n  $pos-type: type-of(nth($pos, 1));\n  $pos-spec: null;\n  $pos-degree: null;\n\n  // If $pos is missing from mixin, reassign vars and add default position\n  @if ($pos-type == color) or (nth($pos, 1) == \"transparent\")  {\n    $G10: $G9; $G9: $G8; $G8: $G7; $G7: $G6; $G6: $G5;\n     $G5: $G4; $G4: $G3; $G3: $G2; $G2: $G1; $G1: $pos;\n     $pos: null;\n  }\n\n  @if $pos {\n    $positions: _linear-positions-parser($pos);\n    $pos-degree: nth($positions, 1);\n    $pos-spec:   nth($positions, 2);\n  }\n\n  $full: compact($G1, $G2, $G3, $G4, $G5, $G6, $G7, $G8, $G9, $G10);\n\n  // Set $G1 as the default fallback color\n  $fallback-color: nth($G1, 1);\n\n  // If $fallback is a color use that color as the fallback color\n  @if (type-of($fallback) == color) or ($fallback == \"transparent\") {\n    $fallback-color: $fallback;\n  }\n\n  background-color: $fallback-color;\n  background-image: _deprecated-webkit-gradient(linear, $deprecated-pos1, $deprecated-pos2, $full); // Safari <= 5.0\n  background-image: -webkit-linear-gradient($pos-degree $full); // Safari 5.1+, Chrome\n  background-image: unquote(\"linear-gradient(#{$pos-spec}#{$full})\");\n}\n")
        .mock_file("lib/css3/_perspective.scss", "@mixin perspective($depth: none) {\n  // none | <length>\n  @include prefixer(perspective, $depth, webkit moz spec);\n}\n\n@mixin perspective-origin($value: 50% 50%) {\n  @include prefixer(perspective-origin, $value, webkit moz spec);\n}\n")
        .mock_file("lib/css3/_placeholder.scss", "$placeholders: '-webkit-input-placeholder',\n               '-moz-placeholder',\n               '-ms-input-placeholder';\n\n@mixin placeholder {\n  @each $placeholder in $placeholders {\n    @if $placeholder == \"-webkit-input-placeholder\" {\n      &::#{$placeholder} {\n        @content;\n      }\n    }\n    @else if $placeholder == \"-moz-placeholder\" {\n      // FF 18-\n      &:#{$placeholder} {\n        @content;\n      }\n\n      // FF 19+\n      &::#{$placeholder} {\n        @content;\n      }\n    }\n    @else {\n      &:#{$placeholder} {\n        @content;\n      }\n    }\n  }\n}\n")
        .mock_file("lib/css3/_radial-gradient.scss", "// Requires Sass 3.1+\n@mixin radial-gradient($G1,        $G2,\n                       $G3: false, $G4: false,\n                       $G5: false, $G6: false,\n                       $G7: false, $G8: false,\n                       $G9: false, $G10: false,\n                       $pos: null,\n                       $shape-size: null,\n                       $deprecated-pos1: center center,\n                       $deprecated-pos2: center center,\n                       $deprecated-radius1: 0,\n                       $deprecated-radius2: 460,\n                       $fallback: false) {\n\n  $data: _radial-arg-parser($G1, $G2, $pos, $shape-size);\n  $G1:  nth($data, 1);\n  $G2:  nth($data, 2);\n  $pos: nth($data, 3);\n  $shape-size: nth($data, 4);\n\n  $full: compact($G1, $G2, $G3, $G4, $G5, $G6, $G7, $G8, $G9, $G10);\n\n  // Strip deprecated cover/contain for spec\n  $shape-size-spec: _shape-size-stripper($shape-size);\n\n  // Set $G1 as the default fallback color\n  $first-color: nth($full, 1);\n  $fallback-color: nth($first-color, 1);\n\n  @if (type-of($fallback) == color) or ($fallback == \"transparent\") {\n    $fallback-color: $fallback;\n  }\n\n  // Add Commas and spaces\n  $shape-size: if($shape-size, '#{$shape-size}, ', null);\n  $pos:        if($pos, '#{$pos}, ', null);\n  $pos-spec:   if($pos, 'at #{$pos}', null);\n  $shape-size-spec: if(($shape-size-spec != ' ') and ($pos == null), '#{$shape-size-spec}, ', '#{$shape-size-spec} ');\n\n  background-color:  $fallback-color;\n  background-image: _deprecated-webkit-gradient(radial, $deprecated-pos1, $deprecated-pos2, $full, $deprecated-radius1, $deprecated-radius2); // Safari <= 5.0 && IOS 4\n  background-image: -webkit-radial-gradient(unquote(#{$pos}#{$shape-size}#{$full}));\n  background-image: unquote(\"radial-gradient(#{$shape-size-spec}#{$pos-spec}#{$full})\");\n}\n")
        .mock_file("lib/css3/_transform.scss", "@mixin transform($property: none) {\n//  none | <transform-function>\n  @include prefixer(transform, $property, webkit moz ms o spec);\n}\n\n@mixin transform-origin($axes: 50%) {\n// x-axis - left | center | right  | length | %\n// y-axis - top  | center | bottom | length | %\n// z-axis -                          length\n  @include prefixer(transform-origin, $axes, webkit moz ms o spec);\n}\n\n@mixin transform-style ($style: flat) {\n  @include prefixer(transform-style, $style, webkit moz ms o spec);\n}\n")
        .mock_file("lib/css3/_transition.scss", "// Shorthand mixin. Supports multiple parentheses-deliminated values for each variable.\n// Example: @include transition (all, 2.0s, ease-in-out);\n//          @include transition ((opacity, width), (1.0s, 2.0s), ease-in, (0, 2s));\n//          @include transition ($property:(opacity, width), $delay: (1.5s, 2.5s));\n\n@mixin transition ($properties...) {\n  @if length($properties) >= 1 {\n    @include prefixer(transition, $properties, webkit moz spec);\n  }\n\n  @else {\n    $properties: all 0.15s ease-out 0;\n    @include prefixer(transition, $properties, webkit moz spec);\n  }\n}\n\n@mixin transition-property ($properties...) {\n   -webkit-transition-property: transition-property-names($properties, 'webkit');\n      -moz-transition-property: transition-property-names($properties, 'moz');\n           transition-property: transition-property-names($properties, false);\n}\n\n@mixin transition-duration ($times...) {\n  @include prefixer(transition-duration, $times, webkit moz spec);\n}\n\n@mixin transition-timing-function ($motions...) {\n// ease | linear | ease-in | ease-out | ease-in-out | cubic-bezier()\n  @include prefixer(transition-timing-function, $motions, webkit moz spec);\n}\n\n@mixin transition-delay ($times...) {\n  @include prefixer(transition-delay, $times, webkit moz spec);\n}\n")
        .mock_file("lib/css3/_user-select.scss", "@mixin user-select($arg: none) {\n  @include prefixer(user-select, $arg, webkit moz ms spec);\n}\n")
        .mock_file("lib/functions/_compact.scss", "// Remove `false` values from a list\n\n@function compact($vars...) {\n  $list: ();\n  @each $var in $vars {\n    @if $var {\n      $list: append($list, $var, comma);\n    }\n  }\n  @return $list;\n}\n")
        .mock_file("lib/functions/_flex-grid.scss", "// Flexible grid\n@function flex-grid($columns, $container-columns: $fg-max-columns) {\n  $width: $columns * $fg-column + ($columns - 1) * $fg-gutter;\n  $container-width: $container-columns * $fg-column + ($container-columns - 1) * $fg-gutter;\n  @return percentage($width / $container-width);\n}\n\n// Flexible gutter\n@function flex-gutter($container-columns: $fg-max-columns, $gutter: $fg-gutter) {\n  $container-width: $container-columns * $fg-column + ($container-columns - 1) * $fg-gutter;\n  @return percentage($gutter / $container-width);\n}\n\n// The $fg-column, $fg-gutter and $fg-max-columns variables must be defined in your base stylesheet to properly use the flex-grid function.\n// This function takes the fluid grid equation (target / context = result) and uses columns to help define each.\n//\n// The calculation presumes that your column structure will be missing the last gutter:\n//\n//   -- column -- gutter -- column -- gutter -- column\n//\n//  $fg-column: 60px;             // Column Width\n//  $fg-gutter: 25px;             // Gutter Width\n//  $fg-max-columns: 12;          // Total Columns For Main Container\n//\n//  div {\n//    width: flex-grid(4);        // returns (315px / 995px) = 31.65829%;\n//    margin-left: flex-gutter(); // returns (25px / 995px) = 2.51256%;\n//\n//    p {\n//      width: flex-grid(2, 4);  // returns (145px / 315px) = 46.031746%;\n//      float: left;\n//      margin: flex-gutter(4);  // returns (25px / 315px) = 7.936508%;\n//    }\n//\n//    blockquote {\n//      float: left;\n//      width: flex-grid(2, 4); // returns (145px / 315px) = 46.031746%;\n//    }\n//  }")
        .mock_file("lib/functions/_grid-width.scss", "@function grid-width($n) {\n  @return $n * $gw-column + ($n - 1) * $gw-gutter;\n}\n\n// The $gw-column and $gw-gutter variables must be defined in your base stylesheet to properly use the grid-width function.\n//\n//  $gw-column: 100px;         // Column Width\n//  $gw-gutter: 40px;          // Gutter Width\n//\n//  div {\n//    width: grid-width(4);    // returns 520px;\n//    margin-left: $gw-gutter; // returns 40px;\n//  }\n")
        .mock_file("lib/functions/_linear-gradient.scss", "@function linear-gradient($pos, $gradients...) {\n  $type: linear;\n  $pos-type: type-of(nth($pos, 1));\n\n  // if $pos doesn't exist, fix $gradient\n  @if ($pos-type == color) or (nth($pos, 1) == \"transparent\")  {\n    $gradients: zip($pos $gradients);\n    $pos: false;\n  }\n\n  $type-gradient: $type, $pos, $gradients;\n  @return $type-gradient;\n}\n")
        .mock_file("lib/functions/_modular-scale.scss", "@function modular-scale($value, $increment, $ratio) {\n  @if $increment > 0 {\n    @for $i from 1 through $increment {\n      $value: ($value * $ratio);\n    }\n  }\n\n  @if $increment < 0 {\n    $increment: abs($increment);\n    @for $i from 1 through $increment {\n      $value: ($value / $ratio);\n    }\n  }\n\n  @return $value;\n}\n\n//  div {\n//                     Increment Up GR with positive value\n//   font-size:        modular-scale(14px,   1, 1.618); // returns: 22.652px\n//\n//                     Increment Down GR with negative value\n//   font-size:        modular-scale(14px,  -1, 1.618); // returns: 8.653px\n//\n//                     Can be used with ceil(round up) or floor(round down)\n//   font-size: floor( modular-scale(14px, 1, 1.618) ); // returns: 22px\n//   font-size:  ceil( modular-scale(14px, 1, 1.618) ); // returns: 23px\n//  }\n//\n// modularscale.com\n\n@function golden-ratio($value, $increment) {\n  @return modular-scale($value, $increment, 1.618)\n}\n\n//  div {\n//    font-size: golden-ratio(14px, 1); // returns: 22.652px\n//  }\n//\n// goldenratiocalculator.com\n")
        .mock_file("lib/functions/_px-to-em.scss", "// Convert pixels to ems\n// eg. for a relational value of 12px write em(12) when the parent is 16px\n// if the parent is another value say 24px write em(12, 24)\n\n@function em($pxval, $base: 16) {\n  @return ($pxval / $base) * 1em;\n}\n\n")
        .mock_file("lib/functions/_radial-gradient.scss", "// This function is required and used by the background-image mixin.\n@function radial-gradient($G1,        $G2,\n                       $G3: false, $G4: false,\n                       $G5: false, $G6: false,\n                       $G7: false, $G8: false,\n                       $G9: false, $G10: false,\n                       $pos: null,\n                       $shape-size: null) {\n\n  $data: _radial-arg-parser($G1, $G2, $pos, $shape-size);\n  $G1:  nth($data, 1);\n  $G2:  nth($data, 2);\n  $pos: nth($data, 3);\n  $shape-size: nth($data, 4);\n\n  $type: radial;\n  $gradient: compact($G1, $G2, $G3, $G4, $G5, $G6, $G7, $G8, $G9, $G10);\n\n  $type-gradient: $type, $shape-size $pos, $gradient;\n  @return $type-gradient;\n}\n\n\n")
        .mock_file("lib/functions/_tint-shade.scss", "// Add percentage of white to a color\n@function tint($color, $percent){\n  @return mix(white, $color, $percent);\n}\n\n// Add percentage of black to a color\n@function shade($color, $percent){\n  @return mix(black, $color, $percent);\n}\n")
        .mock_file("lib/functions/_transition-property-name.scss", "// Return vendor-prefixed property names if appropriate\n// Example: transition-property-names((transform, color, background), moz) -> -moz-transform, color, background\n//************************************************************************//\n@function transition-property-names($props, $vendor: false) {\n\t$new-props: ();\n\t\n\t@each $prop in $props {\n\t\t$new-props: append($new-props, transition-property-name($prop, $vendor), comma);\n\t}\n\n\t@return $new-props;\n}\n\n@function transition-property-name($prop, $vendor: false) {\n\t// put other properties that need to be prefixed here aswell\n\t@if $vendor and $prop == transform {\n\t\t@return unquote('-'+$vendor+'-'+$prop);\n\t}\n\t@else {\n\t\t@return $prop;\n\t}\n}")
        .mock_file("lib/helpers/_deprecated-webkit-gradient.scss", "// Render Deprecated Webkit Gradient - Linear || Radial\n//************************************************************************//\n@function _deprecated-webkit-gradient($type,\n                                     $deprecated-pos1, $deprecated-pos2,\n                                     $full,\n                                     $deprecated-radius1: false, $deprecated-radius2: false) {\n  $gradient-list: ();\n  $gradient: false;\n  $full-length: length($full);\n  $percentage: false;\n  $gradient-type: $type;\n\n  @for $i from 1 through $full-length {\n    $gradient: nth($full, $i);\n\n    @if length($gradient) == 2 {\n      $color-stop: color-stop(nth($gradient, 2), nth($gradient, 1));\n      $gradient-list: join($gradient-list, $color-stop, comma);\n    }\n    @else if $gradient != null {\n      @if $i == $full-length {\n        $percentage: 100%;\n      }\n      @else {\n        $percentage: ($i - 1) * (100 / ($full-length - 1)) + \"%\";\n      }\n      $color-stop: color-stop(unquote($percentage), $gradient);\n      $gradient-list: join($gradient-list, $color-stop, comma);\n    }\n  }\n\n  @if $type == radial {\n    $gradient: -webkit-gradient(radial, $deprecated-pos1, $deprecated-radius1, $deprecated-pos2, $deprecated-radius2, $gradient-list);\n  }\n  @else if $type == linear {\n    $gradient: -webkit-gradient(linear, $deprecated-pos1, $deprecated-pos2, $gradient-list);\n  }\n  @return $gradient;\n}\n")
        .mock_file("lib/helpers/_gradient-positions-parser.scss", "@function _gradient-positions-parser($gradient-type, $gradient-positions) {\n  @if $gradient-positions\n  and ($gradient-type == linear)\n  and (type-of($gradient-positions) != color) {\n    $gradient-positions: _linear-positions-parser($gradient-positions);\n  }\n  @else if $gradient-positions\n  and ($gradient-type == radial)\n  and (type-of($gradient-positions) != color) {\n    $gradient-positions: _radial-positions-parser($gradient-positions);\n  }\n  @return $gradient-positions;\n}\n")
        .mock_file("lib/helpers/_linear-positions-parser.scss", "@function _linear-positions-parser($pos) {\n  $type: type-of(nth($pos, 1));\n  $spec: null;\n  $degree: null;\n  $side: null;\n  $corner: null;\n  $length: length($pos);\n  // Parse Side and corner positions\n  @if ($length > 1) {\n    @if nth($pos, 1) == \"to\" { // Newer syntax\n      $side: nth($pos, 2);\n\n      @if $length == 2 { // eg. to top\n        // Swap for backwards compatability\n        $degree: _position-flipper(nth($pos, 2));\n      }\n      @else if $length == 3 { // eg. to top left\n        $corner: nth($pos, 3);\n      }\n    }\n    @else if $length == 2 { // Older syntax (\"top left\")\n      $side: _position-flipper(nth($pos, 1));\n      $corner: _position-flipper(nth($pos, 2));\n    }\n\n    @if (\"#{$side} #{$corner}\" == \"left top\") or (\"#{$side} #{$corner}\" == \"top left\") {\n      $degree: _position-flipper(#{$side}) _position-flipper(#{$corner});\n    }\n    @else if (\"#{$side} #{$corner}\" == \"right top\") or (\"#{$side} #{$corner}\" == \"top right\") {\n      $degree: _position-flipper(#{$side}) _position-flipper(#{$corner});\n    }\n    @else if (\"#{$side} #{$corner}\" == \"right bottom\") or (\"#{$side} #{$corner}\" == \"bottom right\") {\n      $degree: _position-flipper(#{$side}) _position-flipper(#{$corner});\n    }\n    @else if (\"#{$side} #{$corner}\" == \"left bottom\") or (\"#{$side} #{$corner}\" == \"bottom left\") {\n      $degree: _position-flipper(#{$side}) _position-flipper(#{$corner});\n    }\n    $spec: to $side $corner;\n  }\n  @else if $length == 1 {\n    // Swap for backwards compatability\n    @if $type == string {\n      $degree: $pos;\n      $spec: to _position-flipper($pos);\n    }\n    @else {\n      $degree: -270 - $pos; //rotate the gradient opposite from spec\n      $spec: $pos;\n    }\n  }\n  $degree: unquote($degree + \",\");\n  $spec:   unquote($spec + \",\");\n  @return $degree $spec;\n}\n\n@function _position-flipper($pos) {\n @return if($pos == left, right, null)\n         if($pos == right, left, null)\n         if($pos == top, bottom, null)\n         if($pos == bottom, top, null);\n}\n")
        .mock_file("lib/helpers/_radial-arg-parser.scss", "@function _radial-arg-parser($G1, $G2, $pos, $shape-size) {\n  @each $value in $G1, $G2 {\n    $first-val: nth($value, 1);\n    $pos-type:  type-of($first-val);\n    $spec-at-index: null;\n\n    // Determine if spec was passed to mixin\n    @if type-of($value) == list {\n      $spec-at-index: if(index($value, at), index($value, at), false);\n    }\n    @if $spec-at-index {\n      @if $spec-at-index > 1 {\n        @for $i from 1 through ($spec-at-index - 1) {\n          $shape-size: $shape-size nth($value, $i);\n        }\n        @for $i from ($spec-at-index + 1) through length($value) {\n          $pos: $pos nth($value, $i);\n        }\n      }\n      @else if $spec-at-index == 1 {\n        @for $i from ($spec-at-index + 1) through length($value) {\n          $pos: $pos nth($value, $i);\n        }\n      }\n      $G1: false;\n    }\n\n    // If not spec calculate correct values\n    @else {\n      @if ($pos-type != color) or ($first-val != \"transparent\") {\n        @if ($pos-type == number)\n        or ($first-val == \"center\")\n        or ($first-val == \"top\")\n        or ($first-val == \"right\")\n        or ($first-val == \"bottom\")\n        or ($first-val == \"left\") {\n\n          $pos: $value;\n\n          @if $pos == $G1 {\n            $G1: false;\n          }\n        }\n\n        @else if\n           ($first-val == \"ellipse\")\n        or ($first-val == \"circle\")\n        or ($first-val == \"closest-side\")\n        or ($first-val == \"closest-corner\")\n        or ($first-val == \"farthest-side\")\n        or ($first-val == \"farthest-corner\")\n        or ($first-val == \"contain\")\n        or ($first-val == \"cover\") {\n\n          $shape-size: $value;\n\n          @if $value == $G1 {\n            $G1: false;\n          }\n\n          @else if $value == $G2 {\n            $G2: false;\n          }\n        }\n      }\n    }\n  }\n  @return $G1, $G2, $pos, $shape-size;\n}\n")
        .mock_file("lib/helpers/_radial-positions-parser.scss", "@function _radial-positions-parser($gradient-pos) {\n  $shape-size: nth($gradient-pos, 1);\n  $pos:        nth($gradient-pos, 2);\n  $shape-size-spec: _shape-size-stripper($shape-size);\n\n  $pre-spec: unquote(if($pos, \"#{$pos}, \", null))\n             unquote(if($shape-size, \"#{$shape-size},\", null));\n  $pos-spec: if($pos, \"at #{$pos}\", null);\n\n  $spec: \"#{$shape-size-spec} #{$pos-spec}\";\n\n  // Add comma\n  @if ($spec != '  ') {\n    $spec: \"#{$spec},\"\n  }\n\n  @return $pre-spec $spec;\n}\n")
        .mock_file("lib/helpers/_render-gradients.scss", "// User for linear and radial gradients within background-image or border-image properties\n\n@function _render-gradients($gradient-positions, $gradients, $gradient-type, $vendor: false) {\n  $pre-spec: null;\n  $spec: null;\n  $vendor-gradients: null;\n  @if $gradient-type == linear {\n    @if $gradient-positions {\n      $pre-spec: nth($gradient-positions, 1);\n      $spec:     nth($gradient-positions, 2);\n    }\n  }\n  @else if $gradient-type == radial {\n    $pre-spec: nth($gradient-positions, 1);\n    $spec:     nth($gradient-positions, 2);\n  }\n\n  @if $vendor {\n    $vendor-gradients: -#{$vendor}-#{$gradient-type}-gradient(#{$pre-spec} $gradients);\n  }\n  @else if $vendor == false {\n    $vendor-gradients: \"#{$gradient-type}-gradient(#{$spec} #{$gradients})\";\n    $vendor-gradients: unquote($vendor-gradients);\n  }\n  @return $vendor-gradients;\n}\n")
        .mock_file("lib/helpers/_shape-size-stripper.scss", "@function _shape-size-stripper($shape-size) {\n  $shape-size-spec: null;\n  @each $value in $shape-size {\n    @if ($value == \"cover\") or ($value == \"contain\") {\n      $value: null;\n    }\n    $shape-size-spec: \"#{$shape-size-spec} #{$value}\";\n  }\n  @return $shape-size-spec;\n}\n")
}

#[test]
fn test() {
    assert_eq!(
        runner().ok(
            "@import \"lib/_bourbon.scss\";\n\
             \nbox:hover {\
             \n  @include animation-name(scale, slide);\
             \n  @include animation-duration(2s);\
             \n  @include animation-timing-function(ease);\
             \n  @include animation-iteration-count(infinite);\n\
             \n  // Animation shorthand works the same as the CSS3 animation shorthand\
             \n  @include animation(scale 1s ease-in, slide 2s ease);\
             \n}\n\
             \ndiv {\
             \n  @include appearance(none);\n\
             \n   /* boo boo boo */\
             \n  // Multiple image assets\
             \n  @include background-image(url(\"/images/a.png\"), url(\"images/b.png\"));\n\
             \n  // Image asset with a linear-gradient\
             \n  @include background-image(url(\"/images/a.png\"), linear-gradient(white 0, yellow 50%, transparent 50%));\n\
             \n  // Multiple linear-gradients - Demo\
             \n  @include background-image(linear-gradient(hsla(0, 100%, 100%, 0.25) 0%, hsla(0, 100%, 100%, 0.08) 50%, transparent 50%),\
             \n                             linear-gradient(#4e7ba3, darken(#4e7ba4, 10%)));\n\
             \n  // NOT SUPPORTED - Multiple image assets with shorthand notation\
             \n  @include background-image(url(\"/images/a.png\") center no-repeat, url(\"images/b.png\") left repeat);\
             \n}\n"
        ),
        "box:hover {\
         \n  -webkit-animation-name: scale, slide;\
         \n  -moz-animation-name: scale, slide;\
         \n  animation-name: scale, slide;\
         \n  -webkit-animation-duration: 2s;\
         \n  -moz-animation-duration: 2s;\
         \n  animation-duration: 2s;\
         \n  -webkit-animation-timing-function: ease;\
         \n  -moz-animation-timing-function: ease;\
         \n  animation-timing-function: ease;\
         \n  -webkit-animation-iteration-count: infinite;\
         \n  -moz-animation-iteration-count: infinite;\
         \n  animation-iteration-count: infinite;\
         \n  -webkit-animation: scale 1s ease-in, slide 2s ease;\
         \n  -moz-animation: scale 1s ease-in, slide 2s ease;\
         \n  animation: scale 1s ease-in, slide 2s ease;\
         \n}\
         \ndiv {\
         \n  -webkit-appearance: none;\
         \n  -moz-appearance: none;\
         \n  -ms-appearance: none;\
         \n  -o-appearance: none;\
         \n  appearance: none;\
         \n  /* boo boo boo */\
         \n  background-image: url(\"/images/a.png\"), url(\"images/b.png\");\
         \n  background-image: url(\"/images/a.png\"), url(\"images/b.png\");\
         \n  background-image: url(\"/images/a.png\"), -webkit-linear-gradient(white 0, yellow 50%, transparent 50%);\
         \n  background-image: url(\"/images/a.png\"), linear-gradient( white 0, yellow 50%, transparent 50%);\
         \n  background-image: -webkit-linear-gradient(hsla(0deg, 100%, 100%, 0.25) 0%, hsla(0deg, 100%, 100%, 0.08) 50%, transparent 50%), -webkit-linear-gradient(#4e7ba3, #3e6181);\
         \n  background-image: linear-gradient( hsla(0deg, 100%, 100%, 0.25) 0%, hsla(0deg, 100%, 100%, 0.08) 50%, transparent 50%), linear-gradient( #4e7ba3, #3e6181);\
         \n  background-image: -webkit-url(\"/images/a.png\")-gradient(center), -webkit-url(\"images/b.png\")-gradient(left);\
         \n  background-image: url(\"/images/a.png\")-gradient( center), url(\"images/b.png\")-gradient( left);\
         \n}\n"
    );
}
