#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/aci_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int attr_list[RSBAC_IPC_NR_ATTRIBUTES] = RSBAC_IPC_ATTR_LIST;
  int res;
  u_int position;
  char tmp1[80],tmp2[120];
  int j,i;
  enum rsbac_switch_target_t module;
  union rsbac_attribute_value_t value;
  union rsbac_target_id_t tid;
  enum rsbac_ipc_type_t ipc_target;
  enum rsbac_attribute_t attr;
  rsbac_pid_t pid;
  int    sid;
  char * progname = argv[0];

  locale_init();

  if(argc > 1)
    {
      module = get_switch_target_nr(argv[1]);
      if(module != SW_NONE)
        {
          argv++;
          argc--;
        }
    }
  if(   ((argc == 5) || (argc == 6))
     && (!strcmp(argv[3],"mac_categories")))
    {
      if((ipc_target = get_ipc_target_nr(argv[1])) == I_none)
        {
          fprintf(stderr, gettext("%s: Invalid IPC type %s!\n"), progname, argv[1]);
          exit(1);
        }
      tid.ipc.type = ipc_target;
      tid.ipc.id.id_nr = strtol(argv[2],0,10);

/*      value.dummy = -1; */
      position = strtol(argv[3],0,10);
      if(position > RSBAC_MAC_MAX_CAT)
        {
          fprintf(stderr, gettext("Invalid position counter %s\n"), argv[3]);
          exit(1);
        }
      res = rsbac_get_attr(module, T_IPC, &tid, A_mac_categories, &value, 0);
      error_exit(res);
      printf("%u\n",
             (u_int) (value.mac_categories >> position) & 1);
      exit(0);
    }

  if ((argc == 4)||(argc == 5))
    {
      if((ipc_target = get_ipc_target_nr(argv[1])) == I_none)
        {
          fprintf(stderr, gettext("%s: Invalid IPC type %s!\n"), progname, argv[1]);
          exit(1);
        }
      tid.ipc.type = ipc_target;
      tid.ipc.id.id_nr = strtol(argv[2],0,10);

      attr = get_attribute_nr(argv[3]);
      if(attr == A_none)
        {
          fprintf(stderr, gettext("%s: Invalid Attribute %s!\n"), tmp2, argv[3]);
          exit(1);
        }
/*      value.dummy = -1; */
      res = rsbac_get_attr(module, T_IPC, &tid, attr, &value, 0);
      error_exit(res);
      switch(attr)
        {
          case A_ms_str_nr:
          case A_ms_str_offset:
            for(i=0; i<RSBAC_MS_NR_MALWARE; i++)
              printf("%i ",value.ms_str_nr[i]);
            printf("\n");
            break;
          case A_rc_type:
          case A_rc_type_fd:
          case A_rc_force_role:
          case A_rc_role:
          case A_rc_def_role:
            printf("%u\n",value.rc_type);
            break;
          case A_security_level:
            printf("%u\n",value.u_char_dummy);
            break;
          default:
            printf("%i\n",value.dummy);
        }
      exit(0);
    }

  printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
  printf(gettext("Use: %s (sockid process-id socket-fd)|(ipc-type id) attribute\n"),
         progname);  
  printf(gettext("- ipc-types: sem, msg, shm, sockid,\n"));
  printf(gettext("- attribute (string) and returned value = see following list:\n"));
  for (j=0;j<RSBAC_IPC_NR_ATTRIBUTES;j++)
    {
      get_attribute_name(tmp1,attr_list[j]);
      get_attribute_param(tmp2,attr_list[j]);
      printf("%s \t%s\n",tmp1,tmp2);
    }
  exit(1);
}
