#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <rsbac/types.h>
#include <rsbac/aci_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int attr_list[RSBAC_PROCESS_NR_ATTRIBUTES] = RSBAC_PROCESS_ATTR_LIST;
  int res = 0;
  char tmp1[RSBAC_MAXNAMELEN],tmp2[RSBAC_MAXNAMELEN],tmp3[RSBAC_MAXNAMELEN];
  int j, position;
  enum rsbac_switch_target_t module;
  union rsbac_attribute_value_t value;
  union rsbac_target_id_t tid;
  enum rsbac_attribute_t attr;
  int printall = 0;
  char * progname = argv[0];

  locale_init();

  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'p':
                printall=1;
                break;
              case 'n':
                {
                  char tmp[80];
                  int i;

                  for(i=0; i<R_NONE; i++)
                    printf("%s\n", get_request_name(tmp, i));
                  exit(0);
                }
              case 'a':
              case 'A':
                if(   (argc > 2)
                   && ((attr = get_attribute_nr(argv[2])) != A_none)
                  )
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr));
                    get_attribute_name(tmp2, attr);
                    get_attribute_param(tmp3, attr);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                    exit(0);
                  }
                printf(gettext("- attribute (string) and returned value = see following list:\n"));
                for (j=0;j<RSBAC_PROCESS_NR_ATTRIBUTES;j++)
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr_list[j]));
                    get_attribute_name(tmp2,attr_list[j]);
                    get_attribute_param(tmp3,attr_list[j]);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                  }
                exit(0);

              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  
  if(argc > 1)
    {
      module = get_switch_target_nr(argv[1]);
      if(module != SW_NONE)
        {
          argv++;
          argc--;
        }
    }
  switch(argc)
    {
      case 3:
        attr = get_attribute_nr(argv[2]);
        if(attr == A_none)
          {
            fprintf(stderr, gettext("%s: Invalid Attribute %s!\n"), argv[0], argv[2]);
            exit(1);
          }
        value.dummy = -1;
        tid.process = strtol(argv[1],0,10);
        res = rsbac_get_attr(module, T_PROCESS, &tid, attr, &value, FALSE);
        error_exit(res);
        switch(attr)
          {
            case A_mac_process_flags:
            case A_pm_process_type:
            case A_ms_trusted:
            case A_ms_sock_trusted_tcp:
            case A_ms_sock_trusted_udp:
            case A_security_level:
            case A_initial_security_level:
            case A_min_security_level:
            case A_current_sec_level:
            case A_min_write_open:
            case A_max_read_open:
            case A_cap_process_hiding:
              printf("%u\n",value.u_char_dummy);
              break;
            case A_rc_type:
            case A_rc_type_fd:
            case A_rc_force_role:
            case A_rc_role:
            case A_rc_def_role:
              printf("%u\n",value.rc_role);
              break;
            case A_mac_categories:
            case A_mac_initial_categories:
            case A_mac_min_categories:
            case A_mac_curr_categories:
            case A_max_read_categories:
            case A_min_write_categories:
              printf("%s\n",u64tostrmac(tmp1,value.mac_categories));
              break;
            case A_log_program_based:
              if(printall)
                {
                  int i;

                  for (i=0; i<R_NONE; i++)
                    if(value.log_program_based & ((rsbac_request_vector_t) 1 << i))
                      printf(" %s\n", get_request_name(tmp1,i));
                }
              else
                printf("%s\n",u64tostrlog(tmp1,value.log_program_based));
              break;
            case A_jail_ip:
              {
                struct in_addr addr;

                addr.s_addr = value.jail_ip;
                printf("%s\n", inet_ntoa(addr));
                break;
              }

            default:
              printf("%i\n",value.dummy);
          }
        exit(0);

      case 4:
        attr = get_attribute_nr(argv[2]);
        switch(attr)
          {
            case A_mac_categories:
            case A_mac_initial_categories:
            case A_mac_min_categories:
            case A_mac_curr_categories:
            case A_max_read_categories:
            case A_min_write_categories:
            case A_log_program_based:
              break;
            default:
              fprintf(stderr, gettext("%s: Invalid Attribute %s!\n"), argv[0], argv[2]);
              exit(1);
          }
        tid.process = strtol(argv[1],0,10);
        position = strtol(argv[3],0,10);
        if(position > RSBAC_MAC_MAX_CAT)
          {
            fprintf(stderr, gettext("Invalid position counter %s\n"), argv[3]);
            exit(1);
          }
        res = rsbac_get_attr(module, T_PROCESS, &tid, attr, &value, 0);
        error_exit(res);
        printf("%u\n",
               (u_int) (value.mac_categories >> position) & 1);
        exit(0);

      default:
        printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
        printf(gettext("Use: %s [switches] module pid attribute [bit-no]\n"), argv[0]);  
        printf(gettext("- -p = print all request names, -n = list all request names\n"));
        printf(gettext("- -a = list attributes and values\n"));
        printf(gettext("- module = GEN, MAC, FC, SIM, PM, MS, FF, RC or AUTH\n"));
        printf(gettext("categories and log_program_based\t(with additional parameter bit-no)\n\t\t\t0=no, 1=yes\n"));
    }
  exit(1);
}

