#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/aci_data_structures.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  char tmp1[RSBAC_MAXNAMELEN],tmp2[RSBAC_MAXNAMELEN];
  char *key = (void *) 0;
  int i;
  int id;
  enum rsbac_switch_target_t module;
  union rsbac_attribute_value_t value;
  enum rsbac_target_t target;
  union rsbac_target_id_t tid;
  enum rsbac_attribute_t attr;
  struct passwd * user_info_p;
  char * progname = argv[0];
  int inherit = 0;

  locale_init();
  
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'e':
                inherit=1;
                break;
              case 'a':
              case 'A':
                {
                  int u_attr_list[RSBAC_USER_NR_ATTRIBUTES] = RSBAC_USER_ATTR_LIST;
                  int p_attr_list[RSBAC_PROCESS_NR_ATTRIBUTES] = RSBAC_PROCESS_ATTR_LIST;
                  char tmp3[RSBAC_MAXNAMELEN];

                  if(   (argc > 2)
                     && ((attr = get_attribute_nr(argv[2])) != A_none)
                    )
                    {
                      get_switch_target_name(tmp1, get_attr_module(attr));
                      get_attribute_name(tmp2, attr);
                      get_attribute_param(tmp3, attr);
                      printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                      exit(0);
                    }
                  printf(gettext("- attribute (string) and returned value = see following list:\n"));
                  printf("USER:\n");
                  for (i=0;i<RSBAC_USER_NR_ATTRIBUTES;i++)
                    {
                      get_switch_target_name(tmp1, get_attr_module(u_attr_list[i]));
                      get_attribute_name(tmp2,u_attr_list[i]);
                      get_attribute_param(tmp3,u_attr_list[i]);
                      printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                    }
                  printf("\nPROCESS:\n");
                  for (i=0;i<RSBAC_PROCESS_NR_ATTRIBUTES;i++)
                    {
                      get_switch_target_name(tmp1, get_attr_module(p_attr_list[i]));
                      get_attribute_name(tmp2,p_attr_list[i]);
                      get_attribute_param(tmp3,p_attr_list[i]);
                      printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                    }
                  exit(0);
                }
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if(argc > 1)
    {
      module = get_switch_target_nr(argv[1]);
      if(module != SW_NONE)
        {
          argv++;
          argc--;
        }
    }
  if (argc > 3)
    {
      printf(gettext("%s: %i targets\n\n"), progname, argc - 3);
      target = get_target_nr(argv[1]);
      if(   (target != T_PROCESS)
         && (target != T_USER))
        {
          fprintf(stderr, gettext("%s: Invalid Target %s!\n"), progname, argv[1]);
          exit(1);
        }
      attr = get_attribute_nr(argv[2]);
      if(attr == A_none)
        {
          fprintf(stderr, gettext("%s: Invalid Attribute %s!\n"), progname, argv[2]);
          exit(1);
        }
      for (i=1;i < (argc-2);i++)
        {
          value.dummy = -1;
          if (target == T_PROCESS)
            {
              id = strtol(argv[i+2],0,10);
              printf(gettext("Processing process %i, attribute %s (No. %i)\n"),
                      id, argv[2], attr);
              tid.process = id;
              inherit = 0;
            }
          else
            {
              if(   (!(user_info_p = getpwnam(argv[i+2])))
                 && (!(user_info_p = getpwuid(strtol(argv[i+2],0,10)))) )
                {
                  fprintf(stderr, gettext("Invalid user %s!\n\n"), argv[i+2]);
                  continue;
                }
              printf(gettext("Processing user %s (uid %i), attribute %s (No. %i)\n"),
                     user_info_p->pw_name, user_info_p->pw_uid, argv[2], attr);
              tid.user = user_info_p->pw_uid;
            }

          res = rsbac_get_attr(module, target, &tid, attr, &value, inherit);
          error_exit(res);
          switch(attr)
            {
              case A_mac_role:
              case A_fc_role:
              case A_sim_role:
              case A_pm_role:
              case A_ms_role:
              case A_ff_role:
              case A_pm_process_type:
              case A_ms_trusted:
              case A_ms_sock_trusted_tcp:
              case A_ms_sock_trusted_udp:
              case A_rc_type:
              case A_rc_type_fd:
              case A_rc_force_role:
              case A_rc_role:
              case A_rc_def_role:
              case A_auth_role:
              case A_cap_role:
              case A_min_caps:
              case A_max_caps:
              case A_security_level:
              case A_current_sec_level:
              case A_min_write_open:
              case A_max_read_open:
              case A_cap_process_hiding:
                printf(gettext("Returned value: %u\n"),value.u_char_dummy);
                break;
              default:
                printf(gettext("Returned value: %i\n"),value.dummy);
            }
        }
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [switches] module target-type attribute user(s)/proc-no.\n\n"), progname);  
      printf(gettext("- -a = list attributes and values\n"));
      printf(gettext("- module = GEN, MAC, FC, SIM, PM, MS, FF, RC or AUTH\n"));
      printf(gettext("- target-type = USER or PROCESS,\n"));
    }
    
  return (res);
}
