#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rsbac/types.h>
#include <rsbac/aci_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  char tmp1[80];
  enum rsbac_target_t target;

  locale_init();
  
  if (argc == 3)
    {
      target = get_target_nr(argv[1]);
      res = rsbac_remove_target_n(target, argv[2]);
      if(res)
        {
          get_error_name(tmp1,res);
          fprintf(stderr, gettext("%s: error: %s\n"), argv[0], tmp1);
          exit(1);
        }
      exit(0);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s target-type file/dirname\n"), argv[0]);  
      printf(gettext("- target-type = FILE, DIR, FIFO, SYMLINK or DEV\n"));
    }
  exit(1);
}
