#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <rsbac/types.h>
#include <rsbac/aci_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int verbose=0;
int recurse=0;
rsbac_version_t version=RSBAC_VERSION_NR;
union rsbac_attribute_value_t value;
enum rsbac_switch_target_t module;
enum rsbac_target_t target;
enum rsbac_attribute_t attr;
char * progname;
char * target_n;

int process(char * name)
  {
    int res = 0;
    char tmp1[RSBAC_MAXNAMELEN];
    char tmp2[RSBAC_MAXNAMELEN];
    struct stat buf;

    if(verbose)
      printf(gettext("Processing %s '%s', attribute %s, value %i\n"),
             target_n,
             name,
             get_attribute_name(tmp2,attr),
             value.dummy);
    res = rsbac_set_attr_n(module, target, name, attr, &value);
    if(res)
      {
        get_error_name(tmp1,res);
        if(   verbose
           || (res != -RSBAC_EINVALIDTARGET)
          )
          fprintf(stderr, gettext("%s: error: %s\n"), name, tmp1);
      }

do_recurse:
    if(   !lstat(name,&buf)
       && S_ISDIR(buf.st_mode)
       && recurse)
      {
        DIR * dir_stream_p;
        struct dirent * dirent_p;
        char name2[PATH_MAX];

        if(S_ISLNK(buf.st_mode))
          return(0);
        if(!(dir_stream_p = opendir(name)))
          {
            fprintf(stderr, gettext("opendir for dir %s returned error: %s\n"),
                   name,
                   strerror(errno));
            return(-2);
          }
        while((dirent_p = readdir(dir_stream_p)))
          {
            if(   (strcmp(".",dirent_p->d_name))
               && (strcmp("..",dirent_p->d_name)) )
              {
                strcpy(name2,name);
                strcat(name2,"/");
                strcat(name2,dirent_p->d_name);
                process(name2);
              }
          }
        closedir(dir_stream_p);
      }
    return(0);
  }

int main(int argc, char ** argv)
{
  enum rsbac_attribute_t attr_list[RSBAC_FD_NR_ATTRIBUTES] = RSBAC_FD_ATTR_LIST;
  enum rsbac_attribute_t attr_list_dev[RSBAC_DEV_NR_ATTRIBUTES] = RSBAC_DEV_ATTR_LIST;
  int res = 0;
  char tmp1[RSBAC_MAXNAMELEN],tmp2[RSBAC_MAXNAMELEN],tmp3[RSBAC_MAXNAMELEN];
  int i,j;

  locale_init();
  
  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'r':
                recurse=1;
                break;
              case 'n':
                {
                  char tmp[80];
                  int i;

                  for(i=0; i<R_NONE; i++)
                    printf("%s\n", get_request_name(tmp, i));
                  exit(0);
                }
              case 'a':
              case 'A':
                if(   (argc > 2)
                   && ((attr = get_attribute_nr(argv[2])) != A_none)
                  )
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr));
                    get_attribute_name(tmp2, attr);
                    get_attribute_param(tmp3, attr);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                    exit(0);
                  }
                printf(gettext("- attribute (string) and value (integer) = see following list:\n"));
                printf(gettext("- FILE, DIR, FIFO and SYMLINK:\n"));
                for (j=0;j<RSBAC_FD_NR_ATTRIBUTES;j++)
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr_list[j]));
                    get_attribute_name(tmp2,attr_list[j]);
                    get_attribute_param(tmp3,attr_list[j]);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                  }
                printf("- DEV:\n");
                for (j=0;j<RSBAC_DEV_NR_ATTRIBUTES;j++)
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr_list_dev[j]));
                    get_attribute_name(tmp2,attr_list_dev[j]);
                    get_attribute_param(tmp3,attr_list_dev[j]);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                  }
                exit(0);
              case 'V':
                if(argc < 2)
                  {
                    fprintf(stderr, gettext("%s: no version number for switch V\n"), progname);
                    exit(1);
                  }
                version = strtol(argv[2],0,10);
                argv++;
                argc--;
                break;

              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if(argc > 1)
    {
      module = get_switch_target_nr(argv[1]);
      if(module != SW_NONE)
        {
          argv++;
          argc--;
        }
    }
  if (argc > 4)
    {
      if(verbose)
        printf("%s: %i targets\n\n", progname, argc - 4);
      target = get_target_nr(argv[1]);
      target_n = argv[1];
      if(   (target != T_DIR)
         && (target != T_FILE)
         && (target != T_FIFO)
         && (target != T_SYMLINK)
         && (target != T_DEV)
         && (target != T_FD)
        )
        {
          fprintf(stderr, gettext("%s: Invalid target type %s\n"), progname, argv[1]);
          exit(1);
        }
      attr = get_attribute_nr(argv[2]);
      switch(attr)
        {
          case A_none:
            fprintf(stderr, gettext("%s: Invalid attribute %s\n"), progname, argv[3]);
            exit(1);
          case A_res_min:
          case A_res_max:
            fprintf(stderr, gettext("%s: Attribute %s not supported\n"), progname, argv[3]);
            exit(1);
          case A_log_array_low:
          case A_log_array_high:
            if(strlen(argv[3]) != R_NONE)
              {
                fprintf(stderr, gettext("%s: Invalid attribute value, length must be %i\n"), progname, R_NONE);
                exit(1);
              }
            for(j=0;j<strlen(argv[3]);j++)
              {
                if(   argv[3][j] != '0'
                   && argv[3][j] != '1')
                  {
                    fprintf(stderr, gettext("%s: Invalid attribute value char, must be 0 or 1\n"), progname);
                    exit(1);
                  }
              }
            strtou64log(argv[3], &value.log_array_low);
            break;

          case A_mac_trusted_for_user:
            value.mac_trusted_for_user = strtol(argv[3],0,10);

          default:
            value.dummy = strtol(argv[3],0,10);
        }
      for (i=1;i < (argc-3);i++)
        {
          process(argv[i+3]);
        }
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [-v] [-r] module target-type attribute value file/dirname(s)\n"), progname);  
      printf(gettext("- -v = verbose, -r = recurse into subdirs,\n"));
      printf(gettext("- -n = list all requests\n"));
      printf(gettext("- -a = list attributes and values\n"));
      printf(gettext("  -V version = supply RSBAC integer version number for upgrading\n"));
      printf(gettext("- module = GEN, MAC, FC, SIM, PM, MS, FF, RC or AUTH\n"));
      printf(gettext("- target-type = FILE, DIR, FIFO, SYMLINK, DEV or FD\n"));
      printf(gettext("  (FD: let %s decide between FILE, DIR, FIFO and SYMLINK, no DEV),\n"), progname);
    }
  return (res);
}

