#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/aci_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int attr_list[RSBAC_IPC_NR_ATTRIBUTES] = RSBAC_IPC_ATTR_LIST;
  int res = 0;
  char tmp1[RSBAC_MAXNAMELEN],tmp2[RSBAC_MAXNAMELEN];
  int j;
  char * progname = argv[0];
  enum rsbac_switch_target_t module;
  union rsbac_attribute_value_t value;
  union rsbac_target_id_t tid;
  enum rsbac_ipc_type_t ipc_target;
  enum rsbac_attribute_t attr;
  struct rsbac_ipc_t ipc_id;
  rsbac_pid_t pid;
  int    sid;
  u_int position, catval;
  __u64 k;

  locale_init();

  if(argc > 1)
    {
      module = get_switch_target_nr(argv[1]);
      if(module != SW_NONE)
        {
          argv++;
          argc--;
        }
    }
  if(   ((argc == 6) || (argc == 7))
     && (!strcmp(argv[3],"mac_categories")))
    {
      ipc_id.type = ipc_target;
      ipc_id.id.id_nr = strtol(argv[2],0,10);

      tid.ipc = ipc_id;
      position = strtol(argv[4],0,10);
      if(position > RSBAC_MAC_MAX_CAT)
        {
          fprintf(stderr, gettext("Invalid position counter %s\n"), argv[4]);
          exit(1);
        }
      catval = strtol(argv[5],0,10);
      if(catval > 1)
        {
          fprintf(stderr, gettext("Invalid value %s\n"), argv[5]);
          exit(1);
        }

      res = rsbac_get_attr(module, T_IPC, &tid, A_mac_categories, &value, FALSE);
      error_exit(res);
      k = ((__u64) 1) << position;
      if(catval)
        value.mac_categories |= k;
      else
        value.mac_categories &= ~k;
      res = rsbac_set_attr(module, T_IPC, &tid, A_mac_categories, &value);
      error_exit(res);
      exit(0);
    }
  else
  if ((argc == 5)||(argc == 6))
    {
      if(   ((ipc_target = get_ipc_target_nr(argv[1])) == I_none)
        )
        {
          fprintf(stderr, gettext("%s: Invalid IPC type %s!\n"), progname, argv[1]);
          exit(1);
        }
      ipc_id.type = ipc_target;
      ipc_id.id.id_nr = strtol(argv[2],0,10);

      attr = get_attribute_nr(argv[3]);
      if(attr == A_none)
        {
          fprintf(stderr, gettext("%s: Invalid Attribute %s!\n"), tmp2, argv[3]);
          exit(1);
        }
      tid.ipc = ipc_id;

      value.dummy = strtol(argv[4],0,10);
      res = rsbac_set_attr(module, T_IPC, &tid, attr, &value);
      error_exit(res);
      printf("%i\n",value.dummy);
      exit(0);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s (sockid process-id socket-fd)|(ipc-type id) attribute value\n"),
             progname);  
      printf(gettext("- ipc-types: sem, msg, shm, sockid,\n"));
      printf(gettext("- attribute (string) and value = see following list:\n"));
      for (j=0;j<RSBAC_IPC_NR_ATTRIBUTES;j++)
        {
          get_attribute_name(tmp1,attr_list[j]);
          get_attribute_param(tmp2,attr_list[j]);
          printf("%s \t%s\n",tmp1,tmp2);
        }
    }
  exit(1);
}
