#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <rsbac/types.h>
#include <rsbac/aci_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int attr_list[RSBAC_PROCESS_NR_ATTRIBUTES] = RSBAC_PROCESS_ATTR_LIST;
  int res = 0;
  char tmp1[RSBAC_MAXNAMELEN],tmp2[RSBAC_MAXNAMELEN],tmp3[RSBAC_MAXNAMELEN];
  int j;
  int position, catval;
  rsbac_mac_category_vector_t k;
  enum rsbac_switch_target_t module;
  union rsbac_attribute_value_t value;
  union rsbac_target_id_t tid;
  enum rsbac_attribute_t attr;
  char * progname;
  int verbose = 0;
  int printall = 0;
  int add = 0;
  int remove = 0;

  locale_init();

  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'p':
                printall=1;
                break;
              case 'a':
                add=1;
                break;
              case 'm':
                remove=1;
                break;
              case 'n':
                {
                  char tmp[80];
                  int i;

                  for(i=0; i<R_NONE; i++)
                    printf("%s\n", get_request_name(tmp, i));
                  exit(0);
                }
              case 'A':
                if(   (argc > 2)
                   && ((attr = get_attribute_nr(argv[2])) != A_none)
                  )
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr));
                    get_attribute_name(tmp2, attr);
                    get_attribute_param(tmp3, attr);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                    exit(0);
                  }
                printf(gettext("- attribute (string) and value (integer) = see following list:\n"));
                for (j=0;j<RSBAC_PROCESS_NR_ATTRIBUTES;j++)
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr_list[j]));
                    get_attribute_name(tmp2,attr_list[j]);
                    get_attribute_param(tmp3,attr_list[j]);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                  }
                exit(0);
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if(argc > 1)
    {
      module = get_switch_target_nr(argv[1]);
      if(module != SW_NONE)
        {
          argv++;
          argc--;
        }
    }
  if(   (argc>2)
     && !strcmp(argv[2],"log_program_based")
    )
    {
      char * progname = argv[0];
      boolean rused = FALSE;
      boolean wused = FALSE;
      enum rsbac_adf_request_t request;
      rsbac_request_vector_t request_vector = 0;

      value.log_program_based = 0;
      tid.process = strtol(argv[1],0,10);

      argv+=2;
      argc-=2;

      if(add || remove)
        {
          res = rsbac_get_attr(module, T_PROCESS, &tid, A_log_program_based, &value, FALSE);
          error_exit(res);
        }
      while(argc > 1)
        {
          if(strlen(argv[1]) == R_NONE)
            {
              int j;
              rsbac_request_vector_t tmp_rv;

              for(j=0; j<R_NONE; j++)
                if(   (argv[1][j] != '0')
                   && (argv[1][j] != '1')
                  )
                  {
                    fprintf(stderr, gettext("%s: Invalid mask vector %s\n"), progname, argv[1]);
                    exit(1);
                  }
              strtou64acl(argv[1], &tmp_rv);
              request_vector |= tmp_rv;
              argv++;
              argc--;
              continue;
            }
          request = get_request_nr(argv[1]);
          if(request == R_NONE)
            {
              request = strtol(argv[1],0,10);
              if(   (request >= R_NONE)
                 || (   (request == 0)
                     && strcmp(argv[1],"0")
                    )
                )
                {
                  if(!strcmp(argv[1],"RW"))
                    {
                      request_vector |= RSBAC_READ_WRITE_REQUEST_VECTOR;
                    }
                  else
                  if(!strcmp(argv[1],"SY"))
                    {
                      request_vector |= RSBAC_SYSTEM_REQUEST_VECTOR;
                    }
                  else
                  if(!strcmp(argv[1],"SE"))
                    {
                      request_vector |= RSBAC_SECURITY_REQUEST_VECTOR;
                    }
                  else
                  if(!strcmp(argv[1],"R"))
                    {
                      request_vector |= RSBAC_READ_REQUEST_VECTOR;
                      rused = TRUE;
                    }
                  else
                  if(!strcmp(argv[1],"W"))
                    {
                      request_vector |= RSBAC_WRITE_REQUEST_VECTOR;
                      wused = TRUE;
                    }
                  else
                  if(!strcmp(argv[1],"A"))
                    {
                      request_vector |= RSBAC_ALL_REQUEST_VECTOR;
                    }
                  else
                  if(!strcmp(argv[1],"UA"))
                    {
                      request_vector = 0;
                    }
                  else
                  if(!strcmp(argv[1],"NWS"))
                    {
                      request_vector |= RSBAC_NWS_REQUEST_VECTOR;
                    }
                  else
                  if(!strcmp(argv[1],"NWR"))
                    {
                      request_vector |= RSBAC_NWR_REQUEST_VECTOR;
                      rused = TRUE;
                    }
                  else
                  if(!strcmp(argv[1],"NWW"))
                    {
                      request_vector |= RSBAC_NWW_REQUEST_VECTOR;
                      wused = TRUE;
                    }
                  else
                  if(!strcmp(argv[1],"NWC"))
                    {
                      request_vector |= RSBAC_NWC_REQUEST_VECTOR;
                    }
                  else
                  if(!strcmp(argv[1],"NWE"))
                    {
                      request_vector |= RSBAC_NWE_REQUEST_VECTOR;
                    }
                  else
                  if(!strcmp(argv[1],"NWA"))
                    {
                      request_vector |= RSBAC_NWA_REQUEST_VECTOR;
                    }
                  else
                  if(!strcmp(argv[1],"NWF"))
                    {
                      request_vector |= RSBAC_NWF_REQUEST_VECTOR;
                    }
                  else
                  if(!strcmp(argv[1],"NWM"))
                    {
                      request_vector |= RSBAC_NWM_REQUEST_VECTOR;
                    }
                  else
                    { /* end of requests */
                      break;
                    }
                }
            }
          else
            {
              request_vector |= ((rsbac_request_vector_t) 1 << request);
            }
          argv++;
          argc--;
        }
      if(rused && wused)
        {
          request_vector |= RSBAC_READ_WRITE_OPEN_REQUEST_VECTOR;
        }
      if(remove)
          value.log_program_based &= ~request_vector;
      else
          value.log_program_based |= request_vector;

      if(printall)
        {
          int i;

          for (i=0; i<R_NONE; i++)
            if(value.log_program_based & ((rsbac_request_vector_t) 1 << i))
              printf(" %s\n", get_request_name(tmp1,i));
        }

      res = rsbac_set_attr(module, T_PROCESS, &tid, A_log_program_based, &value);
      error_exit(res);
      exit(0);
    }

  
  switch(argc)
    {
      case 4:
        tid.process = strtol(argv[1],0,10);
        attr = get_attribute_nr(argv[2]);
        if(attr == A_none)
          {
            fprintf(stderr, gettext("%s: Invalid Attribute %s!\n"), argv[0], argv[2]);
            exit(1);
          }
        switch(attr)
          {
            case A_mac_categories:
            case A_mac_initial_categories:
            case A_mac_min_categories:
              if(strlen(argv[4]) != RSBAC_MAC_NR_CATS)
                {
                  fprintf(stderr, gettext("%s: Invalid attribute value, length must be %i\n"), argv[0],
                          RSBAC_MAC_NR_CATS);
                  exit(1);
                }
              for(j=0;j<strlen(argv[4]);j++)
                {
                  if(   argv[4][j] != '0'
                     && argv[4][j] != '1')
                    {
                      fprintf(stderr, gettext("%s: Invalid attribute value char, must be 0 or 1\n"), argv[0]);
                      exit(1);
                    }
                }
              strtou64mac(argv[4], &value.mac_categories);
              break;

            case A_jail_ip:
              {
                struct in_addr addr;

                res = inet_aton(argv[4], &addr);
                error_exit(res);
                value.jail_ip = addr.s_addr;
                break;
              }

            case A_mac_process_flags:
              if(add || remove)
                {
                  res = rsbac_get_attr(module, T_PROCESS, &tid, A_mac_process_flags, &value, FALSE);
                  error_exit(res);
                  if(add)
                    value.mac_process_flags |= strtoul(argv[3],0,10);
                  else
                    value.mac_process_flags &= ~strtoul(argv[3],0,10);
                }
              else
                value.mac_process_flags = strtoul(argv[3],0,10);
              break;

            default:
              value.dummy = strtol(argv[3],0,10);
          }
        res = rsbac_set_attr(module, T_PROCESS, &tid, attr, &value);
        error_exit(res);
        exit(0);

      case 5:
        attr = get_attribute_nr(argv[2]);
        switch(attr)
          {
            case A_mac_categories:
            case A_mac_initial_categories:
            case A_mac_min_categories:
            case A_mac_curr_categories:
            case A_max_read_categories:
            case A_min_write_categories:
              break;
            default:
              fprintf(stderr, gettext("%s: Invalid Attribute %s!\n"), argv[0], argv[2]);
              exit(1);
          }
        tid.process = strtol(argv[1],0,10);
        position = strtol(argv[3],0,10);
        if(position > RSBAC_MAC_MAX_CAT)
          {
            fprintf(stderr, gettext("Invalid position counter %s\n"), argv[3]);
            exit(1);
          }
        catval = strtol(argv[4],0,10);
        if(catval > 1)
          {
            fprintf(stderr, gettext("Invalid value %s\n"), argv[4]);
            exit(1);
          }
        res = rsbac_get_attr(module, T_PROCESS, &tid, attr, &value, FALSE);
        error_exit(res);
        k = ((__u64) 1) << position;
        if(catval)
          value.mac_categories |= k;
        else
          value.mac_categories &= ~k;
        res = rsbac_set_attr(module, T_PROCESS, &tid, attr, &value);
        error_exit(res);
        exit(0);

      default:
        printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
        printf(gettext("Use: %s module process-id attribute value\n"), progname);
        printf(gettext("  -p = print resulting requests, -a = add, not set, -m = remove, not set\n"));
        printf(gettext("  -A = list attributes and values\n"));
        printf(gettext("- module = GEN, MAC, FC, SIM, PM, MS, FF, RC or AUTH\n"));
    }
  exit(1);
}
