#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/rc_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/rc_getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define SETPROG "rc_set_item"

/* reserve list room for so many extra items - to avoid racing problems */
#define LISTROOM 10

int main(int argc, char ** argv)
{
  int res = 0;
  int comp_type;
  char tmp1[RSBAC_MAXNAMELEN],tmp2[RSBAC_MAXNAMELEN];
  enum rsbac_adf_request_t rc_right;
  int j,i;
  enum rsbac_rc_target_t target;
  union rsbac_rc_target_id_t tid;
  union rsbac_rc_target_id_t subtid;
  enum rsbac_rc_item_t item;
  union rsbac_rc_item_value_t value;
  rsbac_time_t ttl;
  char * progname = argv[0];
  int role_entry_item_list[RSBAC_RC_NR_ROLE_ENTRY_ITEMS] = RSBAC_RC_ROLE_ENTRY_ITEM_LIST;
  int type_entry_item_list[RSBAC_RC_NR_TYPE_ENTRY_ITEMS] = RSBAC_RC_TYPE_ENTRY_ITEM_LIST;
  boolean show_unused = FALSE;
  boolean show_names = FALSE;
  int verbose=0;
  int printall=0;
  int remove=0;

  locale_init();

  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose=1;
                break;
              case 'p':
                printall=1;
                break;
              case 'r':
                remove=1;
                break;
              case 'i':
                if(   (argc > 2)
                   && ((item = get_rc_item_nr(argv[2])) != RI_none)
                  )
                  {
                    get_rc_item_name(tmp1, item);
                    get_rc_item_param(tmp2, item);
                    printf("%s \t%s\n",tmp1,tmp2);
                    exit(0);
                  }
                printf(gettext("- items and returned values = see following list:\n"));
                printf("- ROLE:\n");
                for (j=0;j<RSBAC_RC_NR_ROLE_ENTRY_ITEMS;j++)
                  {
                    get_rc_item_name(tmp1,role_entry_item_list[j]);
                    get_rc_item_param(tmp2,role_entry_item_list[j]);
                    printf("%s \t%s\n",tmp1,tmp2);
                  }
                printf("- TYPE:\n");
                for (j=0;j<RSBAC_RC_NR_TYPE_ENTRY_ITEMS;j++)
                  {
                    get_rc_item_name(tmp1,type_entry_item_list[j]);
                    get_rc_item_param(tmp2,type_entry_item_list[j]);
                    printf("%s \t%s\n",tmp1,tmp2);
                  }
                exit(0);

              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  
  switch(argc)
    {
      case 2:
        if(   !strcmp(argv[1],"list_rights")
          )
          {
            char tmp[80];

            for(i=0; i<R_NONE; i++)
              printf("%s\n", get_request_name(tmp, i));
            for(i=RSBAC_RC_SPECIAL_RIGHT_BASE; i<RCR_NONE; i++)
              printf("%s\n", get_rc_special_right_name(tmp, i));
            exit(0);
          }
        if(   !strcmp(argv[1],"list_roles")
           || !strcmp(argv[1],"list_role_nr")
          )
          {
            __u32 * role_array;
            int nr_roles;

            target = RT_ROLE;
            tid.role = 0;
            item = RI_name;
            if(   !strcmp(argv[1],"list_roles")
              )
              show_names = TRUE;
            nr_roles = rsbac_rc_get_list(RT_ROLE, &tid, RI_name, 0, NULL, NULL);
            error_exit(nr_roles);
            nr_roles += LISTROOM;
            role_array = malloc(nr_roles * sizeof(__u32));
            if(!role_array)
              {
                error_exit(-ENOMEM);
              }
            nr_roles = rsbac_rc_get_list(RT_ROLE, &tid, RI_name, nr_roles, role_array, NULL);
            if(verbose)
              {
                printf(gettext("%u roles:\n"),
                       nr_roles);
              }
            for(j=0; j<nr_roles; j++)
              {
                if(show_names)
                  {
                    tid.role = role_array[j];
                    value.dummy = -1;
                    res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                    if(!res)
                      {
                        for(i=0; i<strlen(value.name); i++)
                          if(value.name[i] == ' ')
                            value.name[i] = '_';
                        printf("%i %s\n", role_array[j], value.name);
                      }
                  }
                else
                  printf("%u\n", role_array[j]);
              }
            free(role_array);
            exit(0);
          }
        if(   !strcmp(argv[1],"list_fd_types")
           || !strcmp(argv[1],"list_fd_type_nr")
           || !strcmp(argv[1],"list_dev_types")
           || !strcmp(argv[1],"list_dev_type_nr")
           || !strcmp(argv[1],"list_process_types")
           || !strcmp(argv[1],"list_process_type_nr")
           || !strcmp(argv[1],"list_ipc_types")
           || !strcmp(argv[1],"list_ipc_type_nr")
           || !strcmp(argv[1],"list_netdev_types")
           || !strcmp(argv[1],"list_netdev_type_nr")
           || !strcmp(argv[1],"list_nettemp_types")
           || !strcmp(argv[1],"list_nettemp_type_nr")
           || !strcmp(argv[1],"list_netobj_types")
           || !strcmp(argv[1],"list_netobj_type_nr")
          )
          {
            __u32 * type_array;
            int nr_types;

            if(   !strcmp(argv[1],"list_fd_types")
               || !strcmp(argv[1],"list_fd_type_nr")
              )
              item = RI_type_fd_name;
            else
            if(   !strcmp(argv[1],"list_dev_types")
               || !strcmp(argv[1],"list_dev_type_nr")
              )
              item = RI_type_dev_name;
            else
            if(   !strcmp(argv[1],"list_process_types")
               || !strcmp(argv[1],"list_process_type_nr")
              )
              item = RI_type_process_name;
            else
            if(   !strcmp(argv[1],"list_ipc_types")
               || !strcmp(argv[1],"list_ipc_type_nr")
              )
              item = RI_type_ipc_name;
            else
            if(   !strcmp(argv[1],"list_netdev_types")
               || !strcmp(argv[1],"list_netdev_type_nr")
              )
              item = RI_type_netdev_name;
            else
            if(   !strcmp(argv[1],"list_nettemp_types")
               || !strcmp(argv[1],"list_nettemp_type_nr")
              )
              item = RI_type_nettemp_name;
            else
            if(   !strcmp(argv[1],"list_netobj_types")
               || !strcmp(argv[1],"list_netobj_type_nr")
              )
              item = RI_type_netobj_name;

            if(   !strcmp(argv[1],"list_fd_types")
               || !strcmp(argv[1],"list_dev_types")
               || !strcmp(argv[1],"list_process_types")
               || !strcmp(argv[1],"list_ipc_types")
               || !strcmp(argv[1],"list_netdev_types")
               || !strcmp(argv[1],"list_nettemp_types")
               || !strcmp(argv[1],"list_netobj_types")
              )
              show_names = TRUE;

            tid.type = 0;
            nr_types = rsbac_rc_get_list(RT_TYPE, &tid, item, 0, NULL, NULL);
            error_exit(nr_types);
            type_array = malloc(nr_types * sizeof(__u32));
            if(!type_array)
              {
                error_exit(-ENOMEM);
              }
            nr_types = rsbac_rc_get_list(RT_TYPE, &tid, item, nr_types, type_array, NULL);
            if(verbose)
              {
                printf(gettext("%u types:\n"),
                       nr_types);
              }
            for(j=0; j<nr_types; j++)
              {
                if(show_names)
                  {
                    tid.type = type_array[j];
                    value.dummy = -1;
                    res = rsbac_rc_get_item(RT_TYPE, &tid, &tid, item, &value, NULL);
                    if(!res)
                      {
                        for(i=0; i<strlen(value.name); i++)
                          if(value.name[i] == ' ')
                            value.name[i] = '_';
                        printf("%i %s\n", type_array[j], value.name);
                      }
                  }
                else
                  printf("%u\n", type_array[j]);
              }
            free(type_array);
            exit(0);
          }
        if(   !strcmp(argv[1],"list_scd_types")
           || !strcmp(argv[1],"list_scd_type_nr")
          )
          {
            target = RT_TYPE;
            item = RI_type_scd_name;
            if(   !strcmp(argv[1],"list_scd_types")
               || !strcmp(argv[1],"list_scd_type_nr"))
              show_unused = TRUE;
            if(   !strcmp(argv[1],"list_scd_types")
              )
              show_names = TRUE;
            for(j=0; j<ST_none; j++)
              {
                tid.type = j;
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                error_exit(res);
                for(i=0; i<strlen(value.name); i++)
                  if(value.name[i] == ' ')
                    value.name[i] = '_';
                if(show_names)
                  printf("%i %s\n", j, value.name);
                else
                  printf("%i\n", j);
              }
            for(j=RST_min; j<RST_none; j++)
              {
                tid.type = j;
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                error_exit(res);
                for(i=0; i<strlen(value.name); i++)
                  if(value.name[i] == ' ')
                    value.name[i] = '_';
                if(show_names)
                  printf("%i %s\n", j, value.name);
                else
                  printf("%i\n", j);
              }
            exit(0);
          }
        if(   !strcmp(argv[1],"list_fd_rights")
           || !strcmp(argv[1],"list_dev_rights")
           || !strcmp(argv[1],"list_ipc_rights")
           || !strcmp(argv[1],"list_scd_rights")
           || !strcmp(argv[1],"list_user_rights")
           || !strcmp(argv[1],"list_process_rights")
           || !strcmp(argv[1],"list_netdev_rights")
           || !strcmp(argv[1],"list_nettemp_rights")
           || !strcmp(argv[1],"list_netobj_rights")
           || !strcmp(argv[1],"list_none_rights")
           || !strcmp(argv[1],"list_all_rights")
          )
          {
            rsbac_rc_rights_vector_t right_mask;

            switch(argv[1][5])
              {
                case 'f':
                  right_mask=RSBAC_FD_REQUEST_VECTOR | RSBAC_RC_SPECIAL_RIGHTS_VECTOR;
                  break;
                case 'd':
                  right_mask=RSBAC_DEV_REQUEST_VECTOR | RSBAC_RC_SPECIAL_RIGHTS_VECTOR;
                  break;
                case 'i':
                  right_mask=RSBAC_IPC_REQUEST_VECTOR | RSBAC_RC_SPECIAL_RIGHTS_VECTOR;
                  break;
                case 's':
                  right_mask=RSBAC_SCD_REQUEST_VECTOR | RSBAC_NONE_REQUEST_VECTOR | RSBAC_RC_SPECIAL_RIGHTS_VECTOR;
                  break;
                case 'u':
                  right_mask=RSBAC_USER_REQUEST_VECTOR;
                  break;
                case 'p':
                  right_mask=RSBAC_PROCESS_REQUEST_VECTOR | RSBAC_RC_SPECIAL_RIGHTS_VECTOR;
                  break;
                case 'n':
                  switch(argv[1][8])
                    {
                      case 'd':
                        right_mask=RSBAC_NETDEV_REQUEST_VECTOR | RSBAC_RC_SPECIAL_RIGHTS_VECTOR;
                        break;
                      case 't':
                        right_mask=RSBAC_NETTEMP_REQUEST_VECTOR | RSBAC_RC_SPECIAL_RIGHTS_VECTOR;
                        break;
                      case 'o':
                        right_mask=RSBAC_NETOBJ_REQUEST_VECTOR | RSBAC_RC_SPECIAL_RIGHTS_VECTOR;
                        break;
                      default:
                        right_mask=RSBAC_NONE_REQUEST_VECTOR;
                        break;
                    }
                  break;
                case 'a':
                  right_mask=RSBAC_ALL_REQUEST_VECTOR | RSBAC_RC_SPECIAL_RIGHTS_VECTOR;
                  break;
                default:
                  fprintf(stderr, gettext("%s: Internal right list error, param %s!\n"),
                          progname,
                          argv[1]);
                  exit(1);
              }
            for(j=0; j<R_NONE; j++)
              {
                if(right_mask & ((rsbac_rc_rights_vector_t) 1 << j))
                  printf("%s\n", get_request_name(tmp1,j));
              }
            for(j=RSBAC_RC_SPECIAL_RIGHT_BASE; j<RCR_NONE; j++)
              {
                if(right_mask & ((rsbac_rc_rights_vector_t) 1 << j))
                  printf("%s\n", get_rc_special_right_name(tmp1,j));
              }
            exit(0);
          }
        if(!strcmp(argv[1],"list_unused_role_nr"))
          {
            item = RI_name;
            res = 0;
            j = -1;
            while(!res)
              {
                j++;
                tid.role = j;
                res = rsbac_rc_get_item(RT_ROLE, &tid, &tid, item, &value, NULL);
              }
            if(res == -RSBAC_ENOTFOUND)
              {
                printf("%u\n", j);
                res = 0;
              }
            error_exit(res);
            exit(0);
          }
        if(   !strcmp(argv[1],"list_unused_fd_type_nr")
           || !strcmp(argv[1],"list_unused_dev_type_nr")
           || !strcmp(argv[1],"list_unused_ipc_type_nr")
           || !strcmp(argv[1],"list_unused_process_type_nr")
           || !strcmp(argv[1],"list_unused_netdev_type_nr")
           || !strcmp(argv[1],"list_unused_nettemp_type_nr")
           || !strcmp(argv[1],"list_unused_netobj_type_nr")
          )
          {
            target = RT_TYPE;
            if(!strcmp(argv[1],"list_unused_fd_type_nr"))
              item = RI_type_fd_name;
            else
            if(!strcmp(argv[1],"list_unused_dev_type_nr"))
              item = RI_type_dev_name;
            else
            if(!strcmp(argv[1],"list_unused_ipc_type_nr"))
              item = RI_type_ipc_name;
            else
            if(!strcmp(argv[1],"list_unused_process_type_nr"))
              item = RI_type_process_name;
            else
            if(!strcmp(argv[1],"list_unused_netdev_type_nr"))
              item = RI_type_netdev_name;
            else
            if(!strcmp(argv[1],"list_unused_nettemp_type_nr"))
              item = RI_type_nettemp_name;
            else
            if(!strcmp(argv[1],"list_unused_netobj_type_nr"))
              item = RI_type_netobj_name;

            res = 0;
            j = -1;
            while(!res)
              {
                j++;
                tid.type = j;
                res = rsbac_rc_get_item(RT_TYPE, &tid, &tid, item, &value, NULL);
              }
            if(res == -RSBAC_ENOTFOUND)
              {
                printf("%u\n", j);
                res = 0;
              }
            error_exit(res);
            exit(0);
          }
        if(   !strcmp(argv[1],"backup")
          )
          {
            __u32 * role_array;
            __u32 * sub_array;
            __u32 * type_array;
            rsbac_time_t * ttl_array;
            int nr_roles;
            int nr_fd_types;
            int nr_dev_types;
            int nr_ipc_types;
            int nr_process_types;
            int nr_netdev_types;
            int nr_nettemp_types;
            int nr_netobj_types;
            int sub_nr;
            int k;

            target = RT_TYPE;
            item = RI_type_fd_name;
            tid.role = 0;
            nr_fd_types = rsbac_rc_get_list(RT_TYPE, &tid, item, 0, NULL, NULL);
            error_exit(nr_fd_types);
            nr_fd_types += LISTROOM;
            type_array = malloc(nr_fd_types * sizeof(__u32));
            if(!type_array)
              {
                error_exit(-ENOMEM);
              }
            nr_fd_types = rsbac_rc_get_list(RT_TYPE, &tid, item, nr_fd_types, type_array, NULL);
            for(j=0; j<nr_fd_types; j++)
              {
                tid.type = type_array[j];
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                if(!res)
                  {
                    if(value.name[0])
                      {
                        printf("%s -V %u TYPE %u type_fd_name \"%s\"\n",
                               SETPROG, RSBAC_VERSION_NR,
                               type_array[j],
                               value.name);
                      }
                  }
                res = rsbac_rc_get_item(target, &tid, &tid, RI_type_fd_need_secdel, &value, NULL);
                if(!res)
                  {
                    if(value.need_secdel)
                      {
                        printf("%s -V %u TYPE %u type_fd_need_secdel %u\n",
                               SETPROG, RSBAC_VERSION_NR,
                               type_array[j],
                               value.need_secdel);
                      }
                  }
              }
            free(type_array);

            item = RI_type_dev_name;
            tid.role = 0;
            nr_dev_types = rsbac_rc_get_list(RT_TYPE, &tid, item, 0, NULL, NULL);
            error_exit(nr_dev_types);
            nr_dev_types += LISTROOM;
            type_array = malloc(nr_dev_types * sizeof(__u32));
            if(!type_array)
              {
                error_exit(-ENOMEM);
              }
            nr_dev_types = rsbac_rc_get_list(RT_TYPE, &tid, item, nr_dev_types, type_array, NULL);
            for(j=0; j<nr_dev_types; j++)
              {
                tid.type = type_array[j];
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                if(!res)
                  {
                    if(value.name[0])
                      {
                        printf("%s -V %u TYPE %u type_dev_name \"%s\"\n",
                               SETPROG, RSBAC_VERSION_NR,
                               type_array[j],
                               value.name);
                      }
                  }
              }
            free(type_array);

            item = RI_type_ipc_name;
            tid.role = 0;
            nr_ipc_types = rsbac_rc_get_list(RT_TYPE, &tid, item, 0, NULL, NULL);
            error_exit(nr_ipc_types);
            nr_ipc_types += LISTROOM;
            type_array = malloc(nr_ipc_types * sizeof(__u32));
            if(!type_array)
              {
                error_exit(-ENOMEM);
              }
            nr_ipc_types = rsbac_rc_get_list(RT_TYPE, &tid, item, nr_ipc_types, type_array, NULL);
            for(j=0; j<nr_ipc_types; j++)
              {
                tid.type = type_array[j];
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                if(!res)
                  {
                    if(value.name[0])
                      {
                        printf("%s -V %u TYPE %u type_ipc_name \"%s\"\n",
                               SETPROG, RSBAC_VERSION_NR,
                               type_array[j],
                               value.name);
                      }
                  }
              }
            free(type_array);

            item = RI_type_process_name;
            tid.role = 0;
            nr_process_types = rsbac_rc_get_list(RT_TYPE, &tid, item, 0, NULL, NULL);
            error_exit(nr_process_types);
            nr_process_types += LISTROOM;
            type_array = malloc(nr_process_types * sizeof(__u32));
            if(!type_array)
              {
                error_exit(-ENOMEM);
              }
            nr_process_types = rsbac_rc_get_list(RT_TYPE, &tid, item, nr_process_types, type_array, NULL);
            for(j=0; j<nr_process_types; j++)
              {
                tid.type = type_array[j];
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                if(!res)
                  {
                    if(value.name[0])
                      {
                        printf("%s -V %u TYPE %u type_process_name \"%s\"\n",
                               SETPROG, RSBAC_VERSION_NR,
                               type_array[j],
                               value.name);
                      }
                  }
              }
            free(type_array);

            item = RI_type_netdev_name;
            tid.role = 0;
            nr_netdev_types = rsbac_rc_get_list(RT_TYPE, &tid, item, 0, NULL, NULL);
            error_exit(nr_netdev_types);
            nr_netdev_types += LISTROOM;
            type_array = malloc(nr_netdev_types * sizeof(__u32));
            if(!type_array)
              {
                error_exit(-ENOMEM);
              }
            nr_netdev_types = rsbac_rc_get_list(RT_TYPE, &tid, item, nr_netdev_types, type_array, NULL);
            for(j=0; j<nr_netdev_types; j++)
              {
                tid.type = type_array[j];
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                if(!res)
                  {
                    if(value.name[0])
                      {
                        printf("%s -V %u TYPE %u type_netdev_name \"%s\"\n",
                               SETPROG, RSBAC_VERSION_NR,
                               type_array[j],
                               value.name);
                      }
                  }
              }
            free(type_array);

            item = RI_type_nettemp_name;
            tid.role = 0;
            nr_nettemp_types = rsbac_rc_get_list(RT_TYPE, &tid, item, 0, NULL, NULL);
            error_exit(nr_nettemp_types);
            nr_nettemp_types += LISTROOM;
            type_array = malloc(nr_nettemp_types * sizeof(__u32));
            if(!type_array)
              {
                error_exit(-ENOMEM);
              }
            nr_nettemp_types = rsbac_rc_get_list(RT_TYPE, &tid, item, nr_nettemp_types, type_array, NULL);
            for(j=0; j<nr_nettemp_types; j++)
              {
                tid.type = type_array[j];
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                if(!res)
                  {
                    if(value.name[0])
                      {
                        printf("%s -V %u TYPE %u type_nettemp_name \"%s\"\n",
                               SETPROG, RSBAC_VERSION_NR,
                               type_array[j],
                               value.name);
                      }
                  }
              }
            free(type_array);

            item = RI_type_netobj_name;
            tid.role = 0;
            nr_netobj_types = rsbac_rc_get_list(RT_TYPE, &tid, item, 0, NULL, NULL);
            error_exit(nr_netobj_types);
            nr_netobj_types += LISTROOM;
            type_array = malloc(nr_netobj_types * sizeof(__u32));
            if(!type_array)
              {
                error_exit(-ENOMEM);
              }
            nr_netobj_types = rsbac_rc_get_list(RT_TYPE, &tid, item, nr_netobj_types, type_array, NULL);
            for(j=0; j<nr_netobj_types; j++)
              {
                tid.type = type_array[j];
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, item, &value, NULL);
                if(!res)
                  {
                    if(value.name[0])
                      {
                        printf("%s -V %u TYPE %u type_netobj_name \"%s\"\n",
                               SETPROG, RSBAC_VERSION_NR,
                               type_array[j],
                               value.name);
                      }
                  }
              }
            free(type_array);


            target = RT_ROLE;
            item = RI_name;
            tid.role = 0;
            nr_roles = rsbac_rc_get_list(RT_ROLE, &tid, RI_name, 0, NULL, NULL);
            error_exit(nr_roles);
            role_array = malloc(nr_roles * sizeof(__u32));
            if(!role_array)
              {
                error_exit(-ENOMEM);
              }
            nr_roles = rsbac_rc_get_list(RT_ROLE, &tid, RI_name, nr_roles, role_array, NULL);
            for(j=0; j<nr_roles; j++)
              {
                rsbac_time_t now = time(NULL);

                tid.role = role_array[j];
                value.dummy = -1;
                res = rsbac_rc_get_item(target, &tid, &tid, RI_name, &value, NULL);
                if(!res)
                  {
                    if(value.name[0])
                      {
                        if(remove)
                          printf("%s -V %u ROLE %u remove_role\n",
                                 SETPROG, RSBAC_VERSION_NR,
                                 role_array[j]);
                        printf("%s -V %u ROLE %u name \"%s\"\n",
                               SETPROG, RSBAC_VERSION_NR,
                               role_array[j],
                               value.name);
                        /* get role_comp number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_role_comp, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_role_comp, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    if(ttl_array[i])
                                      printf("%s -V %u -T %u ROLE %u role_comp %u 1\n",
                                             SETPROG, RSBAC_VERSION_NR,
                                             now + ttl_array[i],
                                             role_array[j],
                                             sub_array[i]);
                                    else
                                      printf("%s -V %u ROLE %u role_comp %u 1\n",
                                             SETPROG, RSBAC_VERSION_NR,
                                             role_array[j],
                                             sub_array[i]);
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get admin_roles number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_admin_roles, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_admin_roles, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    if(ttl_array[i])
                                      printf("%s -V %u -T %u ROLE %u admin_roles %u 1\n",
                                             SETPROG, RSBAC_VERSION_NR,
                                             now + ttl_array[i],
                                             role_array[j],
                                             sub_array[i]);
                                    else
                                      printf("%s -V %u ROLE %u admin_roles %u 1\n",
                                             SETPROG, RSBAC_VERSION_NR,
                                             role_array[j],
                                             sub_array[i]);
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get assign_roles number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_assign_roles, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_assign_roles, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    if(ttl_array[i])
                                      printf("%s -V %u -T %u ROLE %u assign_roles %u 1\n",
                                             SETPROG, RSBAC_VERSION_NR,
                                             now + ttl_array[i],
                                             role_array[j],
                                             sub_array[i]);
                                    else
                                      printf("%s -V %u ROLE %u assign_roles %u 1\n",
                                           SETPROG, RSBAC_VERSION_NR,
                                           role_array[j],
                                           sub_array[i]);
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get type_comp_fd number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_fd, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_fd, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    subtid.type = sub_array[i];
                                    res = rsbac_rc_get_item(target, &tid, &subtid, RI_type_comp_fd, &value, NULL);
                                    if(!res)
                                      {
                                        if(   (   (role_array[j] < 3)
                                               && (sub_array[i] < 3)
                                              )
                                           || (   value.rights
                                              && (role_array[j] != RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                           || (   (value.rights != RSBAC_RC_SPECIAL_RIGHTS_VECTOR)
                                               && (role_array[j] == RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                          )
                                          if(printall)
                                            {
                                              if(ttl_array[i])
                                                printf("%s -V %u -T %u ROLE %u type_comp_fd %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       now + ttl_array[i],
                                                       role_array[j],
                                                       sub_array[i]);
                                              else
                                                printf("%s -V %u ROLE %u type_comp_fd %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       role_array[j],
                                                       sub_array[i]);
                                              for (k=0; k<R_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_request_name(tmp1,k));
                                              for (k=RSBAC_RC_SPECIAL_RIGHT_BASE; k<RCR_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_rc_special_right_name(tmp1,k));
                                              printf("\n");
                                            }
                                          else
                                            if(ttl_array[i])
                                              printf("%s -V %u -bT %u ROLE %u type_comp_fd %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     now + ttl_array[i],
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                            else
                                              printf("%s -V %u -b ROLE %u type_comp_fd %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                      }
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get type_comp_dev number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_dev, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_dev, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    subtid.type = sub_array[i];
                                    res = rsbac_rc_get_item(target, &tid, &subtid, RI_type_comp_dev, &value, NULL);
                                    if(!res)
                                      {
                                        if(   (   (role_array[j] < 3)
                                               && (sub_array[i] < 3)
                                              )
                                           || (   value.rights
                                              && (role_array[j] != RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                           || (   (value.rights != RSBAC_RC_SPECIAL_RIGHTS_VECTOR)
                                               && (role_array[j] == RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                          )
                                          if(printall)
                                            {
                                              if(ttl_array[i])
                                                printf("%s -V %u -T %u ROLE %u type_comp_dev %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       now + ttl_array[i],
                                                       role_array[j],
                                                       sub_array[i]);
                                              else
                                                printf("%s -V %u ROLE %u type_comp_dev %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       role_array[j],
                                                       sub_array[i]);
                                              for (k=0; k<R_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_request_name(tmp1,k));
                                              for (k=RSBAC_RC_SPECIAL_RIGHT_BASE; k<RCR_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_rc_special_right_name(tmp1,k));
                                              printf("\n");
                                            }
                                          else
                                            if(ttl_array[i])
                                              printf("%s -V %u -bT %u ROLE %u type_comp_dev %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     now + ttl_array[i],
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                            else
                                              printf("%s -V %u -b ROLE %u type_comp_dev %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                      }
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get type_comp_ipc number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_ipc, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_ipc, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    subtid.type = sub_array[i];
                                    res = rsbac_rc_get_item(target, &tid, &subtid, RI_type_comp_ipc, &value, NULL);
                                    if(!res)
                                      {
                                        if(   (   (role_array[j] < 3)
                                               && (sub_array[i] < 3)
                                              )
                                           || (   value.rights
                                              && (role_array[j] != RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                           || (   (value.rights != RSBAC_RC_SPECIAL_RIGHTS_VECTOR)
                                               && (role_array[j] == RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                          )
                                          if(printall)
                                            {
                                              if(ttl_array[i])
                                                printf("%s -V %u -T %u ROLE %u type_comp_ipc %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       now + ttl_array[i],
                                                       role_array[j],
                                                       sub_array[i]);
                                              else
                                                printf("%s -V %u ROLE %u type_comp_ipc %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       role_array[j],
                                                       sub_array[i]);
                                              for (k=0; k<R_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_request_name(tmp1,k));
                                              for (k=RSBAC_RC_SPECIAL_RIGHT_BASE; k<RCR_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_rc_special_right_name(tmp1,k));
                                              printf("\n");
                                            }
                                          else
                                            if(ttl_array[i])
                                              printf("%s -V %u -bT %u ROLE %u type_comp_ipc %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     now + ttl_array[i],
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                            else
                                              printf("%s -V %u -b ROLE %u type_comp_ipc %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                      }
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get type_comp_scd number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_scd, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_scd, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    subtid.type = sub_array[i];
                                    res = rsbac_rc_get_item(target, &tid, &subtid, RI_type_comp_scd, &value, NULL);
                                    if(!res)
                                      {
                                        if(   (   (role_array[j] < 3)
                                               && (sub_array[i] < 3)
                                              )
                                           || (   value.rights
                                              && (role_array[j] != RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                           || (   (value.rights != RSBAC_RC_SPECIAL_RIGHTS_VECTOR)
                                               && (role_array[j] == RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                          )
                                          if(printall)
                                            {
                                              if(ttl_array[i])
                                                printf("%s -V %u -T %u ROLE %u type_comp_scd %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       now + ttl_array[i],
                                                       role_array[j],
                                                       sub_array[i]);
                                              else
                                                printf("%s -V %u ROLE %u type_comp_scd %u",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     role_array[j],
                                                     sub_array[i]);
                                              for (k=0; k<R_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_request_name(tmp1,k));
                                              for (k=RSBAC_RC_SPECIAL_RIGHT_BASE; k<RCR_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_rc_special_right_name(tmp1,k));
                                              printf("\n");
                                            }
                                          else
                                            if(ttl_array[i])
                                              printf("%s -V %u -bT %u ROLE %u type_comp_scd %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     now + ttl_array[i],
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                            else
                                              printf("%s -V %u -b ROLE %u type_comp_scd %u %s\n",
                                                 SETPROG, RSBAC_VERSION_NR,
                                                 role_array[j],
                                                 sub_array[i],
                                                 u64tostrrcr(tmp1,value.rights));
                                      }
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get type_comp_process number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_process, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_process, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    subtid.type = sub_array[i];
                                    res = rsbac_rc_get_item(target, &tid, &subtid, RI_type_comp_process, &value, NULL);
                                    if(!res)
                                      {
                                        if(   (   (role_array[j] < 3)
                                               && (sub_array[i] < 3)
                                              )
                                           || (   value.rights
                                              && (role_array[j] != RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                           || (   (value.rights != RSBAC_RC_SPECIAL_RIGHTS_VECTOR)
                                               && (role_array[j] == RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                          )
                                          if(printall)
                                            {
                                              if(ttl_array[i])
                                                printf("%s -V %u -T %u ROLE %u type_comp_process %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       now + ttl_array[i],
                                                       role_array[j],
                                                       sub_array[i]);
                                              else
                                                printf("%s -V %u ROLE %u type_comp_process %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       role_array[j],
                                                       sub_array[i]);
                                              for (k=0; k<R_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_request_name(tmp1,k));
                                              for (k=RSBAC_RC_SPECIAL_RIGHT_BASE; k<RCR_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_rc_special_right_name(tmp1,k));
                                              printf("\n");
                                            }
                                          else
                                            if(ttl_array[i])
                                              printf("%s -V %u -bT %u ROLE %u type_comp_process %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     now + ttl_array[i],
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                            else
                                              printf("%s -V %u -b ROLE %u type_comp_process %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                      }
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get type_comp_netdev number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_netdev, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_netdev, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    subtid.type = sub_array[i];
                                    res = rsbac_rc_get_item(target, &tid, &subtid, RI_type_comp_netdev, &value, NULL);
                                    if(!res)
                                      {
                                        if(   (   (role_array[j] < 3)
                                               && (sub_array[i] < 3)
                                              )
                                           || (   value.rights
                                              && (role_array[j] != RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                           || (   (value.rights != RSBAC_RC_SPECIAL_RIGHTS_VECTOR)
                                               && (role_array[j] == RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                          )
                                          if(printall)
                                            {
                                              if(ttl_array[i])
                                                printf("%s -V %u -T %u ROLE %u type_comp_netdev %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       now + ttl_array[i],
                                                       role_array[j],
                                                       sub_array[i]);
                                              else
                                                printf("%s -V %u ROLE %u type_comp_netdev %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       role_array[j],
                                                       sub_array[i]);
                                              for (k=0; k<R_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_request_name(tmp1,k));
                                              for (k=RSBAC_RC_SPECIAL_RIGHT_BASE; k<RCR_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_rc_special_right_name(tmp1,k));
                                              printf("\n");
                                            }
                                          else
                                            if(ttl_array[i])
                                              printf("%s -V %u -bT %u ROLE %u type_comp_netdev %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     now + ttl_array[i],
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                            else
                                              printf("%s -V %u -b ROLE %u type_comp_netdev %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                      }
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get type_comp_nettemp number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_nettemp, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_nettemp, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    subtid.type = sub_array[i];
                                    res = rsbac_rc_get_item(target, &tid, &subtid, RI_type_comp_nettemp, &value, NULL);
                                    if(!res)
                                      {
                                        if(   (   (role_array[j] < 3)
                                               && (sub_array[i] < 3)
                                              )
                                           || (   value.rights
                                              && (role_array[j] != RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                           || (   (value.rights != RSBAC_RC_SPECIAL_RIGHTS_VECTOR)
                                               && (role_array[j] == RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                          )
                                          if(printall)
                                            {
                                              if(ttl_array[i])
                                                printf("%s -V %u -T %u ROLE %u type_comp_nettemp %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       now + ttl_array[i],
                                                       role_array[j],
                                                       sub_array[i]);
                                              else
                                                printf("%s -V %u ROLE %u type_comp_nettemp %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       role_array[j],
                                                       sub_array[i]);
                                              for (k=0; k<R_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_request_name(tmp1,k));
                                              for (k=RSBAC_RC_SPECIAL_RIGHT_BASE; k<RCR_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_rc_special_right_name(tmp1,k));
                                              printf("\n");
                                            }
                                          else
                                            if(ttl_array[i])
                                              printf("%s -V %u -bT %u ROLE %u type_comp_nettemp %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     now + ttl_array[i],
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                            else
                                              printf("%s -V %u -b ROLE %u type_comp_nettemp %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                      }
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        /* get type_comp_netobj number */
                        sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_netobj, 0, NULL, NULL);
                        if(sub_nr >= 0)
                          {
                            /* alloc with some extra room */
                            sub_nr += LISTROOM;
                            sub_array = malloc(sub_nr * sizeof(__u32));
                            if(!sub_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            ttl_array = malloc(sub_nr * sizeof(*ttl_array));
                            if(!ttl_array)
                              {
                                error_exit(-ENOMEM);
                              }
                            /* get values */
                            sub_nr = rsbac_rc_get_list(RT_ROLE, &tid, RI_type_comp_netobj, sub_nr, sub_array, ttl_array);
                            if(sub_nr > 0)
                              {
                                for (i=0; i<sub_nr; i++)
                                  {
                                    subtid.type = sub_array[i];
                                    res = rsbac_rc_get_item(target, &tid, &subtid, RI_type_comp_netobj, &value, NULL);
                                    if(!res)
                                      {
                                        if(   (   (role_array[j] < 3)
                                               && (sub_array[i] < 3)
                                              )
                                           || (   value.rights
                                              && (role_array[j] != RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                           || (   (value.rights != RSBAC_RC_SPECIAL_RIGHTS_VECTOR)
                                               && (role_array[j] == RSBAC_RC_ROLE_ADMIN_ROLE)
                                              )
                                          )
                                          if(printall)
                                            {
                                              if(ttl_array[i])
                                                printf("%s -V %u -T %u ROLE %u type_comp_netobj %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       now + ttl_array[i],
                                                       role_array[j],
                                                       sub_array[i]);
                                              else
                                                printf("%s -V %u ROLE %u type_comp_netobj %u",
                                                       SETPROG, RSBAC_VERSION_NR,
                                                       role_array[j],
                                                       sub_array[i]);
                                              for (k=0; k<R_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_request_name(tmp1,k));
                                              for (k=RSBAC_RC_SPECIAL_RIGHT_BASE; k<RCR_NONE; k++)
                                                if(value.rights & RSBAC_RC_RIGHTS_VECTOR(k))
                                                  printf(" %s", get_rc_special_right_name(tmp1,k));
                                              printf("\n");
                                            }
                                          else
                                            if(ttl_array[i])
                                              printf("%s -V %u -bT %u ROLE %u type_comp_netobj %u %s\n",
                                                     SETPROG, RSBAC_VERSION_NR,
                                                     now + ttl_array[i],
                                                     role_array[j],
                                                     sub_array[i],
                                                     u64tostrrcr(tmp1,value.rights));
                                            else
                                              printf("%s -V %u -b ROLE %u type_comp_netobj %u %s\n",
                                                 SETPROG, RSBAC_VERSION_NR,
                                                 role_array[j],
                                                 sub_array[i],
                                                 u64tostrrcr(tmp1,value.rights));
                                      }
                                  }
                              }
                            free(sub_array);
                          }
                        else
                          show_error(sub_nr);

                        res = rsbac_rc_get_item(target, &tid, &tid, RI_admin_type, &value, NULL);
                        if(!res)
                          {
                            if(   (role_array[j]<3)
                               || value.admin_type
                              )
                              printf("%s -V %u ROLE %u admin_type %u\n",
                                     SETPROG, RSBAC_VERSION_NR,
                                     role_array[j],
                                     value.admin_type);
                          }
                        else
                          show_error(res);
                        res = rsbac_rc_get_item(target, &tid, &tid, RI_def_fd_create_type, &value, NULL);
                        if(!res)
                          {
                            printf("%s -V %u ROLE %u def_fd_create_type %u\n",
                                   SETPROG, RSBAC_VERSION_NR,
                                   role_array[j],
                                   value.type_id);
                          }
                        else
                          show_error(res);
                        res = rsbac_rc_get_item(target, &tid, &tid, RI_def_process_create_type, &value, NULL);
                        if(!res)
                          {
                            printf("%s -V %u ROLE %u def_process_create_type %u\n",
                                   SETPROG, RSBAC_VERSION_NR,
                                   role_array[j],
                                   value.type_id);
                          }
                        else
                          show_error(res);
                        res = rsbac_rc_get_item(target, &tid, &tid, RI_def_process_chown_type, &value, NULL);
                        if(!res)
                          {
                            printf("%s -V %u ROLE %u def_process_chown_type %u\n",
                                   SETPROG, RSBAC_VERSION_NR,
                                   role_array[j],
                                   value.type_id);
                          }
                        else
                          show_error(res);
                        res = rsbac_rc_get_item(target, &tid, &tid, RI_def_process_execute_type, &value, NULL);
                        if(!res)
                          {
                            printf("%s -V %u ROLE %u def_process_execute_type %u\n",
                                   SETPROG, RSBAC_VERSION_NR,
                                   role_array[j],
                                   value.type_id);
                          }
                        else
                          show_error(res);
                        res = rsbac_rc_get_item(target, &tid, &tid, RI_def_ipc_create_type, &value, NULL);
                        if(!res)
                          {
                            printf("%s -V %u ROLE %u def_ipc_create_type %u\n",
                                   SETPROG, RSBAC_VERSION_NR,
                                   role_array[j],
                                   value.type_id);
                          }
                        else
                          show_error(res);
                      }
                  }
                else
                  break;
              }

            exit(0);
          }
        fprintf(stderr, gettext("Invalid parameter %s\n"), argv[1]);
        exit(1);
        break;

      case 4:
        target = get_rc_target_nr(argv[1]);
        switch(target)
          {
            case RT_ROLE:
              tid.role = strtol(argv[2],0,10);
              break;
            case RT_TYPE:
              tid.type = strtol(argv[2],0,10);
              break;
            default:
              fprintf(stderr, gettext("Invalid target %s\n"), argv[1]);
              exit(1);
           }
        if(   !strcmp(argv[3],"list_role_comp")
           || !strcmp(argv[3],"list_role_comp_nr")
           || !strcmp(argv[3],"list_admin_roles")
           || !strcmp(argv[3],"list_admin_role_nr")
           || !strcmp(argv[3],"list_assign_roles")
           || !strcmp(argv[3],"list_assign_role_nr")
          )
          {
            __u32 * role_array;
            rsbac_time_t * ttl_array;
            int nr_roles;

            if(   !strcmp(argv[3],"list_role_comp")
               || !strcmp(argv[3],"list_role_comp_nr")
              )
              item = RI_role_comp;
            else
            if(   !strcmp(argv[3],"list_admin_roles")
               || !strcmp(argv[3],"list_admin_role_nr")
              )
              item = RI_admin_roles;
            else
            if(   !strcmp(argv[3],"list_assign_roles")
               || !strcmp(argv[3],"list_assign_role_nr")
              )
              item = RI_assign_roles;

            if(   !strcmp(argv[3],"list_role_comp")
               || !strcmp(argv[3],"list_admin_roles")
               || !strcmp(argv[3],"list_assign_roles")
              )
              show_names = TRUE;

            nr_roles = rsbac_rc_get_list(RT_ROLE, &tid, item, 0, NULL, NULL);
            error_exit(nr_roles);
            nr_roles += LISTROOM;
            role_array = malloc(nr_roles * sizeof(__u32));
            if(!role_array)
              {
                error_exit(-ENOMEM);
              }
            ttl_array = malloc(nr_roles * sizeof(*ttl_array));
            if(!ttl_array)
              {
                error_exit(-ENOMEM);
              }
            nr_roles = rsbac_rc_get_list(RT_ROLE, &tid, item, nr_roles, role_array, ttl_array);
            if(verbose)
              {
                printf(gettext("%u roles:\n"),
                       nr_roles);
              }
            for(j=0; j<nr_roles; j++)
              {
                if(show_names)
                  {
                    tid.role = role_array[j];
                    value.dummy = -1;
                    res = rsbac_rc_get_item(RT_ROLE, &tid, &tid, RI_name, &value, NULL);
                    if(!res)
                      {
                        for(i=0; i<strlen(value.name); i++)
                          if(value.name[i] == ' ')
                            value.name[i] = '_';
                        if(ttl_array[j])
                          printf("%u(ttl:%us) %s\n", role_array[j], ttl_array[j], value.name);
                        else
                          printf("%u %s\n", role_array[j], value.name);
                      }
                  }
                else
                  {
                    if(ttl_array[j])
                      printf("%u(ttl:%us)\n", role_array[j], ttl_array[j]);
                    else
                      printf("%u\n", role_array[j]);
                  }
              }
            free(role_array);
            exit(0);
          }
        item = get_rc_item_nr(argv[3]);
        switch (item)
          {
            case RI_name:
            case RI_type_fd_name:
            case RI_type_fd_need_secdel:
            case RI_type_dev_name:
            case RI_type_ipc_name:
            case RI_type_process_name:
            case RI_type_netdev_name:
            case RI_type_nettemp_name:
            case RI_type_netobj_name:
            case RI_type_scd_name:
            case RI_admin_type:
            case RI_def_fd_create_type:
            case RI_def_process_create_type:
            case RI_def_process_chown_type:
            case RI_def_process_execute_type:
            case RI_def_ipc_create_type:
              break;
            default:
              fprintf(stderr, gettext("Invalid item %s or too few arguments\n"), argv[3]);
              exit(1);
          }
        value.dummy = -1;
        res = rsbac_rc_get_item(target, &tid, &tid, item, &value, &ttl);
        error_exit(res);
        switch (item)
          {
            case RI_name:
            case RI_type_fd_name:
            case RI_type_dev_name:
            case RI_type_ipc_name:
            case RI_type_process_name:
            case RI_type_netdev_name:
            case RI_type_nettemp_name:
            case RI_type_netobj_name:
            case RI_type_scd_name:
              printf("%s\n",value.name);
              break;
            case RI_admin_type:
              printf("%u\n",value.admin_type);
              break;
            default:
              printf("%u\n",value.type_id);
          }
        exit(0);
        break;

      case 5:
        target = get_rc_target_nr(argv[1]);
        switch(target)
          {
            case RT_ROLE:
              tid.role = strtol(argv[2],0,10);
              break;
            case RT_TYPE:
              tid.type = strtol(argv[2],0,10);
              break;
            default:
              fprintf(stderr, gettext("Invalid target %s\n"), argv[1]);
              exit(1);
           }
        item = get_rc_item_nr(argv[3]);
        switch (item)
          {
            case RI_role_comp:
            case RI_admin_roles:
            case RI_assign_roles:
            case RI_type_comp_fd:
            case RI_type_comp_dev:
            case RI_type_comp_process:
            case RI_type_comp_ipc:
            case RI_type_comp_scd:
            case RI_type_comp_netdev:
            case RI_type_comp_nettemp:
            case RI_type_comp_netobj:
              break;
            default:
              fprintf(stderr, gettext("Invalid item %s or invalid number of arguments\n"), argv[3]);
              exit(1);
          }
        if(target == RT_ROLE)
          {
            subtid.role = strtol(argv[4],0,10);
            if(subtid.role > RC_role_max_value)
              {
                fprintf(stderr, gettext("Invalid subrole %s\n"), argv[4]);
                exit(1);
              }
          }
        else
          {
            subtid.type = strtol(argv[4],0,10);
            if(subtid.type > RC_type_max_value)
              {
                fprintf(stderr, gettext("Invalid subtype %s\n"), argv[4]);
                exit(1);
              }
          }
        value.dummy = -1;
        res = rsbac_rc_get_item(target, &tid, &subtid, item, &value, &ttl);
        error_exit(res);
        switch (item)
          {
            case RI_role_comp:
            case RI_admin_roles:
            case RI_assign_roles:
              if(verbose)
                {
                  printf(gettext("Getting %s for ROLE %u to ROLE %u\n"),
                         get_rc_item_name(tmp1, item), tid.role, subtid.role);
                }
              if(ttl)
                printf("%u (ttl: %us)\n", value.comp, ttl);
              else
                printf("%u\n", value.comp);
              break;
            case RI_type_comp_fd:
            case RI_type_comp_dev:
            case RI_type_comp_process:
            case RI_type_comp_ipc:
            case RI_type_comp_scd:
            case RI_type_comp_netdev:
            case RI_type_comp_nettemp:
            case RI_type_comp_netobj:
              if(verbose)
                {
                  printf(gettext("Getting %s rights for ROLE %u to TYPE %u\n"),
                         get_rc_item_name(tmp1, item), tid.role, subtid.type);
                }
              if(ttl)
                printf("%s (ttl: %us)\n",u64tostrrcr(tmp1,value.rights), ttl);
              else
                printf("%s\n",u64tostrrcr(tmp1,value.rights));
              if(printall)
                {
                  for (i=0; i<R_NONE; i++)
                    if(value.rights & RSBAC_RC_RIGHTS_VECTOR(i))
                      printf("  %s\n", get_request_name(tmp1,i));
                  for (i=RSBAC_RC_SPECIAL_RIGHT_BASE; i<RCR_NONE; i++)
                    if(value.rights & RSBAC_RC_RIGHTS_VECTOR(i))
                      printf("  %s\n", get_rc_special_right_name(tmp1,i));
                }
              break;

            default:
              printf("%u\n",value.type_id);
          }
        exit(0);
        break;

      case 6:
        target = get_rc_target_nr(argv[1]);
        switch(target)
          {
            case RT_ROLE:
              tid.role = strtol(argv[2],0,10);
              break;
            case RT_TYPE:
              tid.type = strtol(argv[2],0,10);
              break;
            default:
              fprintf(stderr, gettext("Invalid target %s\n"), argv[1]);
              exit(1);
          }
        item = get_rc_item_nr(argv[3]);
        switch (item)
          {
            case RI_type_comp_fd:
            case RI_type_comp_dev:
            case RI_type_comp_process:
            case RI_type_comp_ipc:
            case RI_type_comp_scd:
            case RI_type_comp_netdev:
            case RI_type_comp_nettemp:
            case RI_type_comp_netobj:
              break;
            default:
              fprintf(stderr, gettext("Invalid item-position combination %s\n"), argv[3]);
              exit(1);
          }
        subtid.type = strtol(argv[4],0,10);
        if(   (subtid.type < 0)
           || (subtid.type > RC_type_max_value)
          )
          {
            fprintf(stderr, gettext("Invalid comp_type %s\n"), argv[4]);
            exit(1);
          }
        rc_right = get_rc_special_right_nr(argv[5]);
        if(   (rc_right == R_NONE)
           || (rc_right == RCR_NONE)
          )
          {
            rc_right = strtol(argv[5],0,10);
            if(   (rc_right >= RCR_NONE)
               || (   (rc_right == 0)
                   && strcmp(argv[5],"0")
                  )
              )
              {
                fprintf(stderr, gettext("Invalid right %s\n"), argv[4]);
                exit(1);
              }
          }

        value.dummy = -1;
        res = rsbac_rc_get_item(target, &tid, &subtid, item, &value, &ttl);
        error_exit(res);
        switch (item)
          {
            case RI_type_comp_fd:
            case RI_type_comp_dev:
            case RI_type_comp_process:
            case RI_type_comp_ipc:
            case RI_type_comp_scd:
            case RI_type_comp_netdev:
            case RI_type_comp_nettemp:
            case RI_type_comp_netobj:
              if(ttl)
                {
                  if(value.rights & RSBAC_RC_RIGHTS_VECTOR(rc_right))
                    printf("1 (ttl: %us)\n", ttl);
                  else
                    printf("0 (ttl: %us)\n", ttl);
                }
              else
                {
                  if(value.rights & RSBAC_RC_RIGHTS_VECTOR(rc_right))
                    printf("1\n");
                  else
                    printf("0\n");
                }
              break;
            default:
              printf("ERROR!");
              exit(1);
          }
        exit(0);
        break;

      default:
        printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
        printf(gettext("Use: %s [switches] rc-target-type id-nr item [sub-id-nr [right]]\n"), progname);  
        printf(gettext("     %s list_xxx\n"), progname);  
        printf(gettext("     %s list_unused_xxx  (_nr only)\n"), progname);  
        printf(gettext("     %s backup\n"), progname);  
        printf(gettext("- -v = verbose, -p = print right names,\n"));
        printf(gettext("- -i = list items and values,\n"));
        printf(gettext("- -r = remove role before restore (backup only)\n"));
        printf(gettext("- rc-target-type = ROLE or TYPE,\n"));
        printf(gettext("- id-nr = ROLE or TYPE number,\n"));
        printf(gettext("- item = entry line,\n"));
        printf(gettext("- sub-id-nr = use this sub-id (_comp items only),\n"));
        printf(gettext("- right = right name or number (type_comp items only),\n"));
        printf(gettext("- xxx = roles, fd_types, dev_types, ipc_types, process_types, scd_types,\n"));
        printf(gettext("-       role_nr, fd_type_nr, dev_type_nr, ipc_type_nr, process_type_nr,\n"));
        printf(gettext("-       scd_type_nr, rights: print a list\n"));
    }
  exit(1);
}
