#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/kdev_t.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  char * progname;

  locale_init();

  progname = argv[0];
  if (argc == 2)
    {
      res = rsbac_init(argv[1]);
      error_exit(res);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s root_dev\n\n"), progname);
      printf(gettext("root_dev: root device to initialize from, e.g. /dev/sda1\n"));
    }
  return 0;
}
