/*
 * jail_getname.c: Getname functions for JAIL module
 *
 * Author and Copyright (C) 1999-2005 Amon Ott (ao@rsbac.org)
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License as
 *      published by the Free Software Foundation, version 2.
 *
 * Last modified 27/05/2005.
 */

#include <rsbac/getname.h>
#include <rsbac/jail_getname.h>
#include <rsbac/helpers.h>
#include <rsbac/error.h>

#ifdef __KERNEL__
#include <linux/string.h>
#include <linux/sched.h>
#include <rsbac/debug.h>
#include <rsbac/aci.h>
#include <rsbac/rkmem.h>
#else
#include <string.h>
#endif

#ifdef __KERNEL__
#ifdef CONFIG_RSBAC_JAIL_LOG_MISSING
void rsbac_jail_log_missing_cap(int cap)
{
	char *tmp;
	union rsbac_target_id_t i_tid;
	union rsbac_attribute_value_t i_attr_val1;

	i_tid.process = current->pid;
	if (rsbac_get_attr(JAIL,
			   T_PROCESS,
			   i_tid, A_jail_max_caps, &i_attr_val1, FALSE)) {
		rsbac_ds_get_error("rsbac_jail_log_missing_cap()",
				   A_jail_max_caps);
	} else {
		if (!(i_attr_val1.jail_max_caps & (1 << cap))) {
			tmp = rsbac_kmalloc(RSBAC_MAXNAMELEN);
			if (tmp) {
				get_cap_name(tmp, cap);
				rsbac_pr_debug(aef, "capable(): pid %u(%.15s), "
					       "uid %u: missing jail_max_cap %s!\n",
					       current->pid, current->comm,
					       current->uid, tmp);
				rsbac_kfree(tmp);
			}
		}
	}
}
#endif
#endif
