/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2005: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 31/May/2005                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

char * progname;
int verbose = 0;
rsbac_list_ta_number_t ta_number = 0;

void use(void)
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [flags] group [group2 ...]\n"), progname);
      printf(gettext(" -v = verbose,\n"));
      printf(gettext(" -N ta = transaction number (default = value of RSBAC_TA, if set, or 0)\n"));
    }

int process(char * name)
  {
    int res = 0;
    rsbac_gid_t group = RSBAC_NO_GROUP;

    if((res = rsbac_um_get_gid(ta_number, name, &group)))
      {
        group = strtoul(name,0,0);
        if(!group && strcmp(name,"0"))
          {
            fprintf(stderr, gettext("%s: Unknown group %s\n"), progname, name);
            exit(1);
           }
      }
    if(verbose)
      printf("Deleting group %s, gid %u\n", name, group);
    res = rsbac_um_remove_group(ta_number, group);
    if(res)
      {
        fprintf(stderr, "%s: ", name);
        show_error(res);
        return res;
      }
    return 0;
  }

int main(int argc, char ** argv)
{
  int res = 0;
  int verbose = 0;

  locale_init();

  progname = argv[0];
  {
    char * env = getenv("RSBAC_TA");

    if(env)
      ta_number = strtoul(env,0,0);
  }
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'h':
                use();
                return 0;
              case 'v':
                verbose++;
                break;
              case 'N':
                if(argc > 2)
                  {
                    ta_number = strtoul(argv[2], 0, 10);
                    argc--;
                    argv++;
                  }
                else
                  {
                    fprintf(stderr, gettext("%s: missing transaction number value for parameter %c\n"), progname, *pos);
                    exit(1);
                  }
                break;

              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
                exit(1);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if (argc > 1)
    {
      int i;

      for(i=1; i< argc; i++)
        process(argv[i]);
      exit(0);
    }
  else
    {
      use();
      return 1;
    }
  return (res);
}
