#$HeadURL: https://rst2pdf.googlecode.com/svn/tags/0.9/rst2pdf/utils.py $
#$LastChangedDate: 2008-09-03 17:36:52 -0300 (Wed, 03 Sep 2008) $
#$LastChangedRevision: 265 $
import sys
from reportlab.platypus import PageBreak, Spacer
from flowables import *
import shlex
from log import log

def parseRaw (data):
    '''Parse and process a simple DSL to handle creation of flowables.

    Supported (can add others on request):

    * PageBreak

    * Spacer width, height

    '''
    elements=[]
    lines=data.splitlines()
    for line in lines:
        lexer=shlex.shlex(line)
        lexer.whitespace+=','
        tokens=list(lexer)
        command=tokens[0]
        if command == 'PageBreak':
            if len(tokens)==1:
                elements.append(MyPageBreak())
            else:
                elements.append(MyPageBreak(tokens[1]))
        if command == 'Spacer':
            elements.append(Spacer(int(tokens[1]),int(tokens[2])))
    return elements

# Looks like this is not used anywhere now
#def depth (node):
#    if node.parent==None:
#        return 0
#    else:
#        return 1+depth(node.parent)
