/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __RTL_WLAN_BITDEF_H__
#define __RTL_WLAN_BITDEF_H__

#define CPU_OPT_WIDTH 0x1F

#define BIT_APFM_OFFMAC				BIT(9)

#define BIT_SHIFT_MID_FREEPG_V1			16
#define BIT_MASK_MID_FREEPG_V1				0xfff
#define BIT_GET_MID_FREEPG_V1(x)			(((x) >> BIT_SHIFT_MID_FREEPG_V1) & BIT_MASK_MID_FREEPG_V1)

#define BIT_SHIFT_HIQ_FREEPG_V1			0
#define BIT_MASK_HIQ_FREEPG_V1				0xfff
#define BIT_GET_HIQ_FREEPG_V1(x)			(((x) >> BIT_SHIFT_HIQ_FREEPG_V1) & BIT_MASK_HIQ_FREEPG_V1)

#define BIT_SHIFT_MAC_CLK_SEL				20

#define BIT_SHIFT_PUB_FREEPG_V1			16
#define BIT_MASK_PUB_FREEPG_V1				0xfff
#define BIT_GET_PUB_FREEPG_V1(x)			(((x) >> BIT_SHIFT_PUB_FREEPG_V1) & BIT_MASK_PUB_FREEPG_V1)

#define BIT_SHIFT_LOW_FREEPG_V1			0
#define BIT_MASK_LOW_FREEPG_V1				0xfff
#define BIT_GET_LOW_FREEPG_V1(x)			(((x) >> BIT_SHIFT_LOW_FREEPG_V1) & BIT_MASK_LOW_FREEPG_V1)

#define BIT_SHIFT_EXQ_FREEPG_V1			0
#define BIT_MASK_EXQ_FREEPG_V1				0xfff
#define BIT_GET_EXQ_FREEPG_V1(x)			(((x) >> BIT_SHIFT_EXQ_FREEPG_V1) & BIT_MASK_EXQ_FREEPG_V1)

#define BIT_EF_FLAG					BIT(31)
#define BIT_SHIFT_EF_ADDR				8
#define BIT_MASK_EF_ADDR				0x3ff
#define BIT_MASK_EF_DATA				0xff

#define BIT_FSPI_EN					BIT(19)

#define BIT_LTE_MUX_CTRL_PATH				BIT(26)

#define BIT_BOOT_FSPI_EN				BIT(20)

#define BIT_FW_DW_RDY					BIT(14)

#define BIT_DMEM_CHKSUM_OK				BIT(6)
#define BIT_DMEM_DW_OK					BIT(5)
#define BIT_IMEM_CHKSUM_OK				BIT(4)
#define BIT_IMEM_DW_OK					BIT(3)

#define BIT_TXBCN0ERR_MSK				BIT(26)
#define BIT_TXBCN0OK_MSK				BIT(25)

#define BIT_BCNDMAINT0_MSK				BIT(20)
#define BIT_BCNDERR0_MSK				BIT(16)
#define BIT_HSISR_IND_ON_INT_MSK			BIT(15)

#define BIT_C2HCMD_MSK					BIT(10)
#define BIT_HIGHDOK_MSK					BIT(7)
#define BIT_MGTDOK_MSK					BIT(6)
#define BIT_BKDOK_MSK					BIT(5)
#define BIT_BEDOK_MSK					BIT(4)
#define BIT_VIDOK_MSK					BIT(3)
#define BIT_VODOK_MSK					BIT(2)
#define BIT_RDU_MSK					BIT(1)
#define BIT_RXOK_MSK					BIT(0)

#define BIT_RDU						BIT(1)
#define BIT_RXOK					BIT(0)

#define BIT_RXERR_MSK					BIT(10)
#define BIT_FOVW_MSK					BIT(8)

#define BIT_RXERR_INT					BIT(10)
#define BIT_TXFOVW					BIT(9)
#define BIT_FOVW					BIT(8)

#define BIT_USB3_USB2_TRANSITION			BIT(20)
#define BIT_SHIFT_USB23_SW_MODE_V1			18
#define BIT_MASK_USB23_SW_MODE_V1			0x3
#define BIT_USB23_SW_MODE_V1(x)			(((x) & BIT_MASK_USB23_SW_MODE_V1) << BIT_SHIFT_USB23_SW_MODE_V1)
#define BIT_GET_USB23_SW_MODE_V1(x)			(((x) >> BIT_SHIFT_USB23_SW_MODE_V1) & BIT_MASK_USB23_SW_MODE_V1)

#define BIT_NO_PDN_CHIPOFF_V1				BIT(17)

#define BIT_RSM_EN_V1					BIT(16)

#define BIT_MAC_SEC_EN					BIT(9)
#define BIT_MACRXEN					BIT(7)
#define BIT_MACTXEN					BIT(6)
#define BIT_SCHEDULE_EN					BIT(5)
#define BIT_PROTOCOL_EN					BIT(4)
#define BIT_RXDMA_EN					BIT(3)
#define BIT_TXDMA_EN					BIT(2)
#define BIT_HCI_RXDMA_EN				BIT(1)
#define BIT_HCI_TXDMA_EN				BIT(0)

#define BIT_SHIFT_TXDMA_HIQ_MAP			14
#define BIT_MASK_TXDMA_HIQ_MAP				0x3
#define BIT_TXDMA_HIQ_MAP(x)				(((x) & BIT_MASK_TXDMA_HIQ_MAP) << BIT_SHIFT_TXDMA_HIQ_MAP)

#define BIT_SHIFT_TXDMA_MGQ_MAP			12
#define BIT_MASK_TXDMA_MGQ_MAP				0x3
#define BIT_TXDMA_MGQ_MAP(x)				(((x) & BIT_MASK_TXDMA_MGQ_MAP) << BIT_SHIFT_TXDMA_MGQ_MAP)

#define BIT_SHIFT_TXDMA_BKQ_MAP			10
#define BIT_MASK_TXDMA_BKQ_MAP				0x3
#define BIT_TXDMA_BKQ_MAP(x)				(((x) & BIT_MASK_TXDMA_BKQ_MAP) << BIT_SHIFT_TXDMA_BKQ_MAP)

#define BIT_SHIFT_TXDMA_BEQ_MAP			8
#define BIT_MASK_TXDMA_BEQ_MAP				0x3
#define BIT_TXDMA_BEQ_MAP(x)				(((x) & BIT_MASK_TXDMA_BEQ_MAP) << BIT_SHIFT_TXDMA_BEQ_MAP)

#define BIT_SHIFT_TXDMA_VIQ_MAP			6
#define BIT_MASK_TXDMA_VIQ_MAP				0x3
#define BIT_TXDMA_VIQ_MAP(x)				(((x) & BIT_MASK_TXDMA_VIQ_MAP) << BIT_SHIFT_TXDMA_VIQ_MAP)

#define BIT_SHIFT_TXDMA_VOQ_MAP			4
#define BIT_MASK_TXDMA_VOQ_MAP				0x3
#define BIT_TXDMA_VOQ_MAP(x)				(((x) & BIT_MASK_TXDMA_VOQ_MAP) << BIT_SHIFT_TXDMA_VOQ_MAP)

#define BIT_MASK_BCN_HEAD_1_V1				0xfff

#define BIT_SHIFT_BLK_DESC_NUM				4
#define BIT_MASK_BLK_DESC_NUM				0xf

#define BIT_AUTO_INIT_LLT_V1				BIT(0)

#define BIT_MASK_H2C_READ_ADDR				0x3ffff

#define BIT_MASK_H2C_WR_ADDR				0x3ffff

#define BIT_MASK_BCNQ_PGBNDY_V1			0xfff

#define BIT_R_ENABLE_NDPA				BIT(31)
#define BIT_USE_NDPA_PARAMETER				BIT(30)
#define BIT_R_EN_NDPA_INT				BIT(28)

#define BIT_MASK_R_TXBF1_AID				0x1ff

#define BIT_DIS_NDP_BFEN				BIT(15)

#define BIT_R_TXBF0_80M				BIT(11)
#define BIT_R_TXBF0_40M				BIT(10)
#define BIT_R_TXBF0_20M				BIT(9)

#define BIT_MASK_R_TXBF0_AID				0x1ff

#define BIT_SHIFT_RRSC_BITMAP				0
#define BIT_MASK_RRSC_BITMAP				0xfffff
#define BIT_RRSC_BITMAP(x)				(((x) & BIT_MASK_RRSC_BITMAP) << BIT_SHIFT_RRSC_BITMAP)

#define BIT_EN_EOF_V1					BIT(2)

#define BIT_SHIFT_TXSC_40M				4
#define BIT_MASK_TXSC_40M				0xf
#define BIT_TXSC_40M(x)				(((x) & BIT_MASK_TXSC_40M) << BIT_SHIFT_TXSC_40M)

#define BIT_SHIFT_TXSC_20M				0
#define BIT_MASK_TXSC_20M				0xf
#define BIT_TXSC_20M(x)				(((x) & BIT_MASK_TXSC_20M) << BIT_SHIFT_TXSC_20M)

#define BIT_SHIFT_SIFS_OFDM_TRX			24

#define BIT_SHIFT_SIFS_CCK_TRX				16

#define BIT_SHIFT_SIFS_OFDM_CTX			8

#define BIT_BEQ_RD_INIT_EN				BIT(6)
#define BIT_VIQ_RD_INIT_EN				BIT(5)
#define BIT_VOQ_RD_INIT_EN				BIT(4)

#define BIT_SHIFT_TBTT_HOLD_TIME_AP			8

#define BIT_DIS_TSF_UDT				BIT(4)
#define BIT_EN_BCN_FUNCTION				BIT(3)

#define BIT_TSFTR_CLI3_RST				BIT(4)
#define BIT_TSFTR_CLI2_RST				BIT(3)
#define BIT_TSFTR_CLI1_RST				BIT(2)
#define BIT_TSFTR_CLI0_RST				BIT(1)
#define BIT_TSFTR_RST					BIT(0)

#define BIT_SYNC_CLI					BIT(1)

#define BIT_WMAC_TCR_ERRSTEN_3				BIT(15)
#define BIT_CFEND_FORMAT				BIT(9)

#define BIT_APP_FCS					BIT(31)
#define BIT_APP_MIC					BIT(30)
#define BIT_APP_ICV					BIT(29)
#define BIT_APP_PHYSTS					BIT(28)

#define BIT_VHT_DACK					BIT(26)

#define BIT_HTC_LOC_CTRL				BIT(14)

#define BIT_CBSSID_BCN					BIT(7)
#define BIT_CBSSID_DATA				BIT(6)
#define BIT_AB						BIT(3)
#define BIT_APM					BIT(1)

#define BIT_SHIFT_WMAC_CSI_RATE			24
#define BIT_MASK_WMAC_CSI_RATE				0x3f
#define BIT_WMAC_CSI_RATE(x)				(((x) & BIT_MASK_WMAC_CSI_RATE) << BIT_SHIFT_WMAC_CSI_RATE)

#define BIT_CSI_FORCE_RATE_EN				BIT(15)
#define BIT_SHIFT_CSI_RSC				13
#define BIT_MASK_CSI_RSC				0x3
#define BIT_CSI_RSC(x)					(((x) & BIT_MASK_CSI_RSC) << BIT_SHIFT_CSI_RSC)

#define BIT_WL_PLATFORM_RST				BIT(16)

#define BIT_SETH2CDOK_MASK				BIT(16)

#define BIT_DDMACH0_OWN				BIT(31)
#define BIT_DDMACH0_CHKSUM_EN				BIT(29)
#define BIT_DDMACH0_CHKSUM_STS				BIT(27)
#define BIT_DDMACH0_RESET_CHKSUM_STS			BIT(25)
#define BIT_DDMACH0_CHKSUM_CONT			BIT(24)
#define BIT_MASK_DDMACH0_DLEN				0x3ffff

#define BIT_MDIO_RFLAG_V1				BIT(6)
#define BIT_MDIO_WFLAG_V1				BIT(5)

#define BIT_MASK_R_MU_TABLE_VALID			0x3f

#endif/* __RTL_WLAN_BITDEF_H__ */
