/* SPDX-License-Identifier: GPL-2.0 */
/******************************************************************************
*
* Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of version 2 of the GNU General Public License as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
* more details.
*
* You should have received a copy of the GNU General Public License along with
* this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
*
*
******************************************************************************/

/*Image2HeaderVersion: 3.4*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

static boolean
check_positive(
	struct PHY_DM_STRUCT *p_dm_odm,
	const u32	condition1,
	const u32	condition2,
	const u32	condition3,
	const u32	condition4
)
{
	u8	_board_type = ((p_dm_odm->board_type & BIT(4)) >> 4) << 0 | /* _GLNA*/
			((p_dm_odm->board_type & BIT(3)) >> 3) << 1 | /* _GPA*/
			((p_dm_odm->board_type & BIT(7)) >> 7) << 2 | /* _ALNA*/
			((p_dm_odm->board_type & BIT(6)) >> 6) << 3 | /* _APA */
			((p_dm_odm->board_type & BIT(2)) >> 2) << 4 | /* _BT*/
			((p_dm_odm->board_type & BIT(1)) >> 1) << 5;  /* _NGFF*/

	u32	cond1 = condition1, cond2 = condition2, cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para = (p_dm_odm->cut_version ==  ODM_CUT_A) ? 15 : p_dm_odm->cut_version;
	u8	pkg_type_for_para = (p_dm_odm->package_type == 0) ? 15 : p_dm_odm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(p_dm_odm->support_interface & 0xF0) << 16 |
			p_dm_odm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(p_dm_odm->support_interface & 0x0F) << 8  |
			_board_type;

	u32	driver2 = (p_dm_odm->type_glna & 0xFF) <<  0 |
			(p_dm_odm->type_gpa & 0xFF)  <<  8 |
			(p_dm_odm->type_alna & 0xFF) << 16 |
			(p_dm_odm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (p_dm_odm->type_glna & 0xFF00) >>  8 |
			(p_dm_odm->type_gpa & 0xFF00) |
			(p_dm_odm->type_alna & 0xFF00) << 8 |
			(p_dm_odm->type_apa & 0xFF00)  << 16;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("===> check_positive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("===> check_positive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("	(Platform, Interface) = (0x%X, 0x%X)\n", p_dm_odm->support_platform, p_dm_odm->support_interface));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("	(Board, Package) = (0x%X, 0x%X)\n", p_dm_odm->board_type, p_dm_odm->package_type));

	/*============== value Defined Check ===============*/
	/*QFN type [15:12] and cut version [27:24] need to do value check*/

	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x00FF0FFF;
	driver1 &= 0x00FF0FFF;

	if ((cond1 & driver1) == cond1) {
		u32	bit_mask = 0;

		if ((cond1 & 0x0F) == 0) /* board_type is DONTCARE*/
			return true;

		if ((cond1 & BIT(0)) != 0) /*GLNA*/
			bit_mask |= 0x000000FF;
		if ((cond1 & BIT(1)) != 0) /*GPA*/
			bit_mask |= 0x0000FF00;
		if ((cond1 & BIT(2)) != 0) /*ALNA*/
			bit_mask |= 0x00FF0000;
		if ((cond1 & BIT(3)) != 0) /*APA*/
			bit_mask |= 0xFF000000;

		if (((cond2 & bit_mask) == (driver2 & bit_mask)) && ((cond4 & bit_mask) == (driver4 & bit_mask)))  /* board_type of each RF path is matched*/
			return true;
		else
			return false;
	} else
		return false;
}

/******************************************************************************
*                           radioa.TXT
******************************************************************************/

u32 array_mp_8821c_radioa[] = {
		0x000, 0x00010000,
		0x018, 0x00010D24,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
		0x0EF, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EF, 0x00000000,
		0x0EE, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000005DF,
		0x0EE, 0x00000000,
		0x0B0, 0x000FF0F8,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x000225D1,
		0x0B3, 0x000FC760,
		0x0B4, 0x00099DD0,
		0x0B5, 0x000400FC,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000004,
		0x0BC, 0x00040000,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C140,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000058,
		0x03F, 0x0000001C,
		0x0EE, 0x00000000,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000058,
		0x03F, 0x0000001C,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000058,
		0x03F, 0x0000002C,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x00010524,
		0x081, 0x0000FCC1,
		0x089, 0x00000004,
		0x08A, 0x0008A186,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x08B, 0x0006FFFC,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x08B, 0x0006FFFC,
	0xA0000000,	0x00000000,
		0x08B, 0x0007060C,
	0xB0000000,	0x00000000,
		0x08C, 0x000312C7,
		0x08D, 0x00020888,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x00064140,
	0xA0000000,	0x00000000,
		0x08E, 0x00064540,
	0xB0000000,	0x00000000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000A8010,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000A8010,
	0xA0000000,	0x00000000,
		0x08F, 0x000A8018,
	0xB0000000,	0x00000000,
		0x0DD, 0x00000020,
		0x0EF, 0x00020000,
		0x033, 0x00000007,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038000,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038000,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C000,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000006,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038080,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038080,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C080,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000380C8,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000380C8,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C0C8,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038190,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038190,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C190,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038998,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038998,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C998,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039840,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039840,
	0xA0000000,	0x00000000,
		0x03E, 0x0003D840,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000398C4,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000398C4,
	0xA0000000,	0x00000000,
		0x03E, 0x0003D8C4,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039930,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039930,
	0xA0000000,	0x00000000,
		0x03E, 0x0003D930,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000F,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038000,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038000,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C000,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000E,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038080,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038080,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C080,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000380C8,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000380C8,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C0C8,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038190,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038190,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C190,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038998,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038998,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C998,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039840,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039840,
	0xA0000000,	0x00000000,
		0x03E, 0x0003D840,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000398C4,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000398C4,
	0xA0000000,	0x00000000,
		0x03E, 0x0003D8C4,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039930,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039930,
	0xA0000000,	0x00000000,
		0x03E, 0x0003D930,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000017,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038000,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038000,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C000,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000016,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038080,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038080,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C080,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000380C8,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000380C8,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C0C8,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038190,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038190,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C190,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038998,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00038998,
	0xA0000000,	0x00000000,
		0x03E, 0x0003C998,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039840,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039840,
	0xA0000000,	0x00000000,
		0x03E, 0x0003D840,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000398C4,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x000398C4,
	0xA0000000,	0x00000000,
		0x03E, 0x0003D8C4,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039930,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00039930,
	0xA0000000,	0x00000000,
		0x03E, 0x0003D930,
	0xB0000000,	0x00000000,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000F,
		0x033, 0x00000001,
		0x03F, 0x0000000A,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x0EF, 0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
		0x087, 0x000E8180,
		0x088, 0x00047020,
		0x0DF, 0x00008009,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x0000001E,
		0x03F, 0x00000000,
		0x033, 0x0000001C,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000006,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000006,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000006,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000006,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000006,
	0xB0000000,	0x00000000,
		0x033, 0x00000036,
		0x03F, 0x00000000,
		0x033, 0x00000037,
		0x03F, 0x00000000,
		0x033, 0x00000034,
		0x03F, 0x00000000,
		0x033, 0x00000026,
		0x03F, 0x00000006,
		0x033, 0x00000027,
		0x03F, 0x00000006,
		0x033, 0x00000024,
		0x03F, 0x00000006,
		0x033, 0x00000022,
		0x03F, 0x00000006,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000000,
		0x033, 0x00000007,
		0x03F, 0x00000006,
		0x033, 0x00000004,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000006,
		0x033, 0x00000000,
		0x03F, 0x00000006,
		0x0EE, 0x00000000,
		0x0A0, 0x000F0005,
		0x0A1, 0x0006C000,
		0x0A2, 0x0000161B,
		0x0A3, 0x000B9D3D,
		0x0AF, 0x00070000,
		0x0DE, 0x00000200,
		0x0EE, 0x00000100,
		0x033, 0x00000007,
		0x03F, 0x00000043,
		0x033, 0x00000006,
		0x03F, 0x0000007A,
		0x033, 0x00000005,
		0x03F, 0x00000041,
		0x033, 0x00000004,
		0x03F, 0x00000079,
		0x033, 0x00000003,
		0x03F, 0x00000043,
		0x033, 0x00000002,
		0x03F, 0x0000007A,
		0x033, 0x00000001,
		0x03F, 0x00000041,
		0x033, 0x00000000,
		0x03F, 0x00000079,
		0x0EE, 0x00000000,
		0x0B8, 0x00080A00,
		0x0B0, 0x000FF0FA,
		0xFFE, 0x00000000,
		0x0CA, 0x00080000,
		0x0C9, 0x0001C141,
		0xFFE, 0x00000000,
		0x0B0, 0x000FF0F8,
		0x018, 0x00018D24,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00010D24,
		0x01B, 0x00003A40,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0004D3A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0004D3A3,
	0xA0000000,	0x00000000,
		0x061, 0x0004D3A1,
	0xB0000000,	0x00000000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x062, 0x0000D303,
	0xA0000000,	0x00000000,
		0x062, 0x0000D3A3,
	0xB0000000,	0x00000000,
		0x063, 0x00000002,
		0x0EF, 0x00000200,
		0x030, 0x00000000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x00001000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x00002000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000331A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x00003000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x00004000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x00005000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x00006000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x00007000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x00008000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x00009000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x0000A000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x030, 0x0000B000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00033303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A0,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000313A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A3,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000333A1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000335A3,
	0xA0000000,	0x00000000,
		0x03F, 0x000335A1,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000644,
		0x030, 0x00001412,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000743,
		0x030, 0x00001412,
	0xA0000000,	0x00000000,
		0x030, 0x00000640,
		0x030, 0x00001512,
	0xB0000000,	0x00000000,
		0x030, 0x00002202,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
		0x033, 0x00000020,
		0x03F, 0x00000E42,
		0x033, 0x00000021,
		0x03F, 0x00000E45,
		0x033, 0x00000022,
		0x03F, 0x00000E48,
		0x033, 0x00000023,
		0x03F, 0x00000E68,
		0x033, 0x00000024,
		0x03F, 0x00000E6B,
		0x033, 0x00000025,
		0x03F, 0x00000EAA,
		0x033, 0x00000026,
		0x03F, 0x00000EEA,
		0x033, 0x00000027,
		0x03F, 0x00000EED,
		0x033, 0x00000028,
		0x03F, 0x00000EF0,
		0x033, 0x00000029,
		0x03F, 0x00000EF3,
		0x033, 0x0000002A,
		0x03F, 0x00000EF6,
		0x033, 0x00000060,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000E0A,
	0xA0000000,	0x00000000,
		0x03F, 0x00000E09,
	0xB0000000,	0x00000000,
		0x033, 0x00000061,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000E44,
	0xA0000000,	0x00000000,
		0x03F, 0x00000E43,
	0xB0000000,	0x00000000,
		0x033, 0x00000062,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000E47,
	0xA0000000,	0x00000000,
		0x03F, 0x00000E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000063,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000E4A,
	0xA0000000,	0x00000000,
		0x03F, 0x00000E49,
	0xB0000000,	0x00000000,
		0x033, 0x00000064,
		0x03F, 0x00000E6A,
		0x033, 0x00000065,
		0x03F, 0x00000EAA,
		0x033, 0x00000066,
		0x03F, 0x00000EEB,
		0x033, 0x00000067,
		0x03F, 0x00000EEE,
		0x033, 0x00000068,
		0x03F, 0x00000EF1,
		0x033, 0x00000069,
		0x03F, 0x00000EF4,
		0x033, 0x0000006A,
		0x03F, 0x00000EF7,
		0x033, 0x000000A0,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000E08,
	0xA0000000,	0x00000000,
		0x03F, 0x00000E09,
	0xB0000000,	0x00000000,
		0x033, 0x000000A1,
		0x03F, 0x00000E42,
		0x033, 0x000000A2,
		0x03F, 0x00000E45,
		0x033, 0x000000A3,
		0x03F, 0x00000E48,
		0x033, 0x000000A4,
		0x03F, 0x00000E69,
		0x033, 0x000000A5,
		0x03F, 0x00000EA9,
		0x033, 0x000000A6,
		0x03F, 0x00000EEA,
		0x033, 0x000000A7,
		0x03F, 0x00000EED,
		0x033, 0x000000A8,
		0x03F, 0x00000EF0,
		0x033, 0x000000A9,
		0x03F, 0x00000EF3,
		0x033, 0x000000AA,
		0x03F, 0x00000EF6,
		0x0EF, 0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0006AC00,
	0xA0000000,	0x00000000,
		0x03F, 0x00086A00,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060C00,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060C00,
	0xA0000000,	0x00000000,
		0x03F, 0x00086A00,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0006AC00,
	0xA0000000,	0x00000000,
		0x03F, 0x00086A00,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00086A00,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000040,
		0x033, 0x00000001,
		0x03F, 0x00000040,
		0x033, 0x00000002,
		0x03F, 0x00000040,
		0x033, 0x00000003,
		0x03F, 0x00000040,
		0x0EF, 0x00000000,
		0x0EF, 0x00040000,
		0x033, 0x00000000,
		0x03F, 0x00086A40,
		0x033, 0x00000001,
		0x03F, 0x00086A40,
		0x033, 0x00000002,
		0x03F, 0x00086A40,
		0x033, 0x00000003,
		0x03F, 0x00086A40,
		0x033, 0x00000004,
		0x03F, 0x00086A40,
		0x033, 0x00000005,
		0x03F, 0x00086A40,
		0x033, 0x00000006,
		0x03F, 0x00084A40,
		0x033, 0x00000007,
		0x03F, 0x00084A40,
		0x0EF, 0x00000000,
		0x051, 0x000801A8,
		0x052, 0x000972E3,
		0x053, 0x00008069,
		0x054, 0x00030032,
		0x055, 0x00082003,
		0x056, 0x00051CCB,
		0x057, 0x0000CFC2,
		0x058, 0x00000010,
		0x059, 0x00030000,
		0x0EF, 0x00000800,
		0x033, 0x00000000,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051429,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051429,
	0xA0000000,	0x00000000,
		0x03F, 0x00051427,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051449,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051449,
	0xA0000000,	0x00000000,
		0x03F, 0x00051446,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0005144C,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0005144C,
	0xA0000000,	0x00000000,
		0x03F, 0x00051449,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051C66,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051C66,
	0xA0000000,	0x00000000,
		0x03F, 0x0005144C,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051C69,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051C67,
	0xA0000000,	0x00000000,
		0x03F, 0x00051C69,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051C6C,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051C6A,
	0xA0000000,	0x00000000,
		0x03F, 0x00051C6C,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CE8,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051C8B,
	0xA0000000,	0x00000000,
		0x03F, 0x00051C8D,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CEB,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CE9,
	0xA0000000,	0x00000000,
		0x03F, 0x00051CEB,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CEE,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CEC,
	0xA0000000,	0x00000000,
		0x03F, 0x00051CEE,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CF1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CEF,
	0xA0000000,	0x00000000,
		0x03F, 0x00051CF1,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CF4,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CF1,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00051CF2,
	0xA0000000,	0x00000000,
		0x03F, 0x00051CF4,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EE, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00086E00,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
		0x0EE, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x00000000,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00080000,
		0x033, 0x00000000,
		0x03F, 0x00048400,
		0x033, 0x00000001,
		0x03F, 0x00048400,
		0x033, 0x00000002,
		0x03F, 0x00048400,
		0x033, 0x00000003,
		0x03F, 0x00048400,
		0x033, 0x00000004,
		0x03F, 0x00048400,
		0x033, 0x00000005,
		0x03F, 0x00048400,
		0x033, 0x00000006,
		0x03F, 0x00048400,
		0x033, 0x00000007,
		0x03F, 0x00048400,
		0x0EE, 0x00000000,
		0x070, 0x00008000,
		0x075, 0x000027DA,
		0x076, 0x00006997,
		0x077, 0x00070418,
		0x078, 0x000BB000,
		0x07D, 0x00007600,
		0x07F, 0x00000000,
		0x06A, 0x000F4C00,
		0x065, 0x00082030,
		0x0EE, 0x00008000,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051C8D,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EE, 0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
		0x033, 0x000000A2,
		0x0EF, 0x00080000,
		0x03E, 0x0000593F,
		0x03F, 0x000C0F4F,
		0x0EF, 0x00000000,
		0x033, 0x000000A3,
		0x0EF, 0x00080000,
		0x03E, 0x00005934,
		0x03F, 0x0005AFCF,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x00060FDE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x0005EFCE,
		0x0EF, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000004,
		0x03F, 0x00001EC1,
		0x0EE, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000005,
		0x03F, 0x00001ECF,
		0x0EE, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000006,
		0x03F, 0x00001F9D,
		0x0EE, 0x00000000,

};

void
odm_read_and_config_mp_8821c_radioa(
	struct	PHY_DM_STRUCT *p_dm_odm
)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = sizeof(array_mp_8821c_radioa)/sizeof(u32);
	u32	*array = array_mp_8821c_radioa;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8821c_radioa\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29)|BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped?false:true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_a_8821c(p_dm_odm, v1, v2);
		}
		i = i + 2;
	}
}

/******************************************************************************
*                           txpowertrack.TXT
******************************************************************************/

u8 g_delta_swing_table_idx_mp_5gb_n_txpowertrack_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 2, 3, 4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12},
};
u8 g_delta_swing_table_idx_mp_5gb_p_txpowertrack_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
};
u8 g_delta_swing_table_idx_mp_5ga_n_txpowertrack_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 2, 3, 4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12},
};
u8 g_delta_swing_table_idx_mp_5ga_p_txpowertrack_8821c[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 1, 1, 2, 3, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12},
};
u8 g_delta_swing_table_idx_mp_2gb_n_txpowertrack_8821c[]    = {0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9};
u8 g_delta_swing_table_idx_mp_2gb_p_txpowertrack_8821c[]    = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9};
u8 g_delta_swing_table_idx_mp_2ga_n_txpowertrack_8821c[]    = {0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9};
u8 g_delta_swing_table_idx_mp_2ga_p_txpowertrack_8821c[]    = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9};
u8 g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_8821c[] = {0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9};
u8 g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_8821c[] = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9};
u8 g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_8821c[] = {0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9};
u8 g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_8821c[] = {0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9};

void
odm_read_and_config_mp_8821c_txpowertrack(
	struct PHY_DM_STRUCT	 *p_dm_odm
)
{
	struct odm_rf_calibration_structure  *p_rf_calibrate_info = &(p_dm_odm->rf_calibrate_info);

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_mp_8821c\n"));

	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_p, g_delta_swing_table_idx_mp_2ga_p_txpowertrack_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2ga_n, g_delta_swing_table_idx_mp_2ga_n_txpowertrack_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_p, g_delta_swing_table_idx_mp_2gb_p_txpowertrack_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2gb_n, g_delta_swing_table_idx_mp_2gb_n_txpowertrack_8821c, DELTA_SWINGIDX_SIZE);

	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_p, g_delta_swing_table_idx_mp_2g_cck_a_p_txpowertrack_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_a_n, g_delta_swing_table_idx_mp_2g_cck_a_n_txpowertrack_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_p, g_delta_swing_table_idx_mp_2g_cck_b_p_txpowertrack_8821c, DELTA_SWINGIDX_SIZE);
	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_2g_cck_b_n, g_delta_swing_table_idx_mp_2g_cck_b_n_txpowertrack_8821c, DELTA_SWINGIDX_SIZE);

	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_p, g_delta_swing_table_idx_mp_5ga_p_txpowertrack_8821c, DELTA_SWINGIDX_SIZE*3);
	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5ga_n, g_delta_swing_table_idx_mp_5ga_n_txpowertrack_8821c, DELTA_SWINGIDX_SIZE*3);
	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_p, g_delta_swing_table_idx_mp_5gb_p_txpowertrack_8821c, DELTA_SWINGIDX_SIZE*3);
	odm_move_memory(p_dm_odm, p_rf_calibrate_info->delta_swing_table_idx_5gb_n, g_delta_swing_table_idx_mp_5gb_n_txpowertrack_8821c, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           txpwr_lmt.TXT
******************************************************************************/

const char *array_mp_8821c_txpwr_lmt[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "30",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "32",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "24",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "16",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "30",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "34",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "16",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "30",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "34",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "32",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "28",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "12",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "30",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "34",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "26",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "28",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "20",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "30",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "31",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "31",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "31",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "33",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "30",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "33",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "33",
	"FCC", "5G", "20M", "HT", "1T", "40", "33",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "33",
	"FCC", "5G", "20M", "HT", "1T", "44", "33",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "33",
	"FCC", "5G", "20M", "HT", "1T", "48", "33",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "33",
	"FCC", "5G", "20M", "HT", "1T", "52", "33",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "33",
	"FCC", "5G", "20M", "HT", "1T", "56", "33",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "33",
	"FCC", "5G", "20M", "HT", "1T", "60", "33",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "33",
	"FCC", "5G", "20M", "HT", "1T", "64", "30",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "33",
	"FCC", "5G", "20M", "HT", "1T", "100", "30",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "33",
	"FCC", "5G", "20M", "HT", "1T", "104", "33",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "33",
	"FCC", "5G", "20M", "HT", "1T", "108", "33",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "33",
	"FCC", "5G", "20M", "HT", "1T", "112", "33",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "33",
	"FCC", "5G", "20M", "HT", "1T", "116", "33",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "33",
	"FCC", "5G", "20M", "HT", "1T", "120", "33",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "33",
	"FCC", "5G", "20M", "HT", "1T", "124", "33",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "33",
	"FCC", "5G", "20M", "HT", "1T", "128", "33",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "33",
	"FCC", "5G", "20M", "HT", "1T", "132", "33",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "33",
	"FCC", "5G", "20M", "HT", "1T", "136", "33",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "33",
	"FCC", "5G", "20M", "HT", "1T", "140", "29",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "33",
	"FCC", "5G", "20M", "HT", "1T", "144", "27",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "63",
	"FCC", "5G", "20M", "HT", "1T", "149", "33",
	"ETSI", "5G", "20M", "HT", "1T", "149", "63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "33",
	"ETSI", "5G", "20M", "HT", "1T", "153", "63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "33",
	"ETSI", "5G", "20M", "HT", "1T", "157", "63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "33",
	"ETSI", "5G", "20M", "HT", "1T", "161", "63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "33",
	"ETSI", "5G", "20M", "HT", "1T", "165", "63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "22",
	"ETSI", "5G", "40M", "HT", "1T", "38", "32",
	"MKK", "5G", "40M", "HT", "1T", "38", "32",
	"FCC", "5G", "40M", "HT", "1T", "46", "32",
	"ETSI", "5G", "40M", "HT", "1T", "46", "32",
	"MKK", "5G", "40M", "HT", "1T", "46", "32",
	"FCC", "5G", "40M", "HT", "1T", "54", "32",
	"ETSI", "5G", "40M", "HT", "1T", "54", "32",
	"MKK", "5G", "40M", "HT", "1T", "54", "32",
	"FCC", "5G", "40M", "HT", "1T", "62", "23",
	"ETSI", "5G", "40M", "HT", "1T", "62", "32",
	"MKK", "5G", "40M", "HT", "1T", "62", "32",
	"FCC", "5G", "40M", "HT", "1T", "102", "21",
	"ETSI", "5G", "40M", "HT", "1T", "102", "32",
	"MKK", "5G", "40M", "HT", "1T", "102", "32",
	"FCC", "5G", "40M", "HT", "1T", "110", "32",
	"ETSI", "5G", "40M", "HT", "1T", "110", "32",
	"MKK", "5G", "40M", "HT", "1T", "110", "32",
	"FCC", "5G", "40M", "HT", "1T", "118", "32",
	"ETSI", "5G", "40M", "HT", "1T", "118", "32",
	"MKK", "5G", "40M", "HT", "1T", "118", "32",
	"FCC", "5G", "40M", "HT", "1T", "126", "32",
	"ETSI", "5G", "40M", "HT", "1T", "126", "32",
	"MKK", "5G", "40M", "HT", "1T", "126", "32",
	"FCC", "5G", "40M", "HT", "1T", "134", "32",
	"ETSI", "5G", "40M", "HT", "1T", "134", "32",
	"MKK", "5G", "40M", "HT", "1T", "134", "32",
	"FCC", "5G", "40M", "HT", "1T", "142", "29",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "32",
	"ETSI", "5G", "40M", "HT", "1T", "151", "63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "32",
	"ETSI", "5G", "40M", "HT", "1T", "159", "63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "19",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "32",
	"MKK", "5G", "80M", "VHT", "1T", "42", "28",
	"FCC", "5G", "80M", "VHT", "1T", "58", "22",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "32",
	"MKK", "5G", "80M", "VHT", "1T", "58", "28",
	"FCC", "5G", "80M", "VHT", "1T", "106", "18",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "32",
	"MKK", "5G", "80M", "VHT", "1T", "106", "32",
	"FCC", "5G", "80M", "VHT", "1T", "122", "32",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "32",
	"MKK", "5G", "80M", "VHT", "1T", "122", "32",
	"FCC", "5G", "80M", "VHT", "1T", "138", "28",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "32",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63"
};

void
odm_read_and_config_mp_8821c_txpwr_lmt(
	struct PHY_DM_STRUCT	*p_dm_odm
)
{
	u32	i = 0;
	u32	array_len = sizeof(array_mp_8821c_txpwr_lmt)/sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8821c_txpwr_lmt;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8821c_txpwr_lmt\n"));

	for (i = 0; i < array_len; i += 7) {
		u8	*regulation = array[i];
		u8	*band = array[i+1];
		u8	*bandwidth = array[i+2];
		u8	*rate = array[i+3];
		u8	*rf_path = array[i+4];
		u8	*chnl = array[i+5];
		u8	*val = array[i+6];

		odm_config_bb_txpwr_lmt_8821c(p_dm_odm, regulation, band, bandwidth, rate, rf_path, chnl, val);
	}

}


