/*
*  Rubrica
*  file: import.h
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _IMPORT_H
#define _IMPORT_H

#include "rubrica.h"
#include "vcard.h"

typedef enum {
  IMPORT_GNOMECARD = 0,
  IMPORT_KAB,
  IMPORT_RUBRICA,
  IMPORT_CSV_MOZILLA, 
  IMPORT_CSV_NETSCAPE, 
  IMPORT_VCARD,
  IMPORT_PINE
} RubricaImportType;


void rubrica_import_init(GtkWidget *fentry, RubricaImportType import);
void rubrica_import_set(RubricaImportType imp);
RubricaImportType rubrica_import_get(void);


gboolean rubrica_import_data(GtkWidget *app);

gboolean rubrica_import_open_vcard_file(gchar *file);
gboolean rubrica_import_open_csv_file(gchar *file);
gboolean rubrica_import_open_old_rubrica_file(gchar *fname);
void     rubrica_import_decoded_vcard_item(RubricaVCard* vcard,
					   gpointer data);



#endif
