/*
*  Rubrica
*  file: form_cb.c
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <config.h>

#include <gnome.h>
#include <string.h>

#include "form_card.h"
#include "form_cb.h"
#include "form_int.h"
#include "utils.h"



void option_check_toggled(GtkToggleButton *togglebutton, gpointer data)
{
  gtk_widget_set_sensitive(GTK_WIDGET(data),
			   gtk_toggle_button_get_active
			   (GTK_TOGGLE_BUTTON(togglebutton)));
}


void married_check_toggled(GtkToggleButton *togglebutton, gpointer data)
{
  RubricaCardForm *form = (RubricaCardForm *) data;
  gboolean married;
  gboolean birthday;
  gboolean anniversary;
  
  married     = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));
  birthday    = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->notes.birthknow));
  anniversary = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->notes.anniverknow));
  
  gtk_widget_set_sensitive(GTK_WIDGET(form->notes.birthknow), married);
  gtk_widget_set_sensitive(GTK_WIDGET(form->notes.anniverknow), married);

  if (married)
    {
      gtk_widget_set_sensitive(GTK_WIDGET(form->notes.birthdate), birthday);
      gtk_widget_set_sensitive(GTK_WIDGET(form->notes.anniverdate), 
			       anniversary);  
    }
  else
    {
      gtk_widget_set_sensitive(GTK_WIDGET(form->notes.birthdate), FALSE);
      gtk_widget_set_sensitive(GTK_WIDGET(form->notes.anniverdate), FALSE);
    }
}

void entry_activate(GtkEditable *editable, gpointer data)
{  
  gtk_signal_emit_by_name(GTK_OBJECT(data), "clicked");
}

void rubrica_form_web_list_activated(GtkTreeSelection *selection, 
				     gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  RubricaCardForm *form = (RubricaCardForm *) data;
  gchar *str;

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.web_tree));

  if (gtk_tree_selection_get_selected(selection, &model, &iter))
    {
      gtk_tree_model_get(model, &iter, URI_COLUMN, &str, -1);
      
      gtk_entry_set_text(GTK_ENTRY(form->net.web), str);
      
      gtk_widget_set_sensitive(form->net.web_mod, TRUE);
      gtk_widget_set_sensitive(form->net.web_del, TRUE);
      g_free(str);
    }
}


void
web_add_clicked (GtkButton *button, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *str;
  RubricaCardForm *form = (RubricaCardForm *) data;
  
  gtk_widget_set_sensitive(GTK_WIDGET(form->net.web_mod), FALSE);
  gtk_widget_set_sensitive(GTK_WIDGET(form->net.web_del), FALSE);

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.web_tree));
  str = g_strdup(gtk_entry_get_text(GTK_ENTRY(form->net.web)));

  gtk_list_store_append(GTK_LIST_STORE(model), &iter);
  gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
		     URI_COLUMN, str, -1);

  gtk_entry_set_text(GTK_ENTRY(form->net.web),"");
}


void
web_mod_clicked (GtkButton *button, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreeSelection *selection;
  RubricaCardForm *form = (RubricaCardForm *) data;
  gchar *str = NULL;

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.web_tree));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(form->net.web_tree));
  str = g_strdup(gtk_entry_get_text(GTK_ENTRY(form->net.web)));

  if (gtk_tree_selection_get_selected(selection, NULL, &iter))
  {
    gint i;
    GtkTreePath *path;
    
    path = gtk_tree_model_get_path(model, &iter);
    i = gtk_tree_path_get_indices(path)[0];
    
    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
    gtk_tree_path_free(path);
    
    gtk_list_store_insert(GTK_LIST_STORE(model), &iter, i);
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
		       URI_COLUMN, str, -1);

    gtk_entry_set_text(GTK_ENTRY(form->net.web),"");

    gtk_widget_set_sensitive(GTK_WIDGET(form->net.web_mod), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(form->net.web_del), FALSE);   
  }  
}


void
web_del_clicked (GtkButton *button, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreeSelection *selection;
  RubricaCardForm *form = (RubricaCardForm *) data;
  
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.web_tree));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(form->net.web_tree));
  
  if (gtk_tree_selection_get_selected(selection, NULL, &iter))
  {
    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
   
    gtk_entry_set_text(GTK_ENTRY(form->net.web),"");

    gtk_widget_set_sensitive(GTK_WIDGET(form->net.web_mod), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(form->net.web_del), FALSE);   
  }  
}

void rubrica_form_email_list_activated(GtkTreeSelection *selection, 
				       gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  RubricaCardForm *form = (RubricaCardForm *) data;
  gchar *str;

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.email_tree));

  if (gtk_tree_selection_get_selected(selection, &model, &iter))
    {
      gtk_tree_model_get(model, &iter, URI_COLUMN, &str, -1);
      
      gtk_entry_set_text(GTK_ENTRY(form->net.email), str);
      
      gtk_widget_set_sensitive(form->net.email_mod, TRUE);
      gtk_widget_set_sensitive(form->net.email_del, TRUE);
      g_free(str);
    }
}

void
email_add_clicked (GtkButton *button, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *str;
  RubricaCardForm *form = (RubricaCardForm *) data;

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.email_tree));
  str = g_strdup(gtk_entry_get_text(GTK_ENTRY(form->net.email)));

  gtk_list_store_append(GTK_LIST_STORE(model), &iter);
  gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
		     URI_COLUMN, str, -1);

  gtk_entry_set_text(GTK_ENTRY(form->net.email),"");
  
  gtk_widget_set_sensitive(GTK_WIDGET(form->net.email_mod), FALSE);
  gtk_widget_set_sensitive(GTK_WIDGET(form->net.email_del), FALSE);  
}


void
email_mod_clicked (GtkButton *button, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreeSelection *selection;
  RubricaCardForm *form = (RubricaCardForm *) data;
  gchar *str = NULL;

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.email_tree));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(form->net.email_tree));
  str = g_strdup(gtk_entry_get_text(GTK_ENTRY(form->net.email)));

  if (gtk_tree_selection_get_selected(selection, NULL, &iter))
  {
    gint i;
    GtkTreePath *path;
    
    path = gtk_tree_model_get_path(model, &iter);
    i = gtk_tree_path_get_indices(path)[0];
    
    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
    gtk_tree_path_free(path);
    
    gtk_list_store_insert(GTK_LIST_STORE(model), &iter, i);
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
		       URI_COLUMN, str, -1);

    gtk_entry_set_text(GTK_ENTRY(form->net.email),"");

    gtk_widget_set_sensitive(GTK_WIDGET(form->net.email_mod), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(form->net.email_del), FALSE);   
  }  
}


void
email_del_clicked (GtkButton *button, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreeSelection *selection;
  RubricaCardForm *form = (RubricaCardForm *) data;
  
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.email_tree));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(form->net.email_tree));
  
  if (gtk_tree_selection_get_selected(selection, NULL, &iter))
  {
    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
   
    gtk_entry_set_text(GTK_ENTRY(form->net.email),"");

    gtk_widget_set_sensitive(GTK_WIDGET(form->net.email_mod), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(form->net.email_del), FALSE);   
  }  
}


void rubrica_form_telephone_list_activated(GtkTreeSelection *selection, 
					   gpointer data)
{
  RubricaTelephoneType type;
  GtkTreeModel *model;
  GtkTreeIter iter;
  RubricaCardForm *form = (RubricaCardForm *) data;
  gchar *numb_str;
  gchar *type_str;

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->tel.tree));

  if (gtk_tree_selection_get_selected(selection, &model, &iter))
    {
      gtk_tree_model_get(model, &iter, NUMBER_COLUMN, &numb_str, -1);
      gtk_tree_model_get(model, &iter, TYPE_COLUMN, &type_str, -1); 
      
      gtk_entry_set_text(GTK_ENTRY(form->tel.number), numb_str);
     
      type = rubrica_utils_telephone2int(type_str);

      switch (type)
	{
	case TELEPHONE_HOME:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->tel.radiohome),
				       TRUE);
	  break;
	case TELEPHONE_WORK:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->tel.radiowork),
				       TRUE);
	  break;
	case TELEPHONE_FAX:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->tel.radiofax), 
				       TRUE);
	  break;
	case TELEPHONE_CELLPHONE:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->tel.radiocell),
				       TRUE);
	  break; 
	case TELEPHONE_OTHER:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->tel.radioother),
				       TRUE);
	  break; 

	default:
	  break;
	}      
      
      gtk_widget_set_sensitive(form->tel.tel_mod, TRUE);
      gtk_widget_set_sensitive(form->tel.tel_del, TRUE);
      g_free(numb_str);
      g_free(type_str);
    }
}


void
tel_add_clicked (GtkButton *button, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *numb_str = NULL;
  gchar *type_str = NULL;
  RubricaCardForm *form = (RubricaCardForm *) data;

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->tel.tree));
  numb_str = g_strdup(gtk_entry_get_text(GTK_ENTRY(form->tel.number)));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radiohome)))
    type_str = "home";
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radiowork)))
    type_str = "work";
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radiofax)))
    type_str = "fax";
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radiocell)))
    type_str = "cellphone";
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radioother)))
    type_str = "other";

  gtk_list_store_append(GTK_LIST_STORE(model), &iter);
  gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
		     NUMBER_COLUMN, numb_str, 
		     TYPE_COLUMN, type_str,
		     -1);

  gtk_entry_set_text(GTK_ENTRY(form->tel.number),"");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->tel.radiohome), TRUE);
    
  gtk_widget_set_sensitive(GTK_WIDGET(form->tel.tel_mod), FALSE);
  gtk_widget_set_sensitive(GTK_WIDGET(form->tel.tel_del), FALSE);  
}


void
tel_mod_clicked (GtkButton *button, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreeSelection *selection;
  RubricaCardForm *form = (RubricaCardForm *) data;
  gchar *numb_str = NULL;
  gchar *type_str = NULL;


  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->tel.tree));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(form->tel.tree));
  numb_str = g_strdup(gtk_entry_get_text(GTK_ENTRY(form->tel.number)));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radiohome)))
    type_str = "home";
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radiowork)))
    type_str = "work";
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radiofax)))
    type_str = "fax";
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radiocell)))
    type_str = "cellphone";
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->tel.radioother)))
    type_str = "other";

  if (gtk_tree_selection_get_selected(selection, NULL, &iter))
  {
    gint i;
    GtkTreePath *path;
    
    path = gtk_tree_model_get_path(model, &iter);
    i = gtk_tree_path_get_indices(path)[0];
    
    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
    gtk_tree_path_free(path);
    
    gtk_list_store_insert(GTK_LIST_STORE(model), &iter, i);
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
		       NUMBER_COLUMN, numb_str, 
		       TYPE_COLUMN, type_str,
		       -1);

    gtk_entry_set_text(GTK_ENTRY(form->net.email),"");

    gtk_widget_set_sensitive(GTK_WIDGET(form->tel.tel_mod), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(form->tel.tel_del), FALSE);   
  }  
}


void
tel_del_clicked (GtkButton *button, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreeSelection *selection;
  RubricaCardForm *form = (RubricaCardForm *) data;


  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->tel.tree));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(form->tel.tree));

  if (gtk_tree_selection_get_selected(selection, NULL, &iter))
  {
    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
    
    gtk_entry_set_text(GTK_ENTRY(form->net.email),"");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->tel.radiohome), TRUE);

    gtk_widget_set_sensitive(GTK_WIDGET(form->tel.tel_mod), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(form->tel.tel_del), FALSE);   
  }  
}




