/*
*  Rubrica
*  file: log.c
*
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <config.h>

#include <gnome.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "prefer.h"

gchar buf[128];
gboolean log_enabled = TRUE;
gchar *log_file = NULL;
FILE  *rlog = NULL;

void rubrica_log_init_log_file(void)
{
  gchar *rubrica_home;
  time_t curtime; 
  struct tm *loctime; 

  g_print("\nRubrica: opening log file..."); 

  curtime = time(NULL); 
  loctime = localtime(&curtime);
  strftime(buf, 128, "\nRubrica starting: %A %B %Y at %I:%M", loctime); 

  rubrica_home = rubrica_preferences_get_rubrica_home();

  if (g_file_exists(rubrica_home))
    log_file = g_strdup_printf("%s/rubrica.log", rubrica_home);
  else
    log_file = g_strdup_printf("%s/rubrica.log", g_get_home_dir());

  rlog = fopen(log_file, "a+");

  if(rlog == NULL)
    { 
      g_print("\nRubrica: can't open log file %s)", log_file); 
    } 
  else 
    {  
      g_print("\nRubrica: log file %s opened", log_file); 

      fprintf (rlog, "%s", buf);  
      fflush(rlog);
    } 

  g_free(log_file);
} 


void rubrica_log_write_log(gchar *str)
{
/*
  if (!log_enabled)
    return;
*/

  if (!rlog)
    return;

  g_print("\n%s", str);
  fprintf(rlog, "%s", str);  
  fflush(rlog);
}


void rubrica_log_close_log_file(void)
{
  time_t curtime; 
  struct tm *loctime; 

  if (!rlog)
    return;
  
  curtime = time(NULL); 
  loctime = localtime(&curtime);
  strftime(buf, 128, "\nRubrica closed: %A %B %Y at %I:%M", loctime);

  fprintf (rlog, "%s\n\n", buf);  
  
  fflush(rlog);
  fclose(rlog);
}
